/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import pro.projo.Builder;
import pro.projo.Projo;
import pro.projo.internal.PropertyMatcher;
import pro.projo.utilities.MethodFunctionConverter;
import pro.projo.utilities.TryCatchUtilities;

public class ProjoJacksonValueInstantiator<_Artifact_>
extends ValueInstantiator.Base
implements TryCatchUtilities {
    private PropertyMatcher propertyMatcher = new PropertyMatcher();
    private MethodFunctionConverter converter = new MethodFunctionConverter();

    public ProjoJacksonValueInstantiator(Class<_Artifact_> type) {
        super(type);
    }

    public boolean canCreateFromObjectWith() {
        return true;
    }

    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig configuration) {
        Method[] properties = Projo.getGetterMethods((Class)this.getValueClass());
        return (SettableBeanProperty[])IntStream.range(0, properties.length).mapToObj(index -> new AbstractMap.SimpleEntry<Integer, Method>(index, properties[index])).map(entry -> this.getSettableBeanProperty((Map.Entry<Integer, Method>)entry, configuration)).toArray(SettableBeanProperty[]::new);
    }

    public Object createFromObjectWith(DeserializationContext context, SettableBeanProperty[] properties, PropertyValueBuffer values) throws IOException {
        Class type = Projo.getInterfaceClass((Class)this.getValueClass());
        Builder builder = Projo.builder((Class)type);
        Method[] getters = Projo.getGetterMethods((Class)type);
        DeserializationConfig configuration = context.getConfig();
        Map propertyMap = Stream.of(properties).collect(Collectors.toMap(SettableBeanProperty::getName, Function.identity()));
        for (Method getter : getters) {
            Function getterFunction = this.converter.convert(getter);
            String propertyName = this.getPropertyName(getter, configuration).getSimpleName();
            SettableBeanProperty property = (SettableBeanProperty)propertyMap.get(propertyName);
            builder = builder.with(getterFunction, values.getParameter(property));
        }
        return builder.build();
    }

    private SettableBeanProperty getSettableBeanProperty(Map.Entry<Integer, Method> method, DeserializationConfig configuration) {
        Method getter = method.getValue();
        PropertyName propertyName = this.getPropertyName(getter, configuration);
        JavaType returnType = TypeFactory.defaultInstance().constructType(getter.getReturnType());
        return new CreatorProperty(propertyName, returnType, null, null, null, null, method.getKey().intValue(), null, null);
    }

    private PropertyName getPropertyName(Method getter, DeserializationConfig configuration) {
        JavaType type = configuration.getTypeFactory().constructType(getter.getDeclaringClass());
        AnnotatedClass annotatedClass = AnnotatedClass.construct((JavaType)type, (MapperConfig)configuration);
        AnnotatedMethod annotatedMethod = annotatedClass.findMethod(getter.getName(), (Class[])getter.getParameterTypes());
        AnnotationIntrospector introspector = configuration.getAnnotationIntrospector();
        PropertyName name = introspector.findNameForDeserialization((Annotated)annotatedMethod);
        return name != null ? name : new PropertyName(this.propertyMatcher.propertyName(getter.getName()));
    }
}

