/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import pro.projo.Projo;
import pro.projo.internal.PropertyMatcher;

public class ProjoJacksonSerializer
extends BeanSerializer {
    private static final long serialVersionUID = 7949066175006042890L;
    private static TypeFactory typeFactory = TypeFactory.defaultInstance();
    private static PropertyMatcher propertyMatcher = new PropertyMatcher();

    protected ProjoJacksonSerializer(SerializationConfig configuration, JavaType type, BeanDescription bean) {
        super(type, null, ProjoJacksonSerializer.properties(configuration, type, bean), null);
    }

    private static BeanPropertyWriter[] properties(SerializationConfig configuration, JavaType type, BeanDescription bean) {
        Stream<Method> getters = Stream.of(Projo.getGetterMethods((Class)type.getRawClass()));
        return (BeanPropertyWriter[])getters.map(getter -> ProjoJacksonSerializer.getBeanPropertyWriter(configuration, bean, getter)).toArray(BeanPropertyWriter[]::new);
    }

    private static BeanPropertyWriter getBeanPropertyWriter(SerializationConfig configuration, final BeanDescription bean, final Method method) {
        String propertyName = propertyMatcher.propertyName(method.getName());
        AnnotationIntrospector introspector = configuration.getAnnotationIntrospector();
        POJOPropertyBuilder propDef = new POJOPropertyBuilder((MapperConfig)configuration, introspector, true, new PropertyName(propertyName)){

            public AnnotatedMethod getGetter() {
                return new AnnotatedMethod((TypeResolutionContext)bean.getClassInfo(), method, null, new AnnotationMap[0]);
            }
        };
        Annotations contextAnnotations = null;
        JavaType propertyType = typeFactory.constructType(method.getReturnType());
        return new AttributePropertyWriter(propertyName, (BeanPropertyDefinition)propDef, contextAnnotations, propertyType, JsonInclude.Value.empty()){
            private static final long serialVersionUID = -8204427561857269317L;

            protected Object value(Object object, JsonGenerator generator, SerializerProvider serializerProvider) throws Exception {
                return method.invoke(object, new Object[0]);
            }
        };
    }
}

