/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.internal.rcg.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import pro.projo.internal.rcg.RuntimeCodeGenerationHandler;

public class ValueObject {
    private static final Predicate<Method> gettersOnly = method -> method.getParameterCount() == 0 && !Void.TYPE.equals(method.getReturnType()) && !"hashCode".equals(method.getName());

    public boolean equals(Object other) {
        if (this.getClass().isInstance(other)) {
            ValueObject that = (ValueObject)other;
            Predicate<Method> valuesEqual = method -> {
                Object thisValue = this.value((Method)method);
                Object thatValue = that.value((Method)method);
                return thisValue == null ? thatValue == null : thisValue.equals(thatValue);
            };
            Predicate<Method> valuesNotEqual = valuesEqual.negate();
            return this.getters().filter(valuesNotEqual).count() == 0L;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getters().map(this::value).toArray(Object[]::new));
    }

    public String toString() {
        return RuntimeCodeGenerationHandler.getInterfaceName(this.getClass()) + "@" + Integer.toHexString(this.hashCode());
    }

    private Stream<Method> getters() {
        return Stream.of(this.getClass().getDeclaredMethods()).filter(gettersOnly);
    }

    private Object value(Method getter) {
        try {
            return getter.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException illegalAccess) {
            IllegalAccessError error = new IllegalAccessError(illegalAccess.getMessage());
            error.initCause(illegalAccess);
            throw error;
        }
        catch (InvocationTargetException exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

