/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.internal.rcg;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import pro.projo.Mapping;
import pro.projo.Projo;
import pro.projo.annotations.Delegate;
import pro.projo.internal.Default;
import pro.projo.internal.ProjoHandler;
import pro.projo.internal.PropertyMatcher;
import pro.projo.internal.rcg.RuntimeCodeGenerationHandler;

public class RuntimeCodeGenerationProjo
extends Projo {
    private RuntimeCodeGenerationHandler<?> handler = new RuntimeCodeGenerationHandler();

    protected int precedence() {
        return 0;
    }

    public <_Artifact_> ProjoHandler<_Artifact_> getHandler(Class<_Artifact_> type) {
        RuntimeCodeGenerationHandler<?> projoHandler = this.handler;
        return projoHandler;
    }

    public <_Artifact_> ProjoHandler.ProjoInitializer initializer(final Class<_Artifact_> type, final Class<?> ... additionalInterfaces) {
        RuntimeCodeGenerationHandler<?> projoHandler;
        RuntimeCodeGenerationHandler<?> runtimeCodeGenerationHandler = projoHandler = this.handler;
        Objects.requireNonNull(runtimeCodeGenerationHandler);
        return new ProjoHandler.ProjoInitializer(runtimeCodeGenerationHandler){

            @SafeVarargs
            public final ProjoHandler.ProjoMembers members(final Function<_Artifact_, ?> ... getters) {
                return new ProjoHandler.ProjoInitializer.ProjoMembers(){

                    public _Artifact_ returnInstance() {
                        try {
                            Class implementation = this.isProxiedInterface(type) ? projoHandler.getProxyImplementationOf(type, true, new Class[0]) : projoHandler.getImplementationOf(type);
                            Object instance = implementation.getConstructor(new Class[0]).newInstance(new Object[0]);
                            return instance;
                        }
                        catch (NoSuchMethodException exception) {
                            throw new NoSuchMethodError(exception.getMessage());
                        }
                        catch (InvocationTargetException exception) {
                            Throwable cause = exception.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new RuntimeException(cause.getMessage(), cause);
                        }
                        catch (InstantiationException exception) {
                            throw new RuntimeException(exception.getMessage(), exception);
                        }
                        catch (IllegalAccessException illegalAccess) {
                            throw new IllegalAccessError(illegalAccess.getMessage());
                        }
                    }

                    public _Artifact_ with(Object ... values) {
                        if (values.length == getters.length) {
                            Object instance = this.returnInstance();
                            Class<?> implementationClass = instance.getClass();
                            String[] fieldNames = RuntimeCodeGenerationProjo.this.getFieldNames(type, getters);
                            for (int index = 0; index < values.length; ++index) {
                                try {
                                    Field field = implementationClass.getDeclaredField(fieldNames[index]);
                                    Object value = values[index] != null ? values[index] : Default.VALUES.get(field.getType());
                                    field.setAccessible(true);
                                    field.set(instance, value);
                                    try {
                                        if (!type.getDeclaredMethod(fieldNames[index], new Class[0]).isAnnotationPresent(Delegate.class)) continue;
                                        Field delegate = implementationClass.getDeclaredField("delegate");
                                        delegate.setAccessible(true);
                                        delegate.set(instance, value);
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {}
                                    continue;
                                }
                                catch (NoSuchFieldException noSuchField) {
                                    throw new NoSuchFieldError(noSuchField.getMessage());
                                }
                                catch (IllegalAccessException illegalAccess) {
                                    throw new IllegalAccessError(illegalAccess.getMessage());
                                }
                            }
                            return instance;
                        }
                        throw new RuntimeException("Mismatch: " + getters.length + " getters, " + values.length + " values");
                    }
                };
            }

            public ProjoHandler.ProjoMembers delegate(Object delegate, Mapping<?> mapping) {
                return null;
            }

            public ProjoHandler.ProjoMembers proxy(final Object delegate, Class<?> proxyInterface, final boolean override) {
                return new ProjoHandler.ProjoInitializer.ProjoMembers(){

                    public _Artifact_ returnInstance() {
                        try {
                            Constructor<?>[] constructors = projoHandler.getProxyImplementationOf(type, override, additionalInterfaces).getConstructors();
                            Constructor constructor = Stream.of(constructors).filter(it -> it.getParameterCount() == 1).findFirst().get();
                            return constructor.newInstance(delegate);
                        }
                        catch (InvocationTargetException exception) {
                            Throwable cause = exception.getCause();
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new RuntimeException(cause.getMessage(), cause);
                        }
                        catch (InstantiationException exception) {
                            throw new RuntimeException(exception.getMessage(), exception);
                        }
                        catch (IllegalAccessException illegalAccess) {
                            throw new IllegalAccessError(illegalAccess.getMessage());
                        }
                    }

                    public _Artifact_ with(Object ... values) {
                        return null;
                    }
                };
            }
        };
    }

    public <_Artifact_> String[] getFieldNames(Class<_Artifact_> type, Function<_Artifact_, ?>[] getters) {
        ArrayList fieldNames = new ArrayList();
        PropertyMatcher matcher = new PropertyMatcher();
        InvocationHandler invocationHandler = (proxy, method, args) -> {
            fieldNames.add(matcher.propertyName(method.getName()));
            return Default.VALUES.get(method.getReturnType());
        };
        Class[] interfaces = new Class[]{type};
        ClassLoader classLoader = type.getClassLoader();
        Object instance = Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
        Stream.of(getters).forEach(getter -> getter.apply(instance));
        return fieldNames.toArray(new String[0]);
    }
}

