/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.internal.rcg.utilities;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenericTypeResolver {
    public static <T> Type getReturnType(Method originalMethodDeclaration, Class<? extends T> actualType) {
        Type genericReturnType = originalMethodDeclaration.getGenericReturnType();
        if (genericReturnType instanceof TypeVariable) {
            String variableName = ((TypeVariable)genericReturnType).getName();
            Class<?> baseClass = originalMethodDeclaration.getDeclaringClass();
            TypeVariable<Class<?>>[] typeVariables = baseClass.getTypeParameters();
            List variableNames = Stream.of(typeVariables).map(TypeVariable::getName).collect(Collectors.toList());
            int variableIndex = variableNames.indexOf(variableName);
            Class<? extends T> offspring = actualType;
            Type[] resolvedTypeArguments = GenericTypeResolver.resolveActualTypeArgs(offspring, baseClass, new Type[0]);
            Type resolvedType = resolvedTypeArguments[variableIndex];
            if (resolvedType instanceof TypeVariable) {
                return originalMethodDeclaration.getReturnType();
            }
            return resolvedType;
        }
        return genericReturnType;
    }

    public static <T> Type[] resolveActualTypeArgs(Class<? extends T> offspring, Class<T> base, Type ... actualArgs) {
        assert (offspring != null);
        assert (base != null);
        assert (actualArgs.length == 0 || actualArgs.length == offspring.getTypeParameters().length);
        if (actualArgs.length == 0) {
            actualArgs = offspring.getTypeParameters();
        }
        HashMap<String, Type> typeVariables = new HashMap<String, Type>();
        for (int i = 0; i < actualArgs.length; ++i) {
            TypeVariable<Class<T>> typeVariable = offspring.getTypeParameters()[i];
            typeVariables.put(typeVariable.getName(), actualArgs[i]);
        }
        LinkedList<Type> ancestors = new LinkedList<Type>();
        if (offspring.getGenericSuperclass() != null) {
            ancestors.add(offspring.getGenericSuperclass());
        }
        for (Type t : offspring.getGenericInterfaces()) {
            ancestors.add(t);
        }
        for (Type type : ancestors) {
            Class rawTypeClass;
            ParameterizedType parameterizedType;
            Type rawType;
            Type[] result;
            Class ancestorClass;
            if (type instanceof Class && base.isAssignableFrom(ancestorClass = (Class)type) && (result = GenericTypeResolver.resolveActualTypeArgs(ancestorClass, base, new Type[0])) != null) {
                return result;
            }
            if (!(type instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class) || !base.isAssignableFrom(rawTypeClass = (Class)rawType)) continue;
            LinkedList<Type> resolvedTypes = new LinkedList<Type>();
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (t instanceof TypeVariable) {
                    Type resolvedType = (Type)typeVariables.get(((TypeVariable)t).getName());
                    resolvedTypes.add(resolvedType != null ? resolvedType : t);
                    continue;
                }
                resolvedTypes.add(t);
            }
            Type[] result2 = GenericTypeResolver.resolveActualTypeArgs(rawTypeClass, base, resolvedTypes.toArray(new Type[0]));
            if (result2 == null) continue;
            return result2;
        }
        return offspring.equals(base) ? actualArgs : null;
    }
}

