/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.internal.rcg.runtime;

import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cache<VALUE> {
    private Object owner;
    private int maximumCacheSize;
    private MethodHandle originalMethod;
    private Map<List<Object>, VALUE> cache = new HashMap<List<Object>, VALUE>();

    public static <VALUE> Cache<VALUE> create(int maximumCacheSize, MethodHandle originalMethod, Object owner) {
        return new Cache<VALUE>(maximumCacheSize, originalMethod, owner);
    }

    public Cache(int maximumCacheSize, MethodHandle originalMethod, Object owner) {
        this.owner = owner;
        this.originalMethod = originalMethod;
        this.maximumCacheSize = maximumCacheSize;
    }

    public VALUE get(Object[] arguments) throws Throwable {
        List<Object> key = Arrays.asList(arguments);
        if (this.cache.containsKey(key)) {
            VALUE hit = this.cache.get(key);
            return hit;
        }
        Object[] objectAndArguments = new Object[arguments.length + 1];
        System.arraycopy(arguments, 0, objectAndArguments, 1, arguments.length);
        objectAndArguments[0] = this.owner;
        Object value = this.originalMethod.invokeWithArguments(objectAndArguments);
        if (this.cache.size() < this.maximumCacheSize) {
            this.cache.put(key, value);
        }
        return (VALUE)value;
    }
}

