/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.internal.rcg.utilities;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import pro.projo.annotations.RawInterfaces;
import pro.projo.internal.rcg.utilities.RawGenericLoadedType;

public class GenericVisitor
implements TypeDescription.Generic.Visitor<TypeDescription.Generic> {
    private final TypeDescription.Generic.Visitor<TypeDescription.Generic> delegate = TypeDescription.Generic.Visitor.Reifying.INITIATING;

    public static boolean isNecessaryFor(Stream<String> annotationNames) {
        return annotationNames.anyMatch(RawInterfaces.class.getName()::equals);
    }

    public TypeDescription.Generic onGenericArray(TypeDescription.Generic genericArray) {
        return (TypeDescription.Generic)this.delegate.onGenericArray(genericArray);
    }

    public TypeDescription.Generic onWildcard(TypeDescription.Generic wildcard) {
        return (TypeDescription.Generic)this.delegate.onWildcard(wildcard);
    }

    public TypeDescription.Generic onParameterizedType(TypeDescription.Generic parameterizedType) {
        return (TypeDescription.Generic)this.delegate.onParameterizedType(parameterizedType);
    }

    public TypeDescription.Generic onTypeVariable(TypeDescription.Generic typeVariable) {
        return (TypeDescription.Generic)this.delegate.onTypeVariable(typeVariable);
    }

    public TypeDescription.Generic onNonGenericType(TypeDescription.Generic typeDescription) {
        AnnotationList annotations = typeDescription.getDeclaredAnnotations();
        if (typeDescription instanceof RawGenericLoadedType && GenericVisitor.isNecessaryFor(annotations.asTypeNames().stream())) {
            final Class<?> type = ((RawGenericLoadedType)typeDescription).getType();
            return new TypeDescription.Generic.OfNonGenericType.ForLoadedType(type){

                public TypeList.Generic getInterfaces() {
                    Stream<Class<?>> interfaces = Stream.of(type.getInterfaces());
                    Stream<TypeDescription.ForLoadedType> rawInterfaces = interfaces.map(it -> new TypeDescription.ForLoadedType((Class)it){
                        private static final long serialVersionUID = 1L;

                        public TypeList.Generic getTypeVariables() {
                            return new TypeList.Generic.Empty();
                        }

                        public boolean isGenerified() {
                            return false;
                        }
                    });
                    return new TypeList.Generic.Explicit(rawInterfaces.collect(Collectors.toList()));
                }
            };
        }
        return (TypeDescription.Generic)this.delegate.onNonGenericType(typeDescription);
    }
}

