/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.template.configuration;

import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import pro.projo.template.annotation.Configuration;
import pro.projo.template.configuration.ProjoBaseTemplateConfiguration;

public class ProjoIntermediateTemplateConfiguration
extends ArrayList<Configuration>
implements ProjoBaseTemplateConfiguration {
    private static final long serialVersionUID = -9198129168518550932L;

    public ProjoIntermediateTemplateConfiguration() {
        int index = 0;
        while (index < NAMES.length) {
            final int number = index++;
            ProjoBaseTemplateConfiguration.BaseConfiguration configuration = new ProjoBaseTemplateConfiguration.BaseConfiguration(){

                public String fullyQualifiedClassName() {
                    return "pro.projo." + ProjoBaseTemplateConfiguration.NAMES[number] + ".Intermediate";
                }

                @Override
                public Format typeParameterDocumentationFormat() {
                    return new MessageFormat("@param <{0}> the type of the {1} field");
                }

                @Override
                public Format methodParameterDocumentationFormat() {
                    return new MessageFormat("@param {0} the {1} parameter");
                }

                public Map<String, Object> parameters() {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("template", ProjoBaseTemplateConfiguration.NAMES[number]);
                    parameters.put("n", String.valueOf(number + 1));
                    parameters.put("s", number > 0 ? "s" : "");
                    parameters.put("members", this.format(0, number, Function.identity(), ", "));
                    parameters.put("arguments", this.arguments(number));
                    parameters.put("First", "Function<_Artifact_, _First_> first");
                    parameters.put("AdditionalTypeParameters", this.format(0, number, this::typeParameterName, ", "));
                    parameters.put("additionalTypeParameterDocumentation", this.format(0, number, this::typeParameterDocumentation, System.lineSeparator() + "    * "));
                    parameters.put("additionalMethodParameterDocumentation", this.format(0, number, this::methodParameterDocumentation, System.lineSeparator() + "    * "));
                    parameters.put("argumentAndAdditionalParameters", (number > 0 ? ", " : "") + this.format(1, number, this::functionParameter, ", "));
                    return parameters;
                }

                public String toString() {
                    return this.fullyQualifiedClassName() + ":" + this.parameters();
                }

                private String arguments(int count) {
                    IntFunction<String> toString = item -> "argument" + item;
                    return IntStream.range(1, count + 2).mapToObj(toString).collect(Collectors.joining(", "));
                }

                private String functionParameter(String regularName) {
                    return "Function<_Artifact_, " + this.typeParameterName(regularName) + "> " + regularName;
                }
            };
            this.add(configuration);
        }
    }
}

