/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.template.configuration;

import java.text.Format;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.projo.template.annotation.Configuration;

public interface ProjoBaseTemplateConfiguration {
    public static final String[] NAMES = new String[]{"singles", "doubles", "triples", "quadruples", "quintuples", "sextuples", "septuples", "octuples", "nonuples", "decuples", "undecuples", "duodecuples", "tredecuples", "quattuordecuples", "quindecuples", "sexdecuples", "septendecuples", "octodecuples", "novemdecuples", "vigintuples", "unvigintuples", "duovigintuples", "trevigintuples", "quattuorvigintuples", "quinvigintuples", "sexvigintuples", "septenvigintuples", "octovigintuples", "novemvigintuples", "trigintuples"};
    public static final String[] ORDINALS = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth", "twentieth", "twentyFirst", "twentySecond", "twentyThird", "twentyFourth", "twentyFifth", "twentySixth", "twentySeventh", "twentyEighth", "twentyNinth", "thirtieth"};

    public static interface BaseConfiguration
    extends Configuration {
        public Format typeParameterDocumentationFormat();

        public Format methodParameterDocumentationFormat();

        default public Stream<String> ordinals(int limit) {
            return Stream.of(ORDINALS).limit(limit + 1);
        }

        default public String format(int from, int to, Function<String, String> mapper, String delimiter) {
            return this.ordinals(to).skip(from).map(mapper).collect(Collectors.joining(delimiter));
        }

        default public String typeParameterName(String regularName) {
            return "_" + regularName.substring(0, 1).toUpperCase() + regularName.substring(1) + "_";
        }

        default public String typeAndParameterName(String regularName) {
            return this.typeParameterName(regularName) + " " + regularName;
        }

        default public String hyphenatedName(String regularName) {
            String TWENTY = "twenty";
            boolean twentySomething = regularName.startsWith("twenty");
            return (twentySomething ? "twenty-" + regularName.substring("twenty".length()) : regularName).toLowerCase();
        }

        default public String typeParameterDocumentation(String regularName) {
            Object[] arguments = new Object[]{this.typeParameterName(regularName), this.hyphenatedName(regularName)};
            return this.typeParameterDocumentationFormat().format(arguments);
        }

        default public String methodParameterDocumentation(String regularName) {
            Object[] arguments = new Object[]{regularName, this.hyphenatedName(regularName)};
            return this.methodParameterDocumentationFormat().format(arguments);
        }
    }
}

