/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.generation;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;

public class ProjoTemplateFactoryGenerator {
    public String generate(String templateName, Map<String, String> parameters) {
        StringWriter writer = new StringWriter();
        this.generate(templateName, parameters, (Writer)writer);
        return writer.toString();
    }

    public void generate(String templateName, Map<String, String> parameters, Writer writer) {
        VelocityEngine engine = new VelocityEngine();
        Template template = engine.getTemplate(templateName);
        this.generate(template, parameters, writer);
    }

    public void generate(Template template, Map<String, String> parameters, Writer writer) {
        VelocityContext context = new VelocityContext();
        parameters.forEach((arg_0, arg_1) -> ((VelocityContext)context).put(arg_0, arg_1));
        template.merge((Context)context, writer);
    }

    public void generate(Reader reader, String name, Map<String, String> parameters, Writer writer) {
        try {
            this.generate(this.getTemplate(reader, name), parameters, writer);
        }
        catch (ParseException parseException) {
            try (PrintWriter printWriter = new PrintWriter(writer, true);){
                parseException.printStackTrace(printWriter);
            }
        }
    }

    public Template getTemplate(Reader reader, String name) throws ParseException {
        Template template = new Template();
        template.setRuntimeServices(RuntimeSingleton.getRuntimeServices());
        template.setData((Object)RuntimeSingleton.getRuntimeServices().parse(reader, name));
        template.initDocument();
        return template;
    }
}

