/*
 * Decompiled with CFR 0.152.
 */
package pro.projo.generation;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import pro.projo.generation.ProjoTemplateFactoryGenerator;
import pro.projo.template.annotation.Configuration;
import pro.projo.template.annotation.Template;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"pro.projo.template.annotation.Template"})
public class ProjoTemplateFactoryProcessor
extends AbstractProcessor {
    private Filer filer;
    private Elements elements;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment environment) {
        super.init(environment);
        this.filer = environment.getFiler();
        this.elements = environment.getElementUtils();
        this.messager = environment.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        ProjoTemplateFactoryGenerator generator = new ProjoTemplateFactoryGenerator();
        for (Element element : round.getElementsAnnotatedWith(Template.class)) {
            Template template = element.getAnnotation(Template.class);
            this.messager.printMessage(Diagnostic.Kind.NOTE, "@Template annotation found in " + element);
            FileObject templateFile = this.getTemplateFile(element);
            Collection<? extends Configuration> configurations = this.getConfiguration(this.getInputType(template));
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Generating " + configurations.size() + " additional sources...");
            for (Configuration configuration : configurations) {
                String className = configuration.fullyQualifiedClassName();
                TypeElement typeElement = this.elements.getTypeElement(className);
                try {
                    JavaFileObject sourceFile = this.filer.createSourceFile(className, typeElement);
                    try (PrintWriter writer = new PrintWriter(sourceFile.openWriter(), true);
                         Reader reader = templateFile.openReader(true);){
                        generator.generate(reader, templateFile.getName(), configuration.parameters(), writer);
                    }
                    this.messager.printMessage(Diagnostic.Kind.NOTE, "Generated " + className);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        return true;
    }

    private FileObject getTemplateFile(Element element) {
        String simpleName = element.getSimpleName().toString();
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        String sourceName = packageName.replace('.', File.separatorChar) + File.separatorChar + simpleName + ".java";
        try {
            return this.filer.getResource(StandardLocation.SOURCE_PATH, "", sourceName);
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private Collection<? extends Configuration> getConfiguration(TypeMirror type) {
        try {
            Collection<? extends Configuration> configuration = this.getClass(type).newInstance();
            return configuration;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    private Class<? extends Collection<? extends Configuration>> getClass(TypeMirror type) {
        try {
            Class<?> configurationClass = Class.forName(type.toString());
            return configurationClass;
        }
        catch (ClassNotFoundException classNotFound) {
            return null;
        }
    }

    private TypeMirror getInputType(Template template) {
        try {
            template.input();
        }
        catch (MirroredTypeException mirroredTypeException) {
            return mirroredTypeException.getTypeMirror();
        }
        return null;
    }
}

