/*
 * Decompiled with CFR 0.152.
 */
package pro.redsoft.iframework.jaxbx;

import pro.redsoft.iframework.jaxbx.ErrorCodes;

public class DetailedJAXBException
extends RuntimeException {
    private static final long serialVersionUID = 3379423349112269775L;
    private ErrorCodes errorCode;
    private String detailedMessage = "";

    public DetailedJAXBException() {
        this.errorCode = ErrorCodes.UNKNOWN_ERROR;
        this.detailedMessage = this.errorCode.toString();
    }

    public DetailedJAXBException(Throwable e) {
        super(e);
        if (e instanceof DetailedJAXBException) {
            this.errorCode = ((DetailedJAXBException)e).getErrorCode();
            this.detailedMessage = ((DetailedJAXBException)e).getDetailedMessage();
        }
    }

    public DetailedJAXBException(ErrorCodes errorCode, String message) {
        super("\n" + errorCode.getDesc() + "\n" + message);
        this.errorCode = errorCode;
    }

    public DetailedJAXBException(String message) {
        super("\n" + message);
        if (null == this.errorCode) {
            this.errorCode = ErrorCodes.UNKNOWN_ERROR;
        }
    }

    public DetailedJAXBException(ErrorCodes errorCode, String ... info) {
        super("\n" + errorCode.getDesc() + "\n" + info[0]);
        if (info.length > 0) {
            for (int i = 1; i < info.length; ++i) {
                this.detailedMessage = this.detailedMessage + info[i] + "\n";
            }
        }
        this.errorCode = errorCode;
        this.detailedMessage = errorCode.getDesc();
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }
}

