/*
 * Decompiled with CFR 0.152.
 */
package pro.redsoft.iframework.jaxbx;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pro.redsoft.iframework.jaxbx.DetailedJAXBException;
import pro.redsoft.iframework.jaxbx.ErrorCodes;
import pro.redsoft.iframework.jaxbx.FileSystemUtils;
import pro.redsoft.iframework.jaxbx.MarshallerBuilder;

public abstract class AbstractJAXBParser<T> {
    private DocumentBuilder builder;
    protected final Class<T> classType;
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private final MarshallerBuilder marshallBuilder;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public AbstractJAXBParser(Class<T> classType) {
        this.classType = classType;
        this.marshallBuilder = new MarshallerBuilder();
    }

    public Document getDocument() throws ParserConfigurationException {
        if (this.builder == null) {
            this.builder = this.factory.newDocumentBuilder();
        }
        return this.builder.newDocument();
    }

    public MarshallerBuilder getMarshallBuilder() {
        return this.marshallBuilder;
    }

    public abstract String getNamespace();

    public abstract HashMap<String, String> getNamespacePrefixMap();

    public abstract String getRootTagName();

    public Schema getSchema(File file) throws SAXException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = sf.newSchema(file);
        return s;
    }

    public abstract String getSchemaInstancePrefix();

    public Document marshall(T targetObj) throws JAXBException, ParserConfigurationException {
        Marshaller m = this.marshallBuilder.createMarshaller(this.classType);
        Document doc = this.getDocument();
        JAXBElement<T> jbx = this.wrap(this.getRootTagName(), this.getSchemaInstancePrefix(), targetObj);
        m.marshal(jbx, (Node)doc);
        return doc;
    }

    public String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public T unmarshall(String srcXml, Schema srcXsd, boolean isSavingTempEnabled) throws DetailedJAXBException {
        block20: {
            JAXBContext jc = null;
            Unmarshaller unmarshaller = null;
            if (isSavingTempEnabled) {
                try {
                    FileSystemUtils.saveTempFile(srcXml, "temp");
                }
                catch (Throwable e1) {
                    throw new DetailedJAXBException(ErrorCodes.ERROR_SAVING_TEMP_FILE, e1.getMessage());
                }
            }
            try {
                jc = JAXBContext.newInstance((String)this.classType.getPackage().getName());
                unmarshaller = jc.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new DetailedJAXBException(ErrorCodes.INIT_UNMARSHALLER_ERROR, e.getMessage());
            }
            if (null == srcXsd) {
                throw new DetailedJAXBException(ErrorCodes.WRONG_SCHEMA_LOCATION, "");
            }
            ValidationEventCollector vec = null;
            if (srcXsd != null) {
                unmarshaller.setSchema(srcXsd);
                vec = new ValidationEventCollector();
                try {
                    unmarshaller.setEventHandler((ValidationEventHandler)vec);
                }
                catch (JAXBException e1) {
                    throw new DetailedJAXBException(ErrorCodes.VALIDATION_EVENT_COLLECTOR_ERR, e1.getMessage());
                }
            }
            Object source = null;
            boolean wasWrongXmlStructure = false;
            String wringXmlStructureMessage = "";
            try {
                if (unmarshaller != null) {
                    source = unmarshaller.unmarshal((Reader)new StringReader(srcXml));
                    Object object = source instanceof JAXBElement ? ((JAXBElement)source).getValue() : source;
                    return (T)object;
                }
            }
            catch (JAXBException e) {
                e.printStackTrace();
                if (e.getLinkedException() instanceof SAXParseException) {
                    wasWrongXmlStructure = true;
                    wringXmlStructureMessage = wringXmlStructureMessage + e.getLinkedException().getMessage() + "\n";
                }
                throw new DetailedJAXBException(ErrorCodes.UNMARSHALLER_FATAL_ERROR, e.getMessage());
            }
            catch (ClassCastException castExc) {
                throw new DetailedJAXBException(ErrorCodes.WRONG_RECIEVER_DESC, source.getClass().getName() + "\n" + castExc.getMessage());
            }
            finally {
                if (vec != null && vec.hasEvents()) {
                    for (ValidationEvent ve : vec.getEvents()) {
                        ValidationEventLocator vel = ve.getLocator();
                        int line = vel.getLineNumber();
                        int column = vel.getColumnNumber();
                        wringXmlStructureMessage = wringXmlStructureMessage + "\u041b\u043e\u043a\u0430\u0446\u0438\u044f \u043e\u0448\u0438\u0431\u043a\u0438:  \u0441\u0442\u0440\u043e\u043a\u0430 " + line + " \u0441\u0442\u043e\u043b\u0431\u0435\u0446 " + column;
                    }
                }
                if (!wasWrongXmlStructure) break block20;
                throw new DetailedJAXBException(ErrorCodes.WRONG_XML_STRUCTURE, "\n" + wringXmlStructureMessage + "\n");
            }
        }
        return null;
    }

    JAXBElement<T> wrap(String tagName, String prefix, T object) {
        QName qtag = new QName(this.getNamespace(), tagName, prefix);
        JAXBElement jbe = new JAXBElement(qtag, object.getClass(), object);
        return jbe;
    }
}

