/*
 * Decompiled with CFR 0.152.
 */
package pro.requena.ea.modeltransfer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.requena.ea.modeltransfer.exceptions.EAModelTransferException;

public class EADatabase {
    private static final String PREFIX_JDBC = "jdbc:";
    private static final int LIMIT_JDBC = 30;
    private static final Logger LOG = LogManager.getLogger();

    public static final Connection connect(String endpoint) throws EAModelTransferException {
        if (endpoint.toLowerCase().startsWith(PREFIX_JDBC)) {
            return EADatabase.connectDsn(endpoint);
        }
        return EADatabase.connectEap(endpoint);
    }

    private static final Connection connectEap(String eapFilePath) throws EAModelTransferException {
        try {
            LOG.info("Connecting to EAP file: {}", (Object)eapFilePath);
            return DriverManager.getConnection("jdbc:ucanaccess://" + eapFilePath + ";memory=false");
        }
        catch (Exception e) {
            LOG.error("Couldn't open the EAP file connection.");
            throw new EAModelTransferException(e);
        }
    }

    private static final Connection connectDsn(String dsn) throws EAModelTransferException {
        try {
            LOG.info("Connecting to DB using DSN: {}...", (Object)StringUtils.substring((String)dsn, (int)0, (int)30));
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            return DriverManager.getConnection(dsn);
        }
        catch (Exception e) {
            throw new EAModelTransferException(e);
        }
    }

    public static final void close(Connection connection) throws EAModelTransferException {
        try {
            LOG.info("Closing connection.");
            connection.close();
        }
        catch (Exception e) {
            throw new EAModelTransferException(e);
        }
    }
}

