/*
 * Decompiled with CFR 0.152.
 */
package pro.requena.ea.modeltransfer.database;

import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.requena.ea.modeltransfer.exceptions.EAModelTransferException;

public class TransferProcess {
    private static final String[] tableList = new String[]{"t_attributeconstraints", "t_attributetag", "t_connectorconstraint", "t_connectortag", "t_document", "t_files", "t_html", "t_image", "t_paletteitem", "t_phase", "t_operationtag", "t_rtf", "t_rules", "t_script", "t_secgrouppermission", "t_seclocks", "t_secusergroup", "t_secuserpermission", "t_snapshot", "t_taggedvalue", "t_tasks", "t_template", "t_testplans", "t_umlpattern", "t_version", "t_xref", "t_xrefsystem", "t_xrefuser", "usys_system", "t_operationparams", "t_operationposts", "t_operationpres", "t_issues", "t_attribute", "t_connector", "t_diagramlinks", "t_diagramobjects", "t_method", "t_diagram", "t_objectconstraint", "t_objecteffort", "t_objectfiles", "t_objectmetrics", "t_objectproblems", "t_objectproperties", "t_objectrequires", "t_objectresource", "t_objectrisks", "t_objectscenarios", "t_objecttests", "t_objecttrx", "t_operation", "t_palette", "t_secuser", "t_secpermission", "t_secgroup", "t_object", "t_glossary", "t_implement", "t_diagramtypes", "t_genopt", "t_ecf", "t_efforttypes", "t_connectortypes", "t_constants", "t_constrainttypes", "t_datatypes", "t_authors", "t_cardinality", "t_category", "t_clients", "t_complexitytypes", "t_metrictypes", "t_lists", "t_mainttypes", "t_objecttypes", "t_ocf", "t_rtfreport", "t_package", "t_problemtypes", "t_projectroles", "t_propertytypes", "t_requiretypes", "t_resources", "t_risktypes", "t_scenariotypes", "t_secpolicies", "t_tcf", "t_statustypes", "t_stereotypes", "t_testtypes", "t_trxtypes", "t_testclass", "t_roleconstraint", "usystables"};
    private static final String SETTING_ON = "ON";
    private static final String SETTING_OFF = "OFF";
    private static final Logger LOG = LoggerFactory.getLogger(TransferProcess.class);

    public static void modelTransfer(Connection sourceConnection, Connection targetConnection, boolean batchInsert) throws EAModelTransferException {
        LOG.info("Start: modelTransfer. BatchInsert: {}.", (Object)batchInsert);
        try {
            targetConnection.setAutoCommit(true);
            TransferProcess.deleteTables(targetConnection);
            for (String table : tableList) {
                LOG.info("Inserting rows to table: {}.", (Object)table);
                Statement statement = sourceConnection.createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT * FROM " + table);
                ResultSetMetaData metadata = resultSet.getMetaData();
                TransferProcess.changeIdentityInserts(targetConnection, table, true);
                PreparedStatement insertStatement = TransferProcess.prepareInsertStatement(targetConnection, table, metadata);
                while (resultSet.next()) {
                    for (int column = 1; column <= metadata.getColumnCount(); ++column) {
                        if (metadata.getColumnType(column) == 1 || metadata.getColumnType(column) == 12) {
                            insertStatement.setString(column, resultSet.getString(column));
                            continue;
                        }
                        if (metadata.getColumnType(column) == 2 || metadata.getColumnType(column) == 4 || metadata.getColumnType(column) == 5) {
                            insertStatement.setInt(column, resultSet.getInt(column));
                            continue;
                        }
                        if (metadata.getColumnType(column) == 91) {
                            insertStatement.setDate(column, resultSet.getDate(column));
                            continue;
                        }
                        if (metadata.getColumnType(column) == 93) {
                            insertStatement.setTimestamp(column, resultSet.getTimestamp(column));
                            continue;
                        }
                        if (metadata.getColumnType(column) == 16) {
                            insertStatement.setBoolean(column, resultSet.getBoolean(column));
                            continue;
                        }
                        if (metadata.getColumnType(column) == 8) {
                            insertStatement.setDouble(column, resultSet.getDouble(column));
                            continue;
                        }
                        if (metadata.getColumnType(column) == -3) {
                            if (resultSet.getBinaryStream(column) != null) {
                                insertStatement.setBinaryStream(column, resultSet.getBinaryStream(column));
                                continue;
                            }
                            insertStatement.setBinaryStream(column, new ByteArrayInputStream(new byte[0]));
                            continue;
                        }
                        String errorDescription = "Datatype not handled: " + metadata.getColumnType(column) + "(" + metadata.getColumnTypeName(column) + ") on table " + table + ", column " + metadata.getColumnName(column);
                        LOG.error(errorDescription);
                        throw new EAModelTransferException(errorDescription);
                    }
                    if (batchInsert) {
                        insertStatement.addBatch();
                        continue;
                    }
                    insertStatement.execute();
                }
                if (batchInsert) {
                    insertStatement.executeBatch();
                }
                TransferProcess.changeIdentityInserts(targetConnection, table, false);
            }
            LOG.info("Finished: modelTransfer.");
        }
        catch (SQLException exception) {
            throw new EAModelTransferException(exception);
        }
    }

    private static PreparedStatement prepareInsertStatement(Connection connection, String table, ResultSetMetaData metadata) throws SQLException {
        String colNames = "";
        String colParams = "";
        for (int col = 1; col <= metadata.getColumnCount(); ++col) {
            colNames = colNames + "[" + metadata.getColumnName(col) + "], ";
            colParams = colParams + "?, ";
        }
        colNames = colNames.substring(0, colNames.length() - 2);
        colParams = colParams.substring(0, colParams.length() - 2);
        String insertString = "INSERT INTO [" + table + "] ";
        insertString = !StringUtils.equals((CharSequence)connection.getMetaData().getDriverName(), (CharSequence)"H2 JDBC Driver") ? insertString + "(" + colNames + ") " : insertString.replace("[", "").replace("]", "");
        insertString = insertString + "VALUES (" + colParams + ");";
        PreparedStatement insertStatement = connection.prepareStatement(insertString);
        return insertStatement;
    }

    public static void deleteTables(Connection targetConnection) throws SQLException {
        for (String table : tableList) {
            LOG.info("Deleting rows from table: {}.", (Object)table);
            Statement statement = targetConnection.createStatement();
            statement.execute("DELETE FROM " + table);
        }
        targetConnection.commit();
    }

    private static void changeIdentityInserts(Connection destinationConnection, String tableName, boolean value) {
        try {
            Statement identityStmt = destinationConnection.createStatement();
            identityStmt.execute("SET IDENTITY_INSERT " + tableName + " " + (value ? SETTING_ON : SETTING_OFF));
            identityStmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

