/*
 * Decompiled with CFR 0.152.
 */
package pro.requena.ea.modeltransfer.database;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.requena.ea.modeltransfer.exceptions.EAModelTransferException;

public class EADatabase {
    private static final String PREFIX_JDBC = "jdbc:";
    private static final int LIMIT_JDBC = 30;
    private static final String DEFAULT_EAPX_PATH = "EABase_JET4.eapx";
    private static final Logger LOG = LoggerFactory.getLogger(EADatabase.class);

    public static final Connection connect(String endpoint, boolean isTarget) throws EAModelTransferException {
        if (endpoint.toLowerCase().startsWith(PREFIX_JDBC)) {
            return EADatabase.connectDsn(endpoint);
        }
        return EADatabase.connectEap(endpoint, isTarget);
    }

    private static final Connection connectEap(String eapFilePath, boolean isTarget) throws EAModelTransferException {
        try {
            LOG.info("Connecting to EAP file: {}", (Object)eapFilePath);
            if (isTarget && !Files.exists(Paths.get(eapFilePath, new String[0]), new LinkOption[0])) {
                LOG.info("File {} doesn't exist. Copying the Sparx's EAPX template.", (Object)eapFilePath);
                Files.copy(Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_EAPX_PATH), Paths.get(eapFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            return DriverManager.getConnection("jdbc:ucanaccess://" + eapFilePath + ";memory=false;immediatelyReleaseResources=true");
        }
        catch (Exception e) {
            LOG.error("Couldn't open the EAP file connection.");
            throw new EAModelTransferException(e);
        }
    }

    private static final Connection connectDsn(String dsn) throws EAModelTransferException {
        try {
            LOG.info("Connecting to DB using DSN: {}...", (Object)StringUtils.substring((String)dsn, (int)0, (int)30));
            return DriverManager.getConnection(dsn);
        }
        catch (Exception e) {
            throw new EAModelTransferException(e);
        }
    }

    public static final void close(Connection connection) throws EAModelTransferException {
        try {
            LOG.info("Closing connection.");
            connection.close();
        }
        catch (Exception e) {
            throw new EAModelTransferException(e);
        }
    }
}

