/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.flowmvi.metrics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0013\u0012\n\u0010\u0003\u001a\u00020\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0006\u0010\u001e\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lpro/respawn/flowmvi/metrics/P2QuantileEstimator;", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "probabilities", "", "", "<init>", "([D)V", "m", "", "markerCount", "n", "", "ns", "q", "value", "count", "getCount", "()I", "add", "", "updateNs", "maxIndex", "adjust", "i", "parabolic", "d", "linear", "getQuantile", "p", "clear", "metrics"})
public final class P2QuantileEstimator {
    @NotNull
    private final double[] probabilities;
    private final int m;
    private final int markerCount;
    @NotNull
    private final int[] n;
    @NotNull
    private final double[] ns;
    @NotNull
    private final double[] q;
    private int count;

    public P2QuantileEstimator(double ... probabilities) {
        Intrinsics.checkNotNullParameter((Object)probabilities, (String)"probabilities");
        this.probabilities = probabilities;
        this.m = this.probabilities.length;
        this.markerCount = 2 * this.m + 3;
        this.n = new int[this.markerCount];
        this.ns = new double[this.markerCount];
        this.q = new double[this.markerCount];
    }

    public final int getCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(double value) {
        P2QuantileEstimator p2QuantileEstimator = this;
        synchronized (p2QuantileEstimator) {
            boolean bl = false;
            if (this.count < this.markerCount) {
                int n = this.count;
                this.count = n + 1;
                this.q[n] = value;
                if (this.count == this.markerCount) {
                    int i;
                    ArraysKt.sort((double[])this.q);
                    this.updateNs(this.markerCount - 1);
                    int n2 = this.markerCount;
                    for (i = 0; i < n2; ++i) {
                        this.n[i] = (int)Math.rint(this.ns[i]);
                    }
                    ArraysKt.copyInto$default((double[])this.q, (double[])this.ns, (int)0, (int)0, (int)0, (int)14, null);
                    n2 = this.markerCount;
                    for (i = 0; i < n2; ++i) {
                        this.q[i] = this.ns[this.n[i]];
                    }
                    this.updateNs(this.markerCount - 1);
                }
            } else {
                int i;
                int n;
                int k = -1;
                if (value < this.q[0]) {
                    this.q[0] = value;
                    k = 0;
                } else {
                    n = this.markerCount;
                    for (i = 1; i < n; ++i) {
                        if (!(value < this.q[i])) continue;
                        k = i - 1;
                        break;
                    }
                    if (k == -1) {
                        this.q[this.markerCount - 1] = value;
                        k = this.markerCount - 2;
                    }
                }
                i = k + 1;
                n = this.markerCount;
                while (i < n) {
                    int[] nArray = this.n;
                    int n3 = i++;
                    int n4 = nArray[n3];
                    nArray[n3] = n4 + 1;
                }
                this.updateNs(this.count);
                int leftI = 1;
                int rightI = this.markerCount - 2;
                while (leftI <= rightI) {
                    int i2 = 0;
                    i2 = Math.abs(this.ns[leftI] / (double)this.count - 0.5) <= Math.abs(this.ns[rightI] / (double)this.count - 0.5) ? leftI++ : rightI--;
                    this.adjust(i2);
                }
                int n5 = this.count;
                this.count = n5 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void updateNs(int maxIndex) {
        int i;
        this.ns[0] = 0.0;
        int n = this.m;
        for (i = 0; i < n; ++i) {
            this.ns[i * 2 + 2] = (double)maxIndex * this.probabilities[i];
        }
        this.ns[this.markerCount - 1] = maxIndex;
        this.ns[1] = (double)maxIndex * this.probabilities[0] / 2.0;
        n = this.m;
        for (i = 1; i < n; ++i) {
            this.ns[2 * i + 1] = (double)maxIndex * (this.probabilities[i - 1] + this.probabilities[i]) / 2.0;
        }
        this.ns[this.markerCount - 2] = (double)maxIndex * (1.0 + this.probabilities[this.m - 1]) / 2.0;
    }

    private final void adjust(int i) {
        double d = this.ns[i] - (double)this.n[i];
        if (d >= 1.0 && this.n[i + 1] - this.n[i] > 1 || d <= -1.0 && this.n[i - 1] - this.n[i] < -1) {
            int dInt = (int)Math.signum(d);
            double qs = this.parabolic(i, dInt);
            this.q[i] = this.q[i - 1] < qs && qs < this.q[i + 1] ? qs : this.linear(i, dInt);
            int[] nArray = this.n;
            nArray[i] = nArray[i] + dInt;
        }
    }

    private final double parabolic(int i, double d) {
        double nPlus1 = this.n[i + 1];
        double nMinus1 = this.n[i - 1];
        double nI = this.n[i];
        double qPlus1 = this.q[i + 1];
        double qMinus1 = this.q[i - 1];
        double qI = this.q[i];
        double numerator = (nI - nMinus1 + d) * (qPlus1 - qI) / (nPlus1 - nI) + (nPlus1 - nI - d) * (qI - qMinus1) / (nI - nMinus1);
        return qI + d / (nPlus1 - nMinus1) * numerator;
    }

    private final double linear(int i, int d) {
        return this.q[i] + (double)d * (this.q[i + d] - this.q[i]) / (double)(this.n[i + d] - this.n[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final double getQuantile(double p) {
        P2QuantileEstimator p2QuantileEstimator = this;
        synchronized (p2QuantileEstimator) {
            boolean bl = false;
            if (this.count == 0) {
                return Double.NaN;
            }
            if (this.count <= this.markerCount) {
                ArraysKt.sort((double[])this.q, (int)0, (int)this.count);
                int index = (int)Math.rint((double)(this.count - 1) * p);
                return this.q[index];
            }
            int i = 0;
            int n = this.probabilities.length;
            while (true) {
                if (i >= n) {
                    throw new IllegalStateException("Target quantile (" + p + ") wasn't requested in the constructor");
                }
                if (this.probabilities[i] == p) {
                    return this.q[2 * i + 2];
                }
                ++i;
            }
        }
    }

    public final void clear() {
        this.count = 0;
    }
}

