/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.flowmvi.metrics;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import pro.respawn.flowmvi.metrics.P2QuantileEstimator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000bJ\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u0006\u0010 \u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lpro/respawn/flowmvi/metrics/PerformanceMetrics;", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "<init>", "()V", "ema", "", "alpha", "p2", "Lpro/respawn/flowmvi/metrics/P2QuantileEstimator;", "value", "", "totalOperations", "getTotalOperations", "()J", "numberOfBuckets", "", "frequencyBuckets", "", "bucketDurationMillis", "Lkotlin/time/Duration;", "J", "lastBucketTime", "Lkotlinx/datetime/Instant;", "recordOperation", "durationMillis", "updateFrequencyCounter", "averageTime", "getAverageTime", "()D", "medianTime", "q", "opsPerSecond", "metrics"})
public final class PerformanceMetrics {
    private double ema;
    private final double alpha;
    @NotNull
    private P2QuantileEstimator p2;
    private long totalOperations;
    private final int numberOfBuckets;
    @NotNull
    private final int[] frequencyBuckets;
    private final long bucketDurationMillis;
    @NotNull
    private Instant lastBucketTime;

    public PerformanceMetrics() {
        this.alpha = 0.1;
        double[] dArray = new double[]{0.5};
        this.p2 = new P2QuantileEstimator(dArray);
        this.numberOfBuckets = 60;
        this.frequencyBuckets = new int[this.numberOfBuckets];
        this.bucketDurationMillis = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        this.lastBucketTime = Clock.System.INSTANCE.now();
    }

    public final long getTotalOperations() {
        return this.totalOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int recordOperation(long durationMillis) {
        int n;
        PerformanceMetrics performanceMetrics = this;
        synchronized (performanceMetrics) {
            boolean bl = false;
            long l = this.totalOperations;
            this.totalOperations = l + 1L;
            this.ema = this.ema == 0.0 ? (double)durationMillis : this.alpha * (double)durationMillis + (1.0 - this.alpha) * this.ema;
            this.p2.add(durationMillis);
            n = this.updateFrequencyCounter();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int updateFrequencyCounter() {
        int n;
        PerformanceMetrics performanceMetrics = this;
        synchronized (performanceMetrics) {
            int n2;
            boolean bl = false;
            Instant currentTime = Clock.System.INSTANCE.now();
            int elapsedBuckets = (int)Duration.div-LRDsOJo((long)currentTime.minus-5sfh64U(this.lastBucketTime), (long)this.bucketDurationMillis);
            if (elapsedBuckets > 0) {
                int shift = Math.min(elapsedBuckets, this.numberOfBuckets);
                ArraysKt.copyInto((int[])this.frequencyBuckets, (int[])this.frequencyBuckets, (int)shift, (int)0, (int)(this.numberOfBuckets - shift));
                n2 = this.numberOfBuckets;
                for (int i = this.numberOfBuckets - shift; i < n2; ++i) {
                    this.frequencyBuckets[i] = 0;
                }
                this.lastBucketTime = this.lastBucketTime.plus-LRDsOJo(Duration.times-UwyO8pc((long)this.bucketDurationMillis, (int)elapsedBuckets));
            }
            int[] nArray = this.frequencyBuckets;
            int n3 = this.numberOfBuckets - 1;
            n2 = nArray[n3];
            nArray[n3] = n2 + 1;
            n = n2;
        }
        return n;
    }

    public final double getAverageTime() {
        return this.ema;
    }

    public final double medianTime(double q) {
        return this.p2.getQuantile(q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double opsPerSecond() {
        PerformanceMetrics performanceMetrics = this;
        synchronized (performanceMetrics) {
            boolean bl = false;
            double d = (double)ArraysKt.sum((int[])this.frequencyBuckets) / (double)this.numberOfBuckets;
            return d;
        }
    }
}

