/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.kmmutils.datetime;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.respawn.kmmutils.datetime.DateTimeExtKt;
import pro.respawn.kmmutils.datetime.Time;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a(\u0010\u0018\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a\u0012\u0010\u001c\u001a\u00020\u0010*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t\u001a\u0012\u0010\u001f\u001a\u00020 *\u00020\u00022\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010#\u001a\u00020 *\u00020\"2\u0006\u0010$\u001a\u00020\u0002\u001a\u0015\u0010%\u001a\u00020\t*\u00020\u00022\u0006\u0010&\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010'\u001a\u00020\u0002*\u00020\u00022\u0006\u0010(\u001a\u00020\u0002H\u0086\u0004\u001a\"\u0010)\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010*\u001a\u00020\u0001H\u0086\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b+\u0010,\u001a\u0015\u0010)\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0086\u0002\u001a\u0012\u0010/\u001a\u00020\r*\u00020\u001d2\u0006\u0010$\u001a\u00020\u0010\u001a\u0012\u00100\u001a\u00020\u0002*\u00020\u001d2\u0006\u00101\u001a\u000202\u001a\u0012\u00103\u001a\u00020\u0002*\u00020\u001d2\u0006\u00104\u001a\u00020\t\u001a\u0012\u00105\u001a\u00020\u0002*\u00020\u001d2\u0006\u00106\u001a\u000207\u001a\u0012\u00108\u001a\u00020\u0002*\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\t\u001a\u0014\u00109\u001a\u0004\u0018\u00010\u0002*\u00020\u001d2\u0006\u0010:\u001a\u00020\u0010\u001a\n\u0010;\u001a\u00020\t*\u00020\u0002\u001a\n\u0010<\u001a\u00020.*\u00020\u0002\u001a\n\u0010=\u001a\u00020\u0002*\u00020.\u001a\u000e\u0010>\u001a\u0004\u0018\u00010\u0002*\u0004\u0018\u00010\u0010\u001a\u0012\u0010?\u001a\u00020\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020@\u001a\u0019\u0010?\u001a\u00020\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020AH\u0007\u00a2\u0006\u0002\bB\u001a(\u0010C\u001a\u00020\u0002*\u00020\u001d2\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a\u001c\u0010D\u001a\u00020 *\u00020 2\u0006\u0010$\u001a\u00020\u00022\b\b\u0002\u0010E\u001a\u00020\t\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0002*\u00020\u00018F\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0017\u0010\u000f\u001a\u00020\r*\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006F"}, d2={"asDuration", "Lkotlin/time/Duration;", "Lpro/respawn/kmmutils/datetime/Time;", "getAsDuration", "(Lpro/respawn/kmmutils/datetime/Time;)J", "asTime", "getAsTime-LRDsOJo", "(J)Lpro/respawn/kmmutils/datetime/Time;", "hourAs12H", "", "getHourAs12H", "(Lpro/respawn/kmmutils/datetime/Time;)I", "isPM", "", "(Lpro/respawn/kmmutils/datetime/Time;)Z", "isValidTime", "", "(Ljava/lang/String;)Z", "totalMinutes", "", "getTotalMinutes", "(Lpro/respawn/kmmutils/datetime/Time;)D", "totalSeconds", "getTotalSeconds", "add", "hours", "minutes", "seconds", "asTimeNumber", "Lpro/respawn/kmmutils/datetime/Time$Companion;", "value", "atDate", "Lkotlinx/datetime/LocalDateTime;", "date", "Lkotlinx/datetime/LocalDate;", "atTime", "time", "distanceInSeconds", "to", "distanceTo", "other", "invoke", "duration", "invoke-HG0u8IE", "(Lpro/respawn/kmmutils/datetime/Time$Companion;J)Lpro/respawn/kmmutils/datetime/Time;", "localTime", "Lkotlinx/datetime/LocalTime;", "isValid", "now", "zone", "Lkotlinx/datetime/TimeZone;", "ofInt", "hms", "ofMillis", "millis", "", "ofSeconds", "parseOrNull", "s", "toInt", "toLocalTime", "toTime", "toTimeOrNull", "totalDuration", "", "Lkotlin/sequences/Sequence;", "totalDurationSequence", "with", "withTime", "nanos", "datetime"})
@SourceDebugExtension(value={"SMAP\nTimeExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeExt.kt\npro/respawn/kmmutils/datetime/TimeExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class TimeExtKt {
    @NotNull
    public static final Time toTime(@NotNull LocalTime $this$toTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toTime, (String)"<this>");
        return new Time($this$toTime.getHour(), $this$toTime.getMinute(), $this$toTime.getSecond());
    }

    @NotNull
    public static final LocalTime toLocalTime(@NotNull Time $this$toLocalTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalTime, (String)"<this>");
        return new LocalTime($this$toLocalTime.getHour(), $this$toLocalTime.getMinute(), $this$toLocalTime.getSecond(), 0);
    }

    @NotNull
    public static final LocalDateTime atTime(@NotNull LocalDate $this$atTime, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)$this$atTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return LocalDateKt.atTime$default((LocalDate)$this$atTime, (int)time.getHour(), (int)time.getMinute(), (int)time.getSecond(), (int)0, (int)8, null);
    }

    @NotNull
    public static final LocalDateTime atDate(@NotNull Time $this$atDate, @NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)$this$atDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new LocalDateTime(date, TimeExtKt.toLocalTime($this$atDate));
    }

    public static final int toInt(@NotNull Time $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return $this$toInt.getHour() * 10000 + $this$toInt.getMinute() * 100 + $this$toInt.getSecond();
    }

    @NotNull
    public static final Time distanceTo(@NotNull Time $this$distanceTo, @NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return TimeExtKt.ofSeconds(Time.Companion, Math.abs(TimeExtKt.getTotalSeconds(other) - TimeExtKt.getTotalSeconds($this$distanceTo)));
    }

    @NotNull
    public static final LocalDateTime withTime(@NotNull LocalDateTime $this$withTime, @NotNull Time time, int nanos) {
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new LocalDateTime($this$withTime.getYear(), $this$withTime.getMonth(), $this$withTime.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond(), nanos);
    }

    public static /* synthetic */ LocalDateTime withTime$default(LocalDateTime localDateTime, Time time, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = localDateTime.getNanosecond();
        }
        return TimeExtKt.withTime(localDateTime, time, n);
    }

    public static final long getAsDuration(@NotNull Time $this$asDuration) {
        Intrinsics.checkNotNullParameter((Object)$this$asDuration, (String)"<this>");
        return DurationKt.toDuration((int)TimeExtKt.getTotalSeconds($this$asDuration), (DurationUnit)DurationUnit.SECONDS);
    }

    public static final int distanceInSeconds(@NotNull Time $this$distanceInSeconds, @NotNull Time to) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceInSeconds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return Math.abs(to.getHour() - $this$distanceInSeconds.getHour()) * 60 * 60 + Math.abs(to.getMinute() - $this$distanceInSeconds.getMinute()) * 60 + Math.abs(to.getSecond() - $this$distanceInSeconds.getSecond());
    }

    public static final boolean isPM(@NotNull Time $this$isPM) {
        Intrinsics.checkNotNullParameter((Object)$this$isPM, (String)"<this>");
        return $this$isPM.getHour() >= 12;
    }

    public static final double getTotalMinutes(@NotNull Time $this$totalMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$totalMinutes, (String)"<this>");
        return (double)($this$totalMinutes.getHour() * 60 + $this$totalMinutes.getMinute()) + (double)$this$totalMinutes.getSecond() / (double)60;
    }

    public static final int getTotalSeconds(@NotNull Time $this$totalSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$totalSeconds, (String)"<this>");
        return $this$totalSeconds.getHour() * 3600 + $this$totalSeconds.getMinute() * 60 + $this$totalSeconds.getSecond();
    }

    public static final int getHourAs12H(@NotNull Time $this$hourAs12H) {
        Intrinsics.checkNotNullParameter((Object)$this$hourAs12H, (String)"<this>");
        return $this$hourAs12H.getHour() % 12 == 0 ? $this$hourAs12H.getHour() : $this$hourAs12H.getHour() % 12;
    }

    @NotNull
    public static final Time add(@NotNull Time $this$add, int hours, int minutes, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Triple<Integer, Integer, Integer> triple = Time.Companion.normalize$datetime(hours, minutes, seconds);
        int normalizedHours = ((Number)triple.component1()).intValue();
        int normalizedMinutes = ((Number)triple.component2()).intValue();
        int normalizedSeconds = ((Number)triple.component3()).intValue();
        int hDelta = (normalizedHours + $this$add.getHour() + ($this$add.getMinute() + normalizedMinutes) / 60 + ($this$add.getSecond() + normalizedSeconds) / 3600) % 24;
        int mDelta = ($this$add.getMinute() + normalizedMinutes + ($this$add.getSecond() + normalizedSeconds) / 60) % 60;
        int sDelta = ($this$add.getSecond() + normalizedSeconds) % 60;
        int h = (hDelta >= 0 ? hDelta : hDelta + 24) % 24;
        int m = mDelta >= 0 ? mDelta : mDelta + 60;
        int s = sDelta >= 0 ? sDelta : sDelta + 60;
        return new Time(h, m, s);
    }

    public static /* synthetic */ Time add$default(Time time, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return TimeExtKt.add(time, n, n2, n3);
    }

    @NotNull
    public static final String asTimeNumber(@NotNull Time.Companion $this$asTimeNumber, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$asTimeNumber, (String)"<this>");
        return value < 10 ? "0" + value : String.valueOf(value);
    }

    @NotNull
    public static final Time invoke(@NotNull Time.Companion $this$invoke, @NotNull LocalTime localTime) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        return TimeExtKt.toTime(localTime);
    }

    @NotNull
    public static final Time invoke-HG0u8IE(@NotNull Time.Companion $this$invoke_u2dHG0u8IE, long duration) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke_u2dHG0u8IE, (String)"$this$invoke");
        return TimeExtKt.ofSeconds($this$invoke_u2dHG0u8IE, (int)Duration.getInWholeSeconds-impl((long)duration));
    }

    @NotNull
    public static final Time ofInt(@NotNull Time.Companion $this$ofInt, int hms) {
        Intrinsics.checkNotNullParameter((Object)$this$ofInt, (String)"<this>");
        return new Time(hms / 10000, hms / 100 % 100, hms % 100);
    }

    @NotNull
    public static final Time ofMillis(@NotNull Time.Companion $this$ofMillis, long millis) {
        Intrinsics.checkNotNullParameter((Object)$this$ofMillis, (String)"<this>");
        long totalSeconds = millis / (long)1000;
        long totalMinutes = totalSeconds / (long)60;
        long totalHours = totalMinutes / (long)60;
        return new Time((int)totalHours % 24, (int)(totalMinutes % (long)60), (int)(totalSeconds % (long)60));
    }

    @NotNull
    public static final Time ofSeconds(@NotNull Time.Companion $this$ofSeconds, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$ofSeconds, (String)"<this>");
        return TimeExtKt.ofMillis($this$ofSeconds, (long)seconds * 1000L);
    }

    @NotNull
    public static final Time with(@NotNull Time.Companion $this$with, int hours, int minutes, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        return TimeExtKt.add($this$with.getMIN(), hours, minutes, seconds);
    }

    public static /* synthetic */ Time with$default(Time.Companion companion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return TimeExtKt.with(companion, n, n2, n3);
    }

    @NotNull
    public static final Time now(@NotNull Time.Companion $this$now, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return TimeExtKt.toTime(DateTimeExtKt.now(LocalTime.Companion, zone));
    }

    @Nullable
    public static final Time parseOrNull(@NotNull Time.Companion $this$parseOrNull, @NotNull String s) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parseOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object object2 = s;
        try {
            String $this$parseOrNull_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$parseOrNull.parse($this$parseOrNull_u24lambda_u240));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Time)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    public static final boolean isValid(@NotNull Time.Companion $this$isValid, @NotNull String time) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return TimeExtKt.parseOrNull($this$isValid, time) != null;
    }

    public static final boolean isValidTime(@Nullable String $this$isValidTime) {
        boolean bl;
        String string = $this$isValidTime;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = TimeExtKt.isValid(Time.Companion, it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final Time toTimeOrNull(@Nullable String $this$toTimeOrNull) {
        Time time;
        String string = $this$toTimeOrNull;
        if (string != null) {
            String it = string;
            boolean bl = false;
            time = TimeExtKt.parseOrNull(Time.Companion, $this$toTimeOrNull);
        } else {
            time = null;
        }
        return time;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Time totalDuration(@NotNull Iterable<Time> $this$totalDuration) {
        int n;
        Intrinsics.checkNotNullParameter($this$totalDuration, (String)"<this>");
        Iterable<Time> iterable = $this$totalDuration;
        Time.Companion companion = Time.Companion;
        int n2 = 0;
        Iterator<Time> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            Time time;
            Time time2 = time = iterator.next();
            n = n2;
            boolean bl = false;
            void v0 = it;
            int n3 = v0 != null ? TimeExtKt.getTotalSeconds((Time)v0) : 0;
            n2 = n + n3;
        }
        n = n2;
        return TimeExtKt.ofSeconds(companion, n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="totalDurationSequence")
    @NotNull
    public static final Time totalDurationSequence(@NotNull Sequence<Time> $this$totalDuration) {
        int n;
        Intrinsics.checkNotNullParameter($this$totalDuration, (String)"<this>");
        Sequence<Time> sequence = $this$totalDuration;
        Time.Companion companion = Time.Companion;
        int n2 = 0;
        for (Object e : sequence) {
            void it;
            Time time = (Time)e;
            n = n2;
            boolean bl = false;
            void v0 = it;
            int n3 = v0 != null ? TimeExtKt.getTotalSeconds((Time)v0) : 0;
            n2 = n + n3;
        }
        n = n2;
        return TimeExtKt.ofSeconds(companion, n);
    }

    @NotNull
    public static final Time getAsTime-LRDsOJo(long $this$asTime) {
        return TimeExtKt.ofSeconds(Time.Companion, (int)Duration.getInWholeSeconds-impl((long)$this$asTime));
    }
}

