/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.kmmutils.datetime;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.respawn.kmmutils.datetime.TimeExtKt;

@Deprecated(message="\nAll functionality of the Time class was ported to kotlinx.datetime.LocalTime as extension functions and properties.\nYou can simply replace this with LocalTime and expect similar functionality to be present.\n", replaceWith=@ReplaceWith(expression="LocalTime", imports={"kotlinx.datetime.LocalTime"}))
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\b\b\u0087\b\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ\u0011\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\b\u0010\u001d\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001f"}, d2={"Lpro/respawn/kmmutils/datetime/Time;", "", "hour", "", "minute", "second", "(III)V", "getHour", "()I", "getMinute", "getSecond", "asString", "", "use12h", "", "addSecondsIfZero", "compareTo", "other", "component1", "component2", "component3", "copy", "equals", "", "get", "index", "hashCode", "minus", "plus", "toString", "Companion", "datetime"})
public final class Time
implements Comparable<Time> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int hour;
    private final int minute;
    private final int second;
    @NotNull
    private static final Time MAX = new Time(23, 59, 59);
    @NotNull
    private static final Time MIN = new Time(0, 0, 0, 4, null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Time(int hour, int minute, int second) throws IllegalArgumentException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        int n = this.hour;
        if (0 <= n) {
            if (n < 24) {
                return;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return;
        n = this.minute;
        if (0 <= n) {
            if (n < 60) {
                return;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return;
        n = this.second;
        if (0 <= n) {
            if (n < 60) {
                return;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        boolean bl4 = false;
        if (bl4) return;
        boolean bl5 = false;
        String string = "Invalid time value: " + this.hour + ':' + this.minute + ':' + this.second;
        throw new IllegalArgumentException(string.toString());
    }

    public /* synthetic */ Time(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) throws IllegalArgumentException {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        this(n, n2, n3);
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinute() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second;
    }

    @NotNull
    public String toString() {
        return Time.asString$default(this, false, false, 3, null);
    }

    @NotNull
    public final String asString(boolean use12h, boolean addSecondsIfZero) {
        StringBuilder stringBuilder;
        StringBuilder $this$asString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u241.append(TimeExtKt.asTimeNumber(Companion, use12h ? TimeExtKt.getHourAs12H(this) : this.hour) + ':' + TimeExtKt.asTimeNumber(Companion, this.minute));
        if (addSecondsIfZero || this.second != 0) {
            $this$asString_u24lambda_u241.append(':' + TimeExtKt.asTimeNumber(Companion, this.second));
        }
        if (use12h) {
            $this$asString_u24lambda_u241.append(' ' + (TimeExtKt.isPM(this) ? "PM" : "AM"));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String asString$default(Time time, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return time.asString(bl, bl2);
    }

    @NotNull
    public final Time plus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return TimeExtKt.add(this, other.hour, other.minute, other.second);
    }

    @NotNull
    public final Time minus(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return TimeExtKt.add(this, -other.hour, -other.minute, -other.second);
    }

    @Override
    public int compareTo(@NotNull Time other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)TimeExtKt.getTotalSeconds(this), (int)TimeExtKt.getTotalSeconds(other));
    }

    public final int get(int index) {
        int n;
        switch (index) {
            case 0: {
                n = this.hour;
                break;
            }
            case 1: {
                n = this.minute;
                break;
            }
            case 2: {
                n = this.second;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Only 0, 1 and 2 are valid values");
            }
        }
        return n;
    }

    public final int component1() {
        return this.hour;
    }

    public final int component2() {
        return this.minute;
    }

    public final int component3() {
        return this.second;
    }

    @NotNull
    public final Time copy(int hour, int minute, int second) {
        return new Time(hour, minute, second);
    }

    public static /* synthetic */ Time copy$default(Time time, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = time.hour;
        }
        if ((n4 & 2) != 0) {
            n2 = time.minute;
        }
        if ((n4 & 4) != 0) {
            n3 = time.second;
        }
        return time.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.hour);
        result = result * 31 + Integer.hashCode(this.minute);
        result = result * 31 + Integer.hashCode(this.second);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Time)) {
            return false;
        }
        Time time = (Time)other;
        if (this.hour != time.hour) {
            return false;
        }
        if (this.minute != time.minute) {
            return false;
        }
        return this.second == time.second;
    }

    @Deprecated(message="\nAll functionality of the Time class was ported to kotlinx.datetime.LocalTime as extension functions and properties.\nYou can simply replace this with LocalTime and expect similar functionality to be present.\n", replaceWith=@ReplaceWith(expression="LocalTime", imports={"kotlinx.datetime.LocalTime"}))
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lpro/respawn/kmmutils/datetime/Time$Companion;", "", "()V", "MAX", "Lpro/respawn/kmmutils/datetime/Time;", "getMAX", "()Lpro/respawn/kmmutils/datetime/Time;", "MIN", "getMIN", "normalize", "Lkotlin/Triple;", "", "hours", "minutes", "seconds", "normalize$datetime", "parse", "s", "", "datetime"})
    @SourceDebugExtension(value={"SMAP\nTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Time.kt\npro/respawn/kmmutils/datetime/Time$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Time parse(@NotNull String s) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            try {
                if (!(!StringsKt.isBlank((CharSequence)s))) {
                    boolean $i$a$-require-Time$Companion$parse$522 = false;
                    String $i$a$-require-Time$Companion$parse$522 = "Empty time string";
                    throw new IllegalArgumentException($i$a$-require-Time$Companion$parse$522.toString());
                }
                String[] $i$a$-require-Time$Companion$parse$522 = new String[]{" "};
                List words = StringsKt.split$default((CharSequence)s, (String[])$i$a$-require-Time$Companion$parse$522, (boolean)false, (int)0, (int)6, null);
                int $i$a$-require-Time$Companion$parse$522 = words.size();
                if (!(1 <= $i$a$-require-Time$Companion$parse$522 ? $i$a$-require-Time$Companion$parse$522 < 3 : false)) {
                    boolean $i$a$-require-Time$Companion$parse$622 = false;
                    String $i$a$-require-Time$Companion$parse$622 = "Not a time";
                    throw new IllegalArgumentException($i$a$-require-Time$Companion$parse$622.toString());
                }
                char[] $i$a$-require-Time$Companion$parse$622 = new char[]{':', '.', '-', ' ', ',', '_'};
                List parts = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first((List)words)), (char[])$i$a$-require-Time$Companion$parse$622, (boolean)true, (int)0, (int)4, null);
                int $i$a$-require-Time$Companion$parse$622 = parts.size();
                if (!(2 <= $i$a$-require-Time$Companion$parse$622 ? $i$a$-require-Time$Companion$parse$622 < 4 : false)) {
                    boolean $i$a$-require-Time$Companion$parse$42 = false;
                    String $i$a$-require-Time$Companion$parse$42 = "Invalid delimiter count";
                    throw new IllegalArgumentException($i$a$-require-Time$Companion$parse$42.toString());
                }
                int hours = Integer.parseInt((String)parts.get(0)) + (words.size() == 2 && Intrinsics.areEqual(words.get(1), (Object)"PM") ? 12 : 0);
                int minutes = Integer.parseInt((String)parts.get(1));
                int seconds = parts.size() == 3 ? Integer.parseInt((String)parts.get(2)) : 0;
                return new Time(hours, minutes, seconds);
            }
            catch (Exception expected) {
                throw new IllegalArgumentException("Couldn't parse time", expected);
            }
        }

        @NotNull
        public final Time getMAX() {
            return MAX;
        }

        @NotNull
        public final Time getMIN() {
            return MIN;
        }

        @NotNull
        public final Triple<Integer, Integer, Integer> normalize$datetime(int hours, int minutes, int seconds) {
            int normalizedHours = hours + (minutes + seconds / 60) / 60;
            int normalizedMinutes = (minutes + seconds / 60) % 60;
            int normalizedSeconds = seconds % 60;
            return new Triple((Object)(normalizedHours % 24), (Object)normalizedMinutes, (Object)normalizedSeconds);
        }

        public static /* synthetic */ Triple normalize$datetime$default(Companion companion, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            return companion.normalize$datetime(n, n2, n3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

