/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.kmmutils.datetime;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000~\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0012\u0010\u0007\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u0006\u001a\u00020\b\u001a\u0012\u0010\u0011\u001a\u00020\b*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\b*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0019\u001a\u001e\u0010\u0015\u001a\u00020\u0016*\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020 *\u00020!\u001a\u001e\u0010\"\u001a\u00020!*\u00020\u00132\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u001e\u0010\"\u001a\u00020!*\u00020%2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010&\u001a\u00020\u0005*\u00020!\u001a\n\u0010'\u001a\u00020\u0005*\u00020!\u001a\n\u0010(\u001a\u00020 *\u00020!\u001a\n\u0010)\u001a\u00020 *\u00020!\u001a\n\u0010*\u001a\u00020 *\u00020!\u001a\n\u0010+\u001a\u00020 *\u00020!\u001a\u0012\u0010,\u001a\u00020 *\u00020!2\u0006\u0010-\u001a\u00020\u000e\u001a\u0012\u0010.\u001a\u00020 *\u00020!2\u0006\u0010-\u001a\u00020\u000e\u001a\u0014\u00101\u001a\u00020\u0001*\u00020\u00012\u0006\u00102\u001a\u000203H\u0007\u001a\u0012\u00101\u001a\u00020\u0001*\u00020\u00012\u0006\u00102\u001a\u000204\u001a \u00105\u001a\b\u0012\u0004\u0012\u00020\u001906*\b\u0012\u0004\u0012\u00020\u0019072\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\u0012\u00108\u001a\u00020\u0001*\u00020\b2\u0006\u00109\u001a\u00020:\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\t\u001a\u00020\u0005*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0003\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010/\u001a\u00020\u000e*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0010\u00a8\u0006;"}, d2={"midnight", "Ljava/time/ZonedDateTime;", "getMidnight", "(Ljava/time/ZonedDateTime;)Ljava/time/ZonedDateTime;", "onSameLocalDay", "", "other", "onSameUTCDay", "Ljava/time/Instant;", "isToday", "(Ljava/time/ZonedDateTime;)Z", "asStartOfWeek", "getAsStartOfWeek", "dayOfWeekValue", "", "getDayOfWeekValue", "(Ljava/time/ZonedDateTime;)I", "plusDays", "days", "", "minusDays", "asString", "", "formatter", "Ljava/time/format/DateTimeFormatter;", "Ljava/time/DayOfWeek;", "Ljava/time/Month;", "textStyle", "Ljava/time/format/TextStyle;", "locale", "Ljava/util/Locale;", "setToMidnight", "", "Ljava/util/Calendar;", "toCalendar", "timeZone", "Ljava/util/TimeZone;", "Ljava/util/Date;", "isCurrentMonth", "isCurrentYear", "resetToStartOfDay", "resetToEndOfDay", "resetToStartOfMonth", "resetToEndOfMonth", "setToMinimum", "field", "setToMaximum", "lengthOfMonth", "getLengthOfMonth", "withTime", "time", "Lkotlinx/datetime/LocalTime;", "Ljava/time/LocalTime;", "sortedByLocale", "", "", "toZDT", "zoneId", "Ljava/time/ZoneId;", "datetime"})
@SourceDebugExtension(value={"SMAP\nDateTimeExtJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeExtJvm.kt\npro/respawn/kmmutils/datetime/DateTimeExtJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1#2:218\n*E\n"})
public final class DateTimeExtJvmKt {
    @NotNull
    public static final ZonedDateTime getMidnight(@NotNull ZonedDateTime $this$midnight) {
        Intrinsics.checkNotNullParameter((Object)$this$midnight, (String)"<this>");
        ZonedDateTime zonedDateTime = $this$midnight.truncatedTo(ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"truncatedTo(...)");
        return zonedDateTime;
    }

    public static final boolean onSameLocalDay(@NotNull ZonedDateTime $this$onSameLocalDay, @NotNull ZonedDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$onSameLocalDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$onSameLocalDay.truncatedTo(ChronoUnit.DAYS), (Object)other.truncatedTo(ChronoUnit.DAYS));
    }

    public static final boolean onSameUTCDay(@NotNull Instant $this$onSameUTCDay, @NotNull Instant other) {
        Intrinsics.checkNotNullParameter((Object)$this$onSameUTCDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$onSameUTCDay.truncatedTo(ChronoUnit.DAYS), (Object)other.truncatedTo(ChronoUnit.DAYS));
    }

    public static final boolean isToday(@NotNull ZonedDateTime $this$isToday) {
        Intrinsics.checkNotNullParameter((Object)$this$isToday, (String)"<this>");
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(...)");
        return DateTimeExtJvmKt.onSameLocalDay($this$isToday, zonedDateTime);
    }

    @NotNull
    public static final ZonedDateTime getAsStartOfWeek(@NotNull ZonedDateTime $this$asStartOfWeek) {
        Intrinsics.checkNotNullParameter((Object)$this$asStartOfWeek, (String)"<this>");
        ZonedDateTime zonedDateTime = $this$asStartOfWeek.with(ChronoField.DAY_OF_WEEK, 1L);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"with(...)");
        return zonedDateTime;
    }

    public static final int getDayOfWeekValue(@NotNull ZonedDateTime $this$dayOfWeekValue) {
        Intrinsics.checkNotNullParameter((Object)$this$dayOfWeekValue, (String)"<this>");
        return $this$dayOfWeekValue.getDayOfWeek().getValue();
    }

    @NotNull
    public static final Instant plusDays(@NotNull Instant $this$plusDays, long days) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        Instant instant = $this$plusDays.plus(days, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        return instant;
    }

    @NotNull
    public static final Instant minusDays(@NotNull Instant $this$minusDays, long days) {
        Intrinsics.checkNotNullParameter((Object)$this$minusDays, (String)"<this>");
        Instant instant = $this$minusDays.minus(days, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
        return instant;
    }

    @NotNull
    public static final String asString(@NotNull Instant $this$asString, @NotNull DateTimeFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        String string = formatter.format($this$asString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final String asString(@NotNull DayOfWeek $this$asString) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        String string = $this$asString.getDisplayName(TextStyle.FULL, Locale.getDefault());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @NotNull
    public static final String asString(@NotNull Month $this$asString, @NotNull TextStyle textStyle, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)textStyle), (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        String string = $this$asString.getDisplayName(textStyle, locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    public static /* synthetic */ String asString$default(Month month, TextStyle textStyle, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            textStyle = TextStyle.FULL;
        }
        if ((n & 2) != 0) {
            locale = Locale.getDefault();
        }
        return DateTimeExtJvmKt.asString(month, textStyle, locale);
    }

    public static final void setToMidnight(@NotNull Calendar $this$setToMidnight) {
        Intrinsics.checkNotNullParameter((Object)$this$setToMidnight, (String)"<this>");
        $this$setToMidnight.set(11, 0);
        $this$setToMidnight.set(12, 0);
        $this$setToMidnight.set(13, 0);
        $this$setToMidnight.set(14, 0);
    }

    @NotNull
    public static final Calendar toCalendar(long $this$toCalendar, @NotNull TimeZone timeZone, @NotNull Locale locale) {
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Calendar it = calendar = Calendar.getInstance(timeZone, locale);
        boolean bl = false;
        it.setTimeInMillis($this$toCalendar);
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"also(...)");
        return calendar2;
    }

    public static /* synthetic */ Calendar toCalendar$default(long l, TimeZone timeZone, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.getDefault();
        }
        if ((n & 2) != 0) {
            locale = Locale.getDefault();
        }
        return DateTimeExtJvmKt.toCalendar(l, timeZone, locale);
    }

    @NotNull
    public static final Calendar toCalendar(@NotNull Date $this$toCalendar, @NotNull TimeZone timeZone, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$toCalendar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return DateTimeExtJvmKt.toCalendar($this$toCalendar.getTime(), timeZone, locale);
    }

    public static /* synthetic */ Calendar toCalendar$default(Date date, TimeZone timeZone, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            timeZone = TimeZone.getDefault();
        }
        if ((n & 2) != 0) {
            locale = Locale.getDefault();
        }
        return DateTimeExtJvmKt.toCalendar(date, timeZone, locale);
    }

    public static final boolean isCurrentMonth(@NotNull Calendar $this$isCurrentMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$isCurrentMonth, (String)"<this>");
        Calendar now = Calendar.getInstance($this$isCurrentMonth.getTimeZone());
        return now.get(2) == $this$isCurrentMonth.get(2) && now.get(1) == $this$isCurrentMonth.get(1);
    }

    public static final boolean isCurrentYear(@NotNull Calendar $this$isCurrentYear) {
        Intrinsics.checkNotNullParameter((Object)$this$isCurrentYear, (String)"<this>");
        return Calendar.getInstance($this$isCurrentYear.getTimeZone()).get(1) == $this$isCurrentYear.get(1);
    }

    public static final void resetToStartOfDay(@NotNull Calendar $this$resetToStartOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$resetToStartOfDay, (String)"<this>");
        DateTimeExtJvmKt.setToMinimum($this$resetToStartOfDay, 11);
        DateTimeExtJvmKt.setToMinimum($this$resetToStartOfDay, 12);
        DateTimeExtJvmKt.setToMinimum($this$resetToStartOfDay, 13);
        DateTimeExtJvmKt.setToMinimum($this$resetToStartOfDay, 14);
    }

    public static final void resetToEndOfDay(@NotNull Calendar $this$resetToEndOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$resetToEndOfDay, (String)"<this>");
        DateTimeExtJvmKt.setToMaximum($this$resetToEndOfDay, 11);
        DateTimeExtJvmKt.setToMaximum($this$resetToEndOfDay, 12);
        DateTimeExtJvmKt.setToMaximum($this$resetToEndOfDay, 13);
        DateTimeExtJvmKt.setToMaximum($this$resetToEndOfDay, 14);
    }

    public static final void resetToStartOfMonth(@NotNull Calendar $this$resetToStartOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$resetToStartOfMonth, (String)"<this>");
        DateTimeExtJvmKt.setToMinimum($this$resetToStartOfMonth, 5);
        DateTimeExtJvmKt.resetToStartOfDay($this$resetToStartOfMonth);
    }

    public static final void resetToEndOfMonth(@NotNull Calendar $this$resetToEndOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$resetToEndOfMonth, (String)"<this>");
        DateTimeExtJvmKt.setToMaximum($this$resetToEndOfMonth, 5);
        DateTimeExtJvmKt.resetToEndOfDay($this$resetToEndOfMonth);
    }

    public static final void setToMinimum(@NotNull Calendar $this$setToMinimum, int field) {
        Intrinsics.checkNotNullParameter((Object)$this$setToMinimum, (String)"<this>");
        $this$setToMinimum.set(field, $this$setToMinimum.getActualMinimum(field));
    }

    public static final void setToMaximum(@NotNull Calendar $this$setToMaximum, int field) {
        Intrinsics.checkNotNullParameter((Object)$this$setToMaximum, (String)"<this>");
        $this$setToMaximum.set(field, $this$setToMaximum.getActualMaximum(field));
    }

    public static final int getLengthOfMonth(@NotNull ZonedDateTime $this$lengthOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthOfMonth, (String)"<this>");
        return $this$lengthOfMonth.getMonth().length(Year.isLeap($this$lengthOfMonth.getYear()));
    }

    @Deprecated(message="Time class is deprecated")
    @NotNull
    public static final ZonedDateTime withTime(@NotNull ZonedDateTime $this$withTime, @NotNull kotlinx.datetime.LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        ZonedDateTime zonedDateTime = ZonedDateTime.of($this$withTime.getYear(), $this$withTime.getMonthValue(), $this$withTime.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond(), $this$withTime.getNano(), $this$withTime.getZone());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(...)");
        return zonedDateTime;
    }

    @NotNull
    public static final ZonedDateTime withTime(@NotNull ZonedDateTime $this$withTime, @NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        ZonedDateTime zonedDateTime = ZonedDateTime.of($this$withTime.getYear(), $this$withTime.getMonthValue(), $this$withTime.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond(), $this$withTime.getNano(), $this$withTime.getZone());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(...)");
        return zonedDateTime;
    }

    @NotNull
    public static final List<DayOfWeek> sortedByLocale(@NotNull Iterable<? extends DayOfWeek> $this$sortedByLocale, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter($this$sortedByLocale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        DayOfWeek first = WeekFields.of(locale).getFirstDayOfWeek();
        List all = CollectionsKt.toMutableList($this$sortedByLocale);
        if (all.remove(first)) {
            Intrinsics.checkNotNull((Object)first);
            all.add(0, first);
        }
        return all;
    }

    public static /* synthetic */ List sortedByLocale$default(Iterable iterable, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            locale = Locale.getDefault();
        }
        return DateTimeExtJvmKt.sortedByLocale(iterable, locale);
    }

    @NotNull
    public static final ZonedDateTime toZDT(@NotNull Instant $this$toZDT, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)$this$toZDT, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant($this$toZDT, zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ofInstant(...)");
        return zonedDateTime;
    }
}

