/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.kmmutils.datetime;

import java.time.DayOfWeek;
import java.time.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import pro.respawn.kmmutils.datetime.LocalTimeExtKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u0007*\u00020\u00072\n\u0010\b\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\u0007\u001a\"\u0010\u000e\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0011\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u001a\u0010\u0013\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u0015\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u0016\u001a\u00020\u0007*\u00020\u00072\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019\u001a\u001a\u0010\u001a\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u001c\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\"\u001a\u00020\u0007*\u00020#2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010$\u001a\u00020%*\u00020\u00072\u0006\u0010&\u001a\u00020\u0007\u001a\u001e\u0010'\u001a\u00020\u0007*\u00020\u00072\n\u0010\b\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010(\u001a\u00020\u0007*\u00020\u0007\u001a\u0015\u0010\u000e\u001a\u00020**\u00020*2\u0006\u0010.\u001a\u00020/H\u0086\u0002\u001a\u0016\u00100\u001a\u00020\u0001*\u00060\u0018j\u0002`\u00192\u0006\u00101\u001a\u00020\u0001\u001a\u0012\u0010\"\u001a\u00020\u001e*\u0002022\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0011\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u0012\u0010\u0013\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0001\"\u0019\u0010\u0000\u001a\u00020\u0001*\u00060\u0002j\u0002`\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u001d\u001a\u00020\u0001*\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010\u001d\u001a\u00020\u0001*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\"\u0015\u0010)\u001a\u00020**\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00063"}, d2={"value", "", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "getValue", "(Ljava/time/DayOfWeek;)I", "withPreviousOrSameDayOfWeek", "Lkotlinx/datetime/LocalDateTime;", "dayOfWeek", "zone", "Lkotlinx/datetime/TimeZone;", "asStartOfWeek", "asStartOfMonth", "asStartOfYear", "plus", "unit", "Lkotlinx/datetime/DateTimeUnit;", "withDayOfMonth", "day", "plusDays", "days", "minusDays", "withMonth", "month", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "plusMonths", "months", "minusMonths", "lengthOfMonth", "Lkotlinx/datetime/LocalDate;", "getLengthOfMonth", "(Lkotlinx/datetime/LocalDate;)I", "(Lkotlinx/datetime/LocalDateTime;)I", "now", "Lkotlinx/datetime/LocalDateTime$Companion;", "onSameDay", "", "other", "withNextDayOfWeek", "asMidnight", "EPOCH", "Lkotlinx/datetime/Instant;", "Lkotlinx/datetime/Instant$Companion;", "getEPOCH", "(Lkotlinx/datetime/Instant$Companion;)Lkotlinx/datetime/Instant;", "time", "Lkotlinx/datetime/LocalTime;", "length", "year", "Lkotlinx/datetime/LocalDate$Companion;", "datetime"})
public final class DateTimeExtKt {
    public static final int getValue(@NotNull DayOfWeek $this$value) {
        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"<this>");
        return $this$value.ordinal() + 1;
    }

    @NotNull
    public static final LocalDateTime withPreviousOrSameDayOfWeek(@NotNull LocalDateTime $this$withPreviousOrSameDayOfWeek, @NotNull DayOfWeek dayOfWeek, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$withPreviousOrSameDayOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dayOfWeek, (String)"dayOfWeek");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        int daysDiff = dayOfWeek.getValue() - $this$withPreviousOrSameDayOfWeek.getDayOfWeek().getValue();
        if (daysDiff == 0) {
            return $this$withPreviousOrSameDayOfWeek;
        }
        int daysToAdd = daysDiff >= 0 ? 7 - daysDiff : -daysDiff;
        return DateTimeExtKt.minusDays($this$withPreviousOrSameDayOfWeek, daysToAdd, zone);
    }

    @NotNull
    public static final LocalDateTime asStartOfWeek(@NotNull LocalDateTime $this$asStartOfWeek, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$asStartOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.asMidnight(DateTimeExtKt.withPreviousOrSameDayOfWeek($this$asStartOfWeek, DayOfWeek.MONDAY, zone));
    }

    @NotNull
    public static final LocalDateTime asStartOfMonth(@NotNull LocalDateTime $this$asStartOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$asStartOfMonth, (String)"<this>");
        return new LocalDateTime($this$asStartOfMonth.getYear(), $this$asStartOfMonth.getMonth(), 1, 0, 0, 0, 0);
    }

    @NotNull
    public static final LocalDateTime asStartOfYear(@NotNull LocalDateTime $this$asStartOfYear) {
        Intrinsics.checkNotNullParameter((Object)$this$asStartOfYear, (String)"<this>");
        return new LocalDateTime($this$asStartOfYear.getYear(), Month.JANUARY, 1, 0, 0, 0, 0);
    }

    @NotNull
    public static final LocalDateTime plus(@NotNull LocalDateTime $this$plus, int value, @NotNull DateTimeUnit unit, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return TimeZoneKt.toLocalDateTime((Instant)InstantJvmKt.plus((Instant)TimeZoneKt.toInstant((LocalDateTime)$this$plus, (TimeZone)zone), (int)value, (DateTimeUnit)unit, (TimeZone)zone), (TimeZone)zone);
    }

    @NotNull
    public static final LocalDateTime withDayOfMonth(@NotNull LocalDateTime $this$withDayOfMonth, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayOfMonth, (String)"<this>");
        return new LocalDateTime($this$withDayOfMonth.getYear(), $this$withDayOfMonth.getMonth(), day, $this$withDayOfMonth.getHour(), $this$withDayOfMonth.getMinute(), $this$withDayOfMonth.getSecond(), $this$withDayOfMonth.getNanosecond());
    }

    @NotNull
    public static final LocalDateTime plusDays(@NotNull LocalDateTime $this$plusDays, int days, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.plus($this$plusDays, days, (DateTimeUnit)DateTimeUnit.Companion.getDAY(), zone);
    }

    @NotNull
    public static final LocalDateTime minusDays(@NotNull LocalDateTime $this$minusDays, int days, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$minusDays, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.plus($this$minusDays, -days, (DateTimeUnit)DateTimeUnit.Companion.getDAY(), zone);
    }

    @NotNull
    public static final LocalDateTime withMonth(@NotNull LocalDateTime $this$withMonth, @NotNull Month month) {
        Intrinsics.checkNotNullParameter((Object)$this$withMonth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        return new LocalDateTime($this$withMonth.getYear(), month, $this$withMonth.getDayOfMonth(), $this$withMonth.getHour(), $this$withMonth.getMinute(), $this$withMonth.getSecond(), $this$withMonth.getNanosecond());
    }

    @NotNull
    public static final LocalDateTime plusMonths(@NotNull LocalDateTime $this$plusMonths, int months, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$plusMonths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.plus($this$plusMonths, months, (DateTimeUnit)DateTimeUnit.Companion.getMONTH(), zone);
    }

    @NotNull
    public static final LocalDateTime minusMonths(@NotNull LocalDateTime $this$minusMonths, int months, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$minusMonths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.plus($this$minusMonths, -months, (DateTimeUnit)DateTimeUnit.Companion.getMONTH(), zone);
    }

    public static final int getLengthOfMonth(@NotNull LocalDate $this$lengthOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthOfMonth, (String)"<this>");
        return DateTimeExtKt.length($this$lengthOfMonth.getMonth(), $this$lengthOfMonth.getYear());
    }

    public static final int getLengthOfMonth(@NotNull LocalDateTime $this$lengthOfMonth) {
        Intrinsics.checkNotNullParameter((Object)$this$lengthOfMonth, (String)"<this>");
        return DateTimeExtKt.length($this$lengthOfMonth.getMonth(), $this$lengthOfMonth.getYear());
    }

    @NotNull
    public static final LocalDateTime now(@NotNull LocalDateTime.Companion $this$now, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)zone);
    }

    public static final boolean onSameDay(@NotNull LocalDateTime $this$onSameDay, @NotNull LocalDateTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$onSameDay, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$onSameDay.getDate(), (Object)other.getDate());
    }

    @NotNull
    public static final LocalDateTime withNextDayOfWeek(@NotNull LocalDateTime $this$withNextDayOfWeek, @NotNull DayOfWeek dayOfWeek, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$withNextDayOfWeek, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dayOfWeek, (String)"dayOfWeek");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        int daysDiff = $this$withNextDayOfWeek.getDayOfWeek().getValue() - dayOfWeek.getValue();
        int daysToAdd = daysDiff >= 0 ? 7 - daysDiff : -daysDiff;
        return DateTimeExtKt.plusDays($this$withNextDayOfWeek, daysToAdd, zone);
    }

    @NotNull
    public static final LocalDateTime asMidnight(@NotNull LocalDateTime $this$asMidnight) {
        Intrinsics.checkNotNullParameter((Object)$this$asMidnight, (String)"<this>");
        return new LocalDateTime($this$asMidnight.getYear(), $this$asMidnight.getMonth(), $this$asMidnight.getDayOfMonth(), 0, 0, 0, 0);
    }

    @NotNull
    public static final Instant getEPOCH(@NotNull Instant.Companion $this$EPOCH) {
        Intrinsics.checkNotNullParameter((Object)$this$EPOCH, (String)"<this>");
        return $this$EPOCH.fromEpochMilliseconds(0L);
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $this$plus, @NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return $this$plus.plus-LRDsOJo(LocalTimeExtKt.getAsDuration(time));
    }

    public static final int length(@NotNull Month $this$length, int year) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        LocalDate start = new LocalDate(year, $this$length, 1);
        LocalDate end = LocalDateJvmKt.plus((LocalDate)start, (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getMONTH()));
        return LocalDateJvmKt.until((LocalDate)start, (LocalDate)end, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY()));
    }

    @NotNull
    public static final LocalDate now(@NotNull LocalDate.Companion $this$now, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.now(LocalDateTime.Companion, zone).getDate();
    }

    @NotNull
    public static final LocalDate withDayOfMonth(@NotNull LocalDate $this$withDayOfMonth, int day) {
        Intrinsics.checkNotNullParameter((Object)$this$withDayOfMonth, (String)"<this>");
        return new LocalDate($this$withDayOfMonth.getYear(), $this$withDayOfMonth.getMonth(), day);
    }

    @NotNull
    public static final LocalDate plusDays(@NotNull LocalDate $this$plusDays, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$plusDays, (String)"<this>");
        return LocalDateJvmKt.plus((LocalDate)$this$plusDays, (int)days, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY()));
    }
}

