/*
 * Decompiled with CFR 0.152.
 */
package pro.respawn.kmmutils.datetime;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.respawn.kmmutils.datetime.DateTimeExtKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\u0015\u0010\t\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0004\u001a\u001c\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\b\u001a\u0015\u0010\u0011\u001a\u00020\b*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0004\u001a(\u0010\u001f\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010 \u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\b2\b\b\u0002\u0010\"\u001a\u00020\b\u001a\u0012\u0010#\u001a\u00020$*\u00020%2\u0006\u0010&\u001a\u00020\b\u001a\u001c\u0010'\u001a\u00020\u0004*\u00020%2\u0006\u0010(\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0004\b)\u0010*\u001a\u0012\u0010+\u001a\u00020\u0004*\u00020%2\u0006\u0010,\u001a\u00020\b\u001a\u0012\u0010-\u001a\u00020\u0004*\u00020%2\u0006\u0010.\u001a\u00020\b\u001a\u0012\u0010/\u001a\u00020\u0004*\u00020%2\u0006\u0010\"\u001a\u00020\b\u001a(\u00100\u001a\u00020\u0004*\u00020%2\b\b\u0002\u0010 \u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\b2\b\b\u0002\u0010\"\u001a\u00020\b\u001a\u0014\u00101\u001a\u0004\u0018\u00010\u0004*\u00020%2\u0006\u00102\u001a\u00020$\u001a\u0012\u00103\u001a\u00020\u0014*\u00020%2\u0006\u0010\u0003\u001a\u00020$\u001a\u000e\u00106\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010$\u001a\u0017\u00107\u001a\u00020\u000e*\n\u0012\u0006\u0012\u0004\u0018\u00010\u000408\u00a2\u0006\u0002\u00109\u001a\u0019\u00107\u001a\u00020\u0004*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040:H\u0007\u00a2\u0006\u0002\b;\u001a\u000e\u0010?\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u0004\u001a\u001e\u0010@\u001a\u00020$*\u00020\u00042\b\b\u0002\u0010A\u001a\u00020\u00142\b\b\u0002\u0010B\u001a\u00020\u0014\u001a\u0015\u0010C\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002\u001a\u0015\u0010D\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002\u001a\u0015\u0010E\u001a\u00020\b*\u00020\u00042\u0006\u0010F\u001a\u00020\bH\u0086\u0002\u001a\u0012\u0010J\u001a\u00020\u0004*\u00020%2\u0006\u00102\u001a\u00020$\u001a<\u0010M\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0N*\u00020%2\b\b\u0002\u0010 \u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\b2\b\b\u0002\u0010\"\u001a\u00020\bH\u0000\u001a\u0012\u0010O\u001a\u00020\u0004*\u00020%2\u0006\u0010P\u001a\u00020Q\u001a\n\u0010R\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010S\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010T\u001a\u00020\u0004*\u00020\u0004\"\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u0017*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0015\u0010\u001a\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0015\u0010\u001d\u001a\u00020\b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\"\u0017\u00104\u001a\u00020\u0014*\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\"\u0015\u0010<\u001a\u00020\u0004*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\"\u0015\u0010G\u001a\u00020\u0004*\u00020%8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010I\"\u0015\u0010K\u001a\u00020\u0004*\u00020%8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010I\u00a8\u0006U"}, d2={"atTime", "Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/LocalDate;", "time", "Lkotlinx/datetime/LocalTime;", "atDate", "date", "toInt", "", "distanceTo", "other", "withTime", "nanos", "asDuration", "Lkotlin/time/Duration;", "getAsDuration", "(Lkotlinx/datetime/LocalTime;)J", "distanceInSeconds", "to", "isPM", "", "(Lkotlinx/datetime/LocalTime;)Z", "totalMinutes", "", "getTotalMinutes", "(Lkotlinx/datetime/LocalTime;)D", "totalSeconds", "getTotalSeconds", "(Lkotlinx/datetime/LocalTime;)I", "hourAs12H", "getHourAs12H", "add", "hours", "minutes", "seconds", "asTimeNumber", "", "Lkotlinx/datetime/LocalTime$Companion;", "value", "invoke", "duration", "invoke-HG0u8IE", "(Lkotlinx/datetime/LocalTime$Companion;J)Lkotlinx/datetime/LocalTime;", "ofInt", "hms", "ofMillis", "millis", "ofSeconds", "with", "parseOrNull", "s", "isValid", "isValidLocalTime", "(Ljava/lang/String;)Z", "toLocalTimeOrNull", "totalDuration", "", "(Ljava/lang/Iterable;)J", "Lkotlin/sequences/Sequence;", "totalDurationSequence", "asLocalTime", "getAsLocalTime-LRDsOJo", "(J)Lkotlinx/datetime/LocalTime;", "takeIfNotZero", "asString", "use12h", "addSecondsIfZero", "plus", "minus", "get", "index", "MAX", "getMAX", "(Lkotlinx/datetime/LocalTime$Companion;)Lkotlinx/datetime/LocalTime;", "parseAs12H", "MIN", "getMIN", "normalize", "Lkotlin/Triple;", "now", "zone", "Lkotlinx/datetime/TimeZone;", "truncateNanos", "truncateSeconds", "truncateMinutes", "datetime"})
@SourceDebugExtension(value={"SMAP\nLocalTimeExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTimeExt.kt\npro/respawn/kmmutils/datetime/LocalTimeExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1#2:315\n*E\n"})
public final class LocalTimeExtKt {
    @NotNull
    public static final LocalDateTime atTime(@NotNull LocalDate $this$atTime, @NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)$this$atTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return LocalDateKt.atTime$default((LocalDate)$this$atTime, (int)time.getHour(), (int)time.getMinute(), (int)time.getSecond(), (int)0, (int)8, null);
    }

    @NotNull
    public static final LocalDateTime atDate(@NotNull LocalTime $this$atDate, @NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)$this$atDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new LocalDateTime(date, $this$atDate);
    }

    public static final int toInt(@NotNull LocalTime $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return $this$toInt.getHour() * 10000 + $this$toInt.getMinute() * 100 + $this$toInt.getSecond();
    }

    @NotNull
    public static final LocalTime distanceTo(@NotNull LocalTime $this$distanceTo, @NotNull LocalTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LocalTime.Companion.fromSecondOfDay(Math.abs(other.toSecondOfDay() - $this$distanceTo.toSecondOfDay()));
    }

    @NotNull
    public static final LocalDateTime withTime(@NotNull LocalDateTime $this$withTime, @NotNull LocalTime time, int nanos) {
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new LocalDateTime($this$withTime.getYear(), $this$withTime.getMonth(), $this$withTime.getDay(), time.getHour(), time.getMinute(), time.getSecond(), nanos);
    }

    public static /* synthetic */ LocalDateTime withTime$default(LocalDateTime localDateTime, LocalTime localTime, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = localDateTime.getNanosecond();
        }
        return LocalTimeExtKt.withTime(localDateTime, localTime, n);
    }

    public static final long getAsDuration(@NotNull LocalTime $this$asDuration) {
        Intrinsics.checkNotNullParameter((Object)$this$asDuration, (String)"<this>");
        return DurationKt.toDuration((long)$this$asDuration.toNanosecondOfDay(), (DurationUnit)DurationUnit.NANOSECONDS);
    }

    public static final int distanceInSeconds(@NotNull LocalTime $this$distanceInSeconds, @NotNull LocalTime to) {
        Intrinsics.checkNotNullParameter((Object)$this$distanceInSeconds, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return Math.abs(to.getHour() - $this$distanceInSeconds.getHour()) * 60 * 60 + Math.abs(to.getMinute() - $this$distanceInSeconds.getMinute()) * 60 + Math.abs(to.getSecond() - $this$distanceInSeconds.getSecond());
    }

    public static final boolean isPM(@NotNull LocalTime $this$isPM) {
        Intrinsics.checkNotNullParameter((Object)$this$isPM, (String)"<this>");
        return $this$isPM.getHour() >= 12;
    }

    public static final double getTotalMinutes(@NotNull LocalTime $this$totalMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$totalMinutes, (String)"<this>");
        return (double)($this$totalMinutes.getHour() * 60 + $this$totalMinutes.getMinute()) + (double)$this$totalMinutes.getSecond() / (double)60;
    }

    public static final int getTotalSeconds(@NotNull LocalTime $this$totalSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$totalSeconds, (String)"<this>");
        return $this$totalSeconds.getHour() * 3600 + $this$totalSeconds.getMinute() * 60 + $this$totalSeconds.getSecond();
    }

    public static final int getHourAs12H(@NotNull LocalTime $this$hourAs12H) {
        Intrinsics.checkNotNullParameter((Object)$this$hourAs12H, (String)"<this>");
        return $this$hourAs12H.getHour() % 12 == 0 ? $this$hourAs12H.getHour() : $this$hourAs12H.getHour() % 12;
    }

    @NotNull
    public static final LocalTime add(@NotNull LocalTime $this$add, int hours, int minutes, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"<this>");
        Triple<Integer, Integer, Integer> triple = LocalTimeExtKt.normalize(LocalTime.Companion, hours, minutes, seconds);
        int normalizedHours = ((Number)triple.component1()).intValue();
        int normalizedMinutes = ((Number)triple.component2()).intValue();
        int normalizedSeconds = ((Number)triple.component3()).intValue();
        int hDelta = (normalizedHours + $this$add.getHour() + ($this$add.getMinute() + normalizedMinutes) / 60 + ($this$add.getSecond() + normalizedSeconds) / 3600) % 24;
        int mDelta = ($this$add.getMinute() + normalizedMinutes + ($this$add.getSecond() + normalizedSeconds) / 60) % 60;
        int sDelta = ($this$add.getSecond() + normalizedSeconds) % 60;
        int h = (hDelta >= 0 ? hDelta : hDelta + 24) % 24;
        int m = mDelta >= 0 ? mDelta : mDelta + 60;
        int s = sDelta >= 0 ? sDelta : sDelta + 60;
        return new LocalTime(h, m, s, $this$add.getNanosecond());
    }

    public static /* synthetic */ LocalTime add$default(LocalTime localTime, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return LocalTimeExtKt.add(localTime, n, n2, n3);
    }

    @NotNull
    public static final String asTimeNumber(@NotNull LocalTime.Companion $this$asTimeNumber, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$asTimeNumber, (String)"<this>");
        return value < 10 ? "" + '0' + value : String.valueOf(value);
    }

    @NotNull
    public static final LocalTime invoke-HG0u8IE(@NotNull LocalTime.Companion $this$invoke_u2dHG0u8IE, long duration) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke_u2dHG0u8IE, (String)"$this$invoke");
        return $this$invoke_u2dHG0u8IE.fromNanosecondOfDay(Duration.getInWholeNanoseconds-impl((long)duration));
    }

    @NotNull
    public static final LocalTime ofInt(@NotNull LocalTime.Companion $this$ofInt, int hms) {
        Intrinsics.checkNotNullParameter((Object)$this$ofInt, (String)"<this>");
        return new LocalTime(hms / 10000, hms / 100 % 100, hms % 100, 0, 8, null);
    }

    @NotNull
    public static final LocalTime ofMillis(@NotNull LocalTime.Companion $this$ofMillis, int millis) {
        Intrinsics.checkNotNullParameter((Object)$this$ofMillis, (String)"<this>");
        return $this$ofMillis.fromMillisecondOfDay(millis);
    }

    @NotNull
    public static final LocalTime ofSeconds(@NotNull LocalTime.Companion $this$ofSeconds, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$ofSeconds, (String)"<this>");
        return $this$ofSeconds.fromSecondOfDay(seconds);
    }

    @NotNull
    public static final LocalTime with(@NotNull LocalTime.Companion $this$with, int hours, int minutes, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        return LocalTimeExtKt.add(LocalTimeExtKt.getMIN($this$with), hours, minutes, seconds);
    }

    public static /* synthetic */ LocalTime with$default(LocalTime.Companion companion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return LocalTimeExtKt.with(companion, n, n2, n3);
    }

    @Nullable
    public static final LocalTime parseOrNull(@NotNull LocalTime.Companion $this$parseOrNull, @NotNull String s) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$parseOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Object object2 = s;
        try {
            String $this$parseOrNull_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)LocalTime.Companion.parse$default((LocalTime.Companion)$this$parseOrNull, (CharSequence)$this$parseOrNull_u24lambda_u240, null, (int)2, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (LocalTime)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    public static final boolean isValid(@NotNull LocalTime.Companion $this$isValid, @NotNull String time) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return LocalTimeExtKt.parseOrNull($this$isValid, time) != null;
    }

    public static final boolean isValidLocalTime(@Nullable String $this$isValidLocalTime) {
        boolean bl;
        String string = $this$isValidLocalTime;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = LocalTimeExtKt.isValid(LocalTime.Companion, it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final LocalTime toLocalTimeOrNull(@Nullable String $this$toLocalTimeOrNull) {
        LocalTime localTime;
        String string = $this$toLocalTimeOrNull;
        if (string != null) {
            String it = string;
            boolean bl = false;
            localTime = LocalTimeExtKt.parseOrNull(LocalTime.Companion, $this$toLocalTimeOrNull);
        } else {
            localTime = null;
        }
        return localTime;
    }

    /*
     * WARNING - void declaration
     */
    public static final long totalDuration(@NotNull Iterable<LocalTime> $this$totalDuration) {
        Intrinsics.checkNotNullParameter($this$totalDuration, (String)"<this>");
        Iterable<LocalTime> iterable = $this$totalDuration;
        long l = 0L;
        Iterator<LocalTime> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            LocalTime localTime;
            LocalTime localTime2 = localTime = iterator.next();
            long l2 = l;
            boolean bl = false;
            void v0 = it;
            long l3 = v0 != null ? v0.toNanosecondOfDay() : 0L;
            l = l2 + l3;
        }
        return DurationKt.toDuration((long)l, (DurationUnit)DurationUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="totalDurationSequence")
    @NotNull
    public static final LocalTime totalDurationSequence(@NotNull Sequence<LocalTime> $this$totalDuration) {
        int n;
        Intrinsics.checkNotNullParameter($this$totalDuration, (String)"<this>");
        Sequence<LocalTime> sequence = $this$totalDuration;
        LocalTime.Companion companion = LocalTime.Companion;
        int n2 = 0;
        for (Object e : sequence) {
            void it;
            LocalTime localTime = (LocalTime)e;
            n = n2;
            boolean bl = false;
            void v0 = it;
            int n3 = v0 != null ? LocalTimeExtKt.getTotalSeconds((LocalTime)v0) : 0;
            n2 = n + n3;
        }
        n = n2;
        return LocalTimeExtKt.ofSeconds(companion, n);
    }

    @NotNull
    public static final LocalTime getAsLocalTime-LRDsOJo(long $this$asLocalTime) {
        return LocalTime.Companion.fromNanosecondOfDay(Duration.getInWholeNanoseconds-impl((long)$this$asLocalTime));
    }

    @Nullable
    public static final LocalTime takeIfNotZero(@Nullable LocalTime $this$takeIfNotZero) {
        LocalTime localTime;
        LocalTime it = localTime = $this$takeIfNotZero;
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it, (Object)LocalTimeExtKt.getMIN(LocalTime.Companion)) ? localTime : null;
    }

    @NotNull
    public static final String asString(@NotNull LocalTime $this$asString, boolean use12h, boolean addSecondsIfZero) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        StringBuilder $this$asString_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u246.append(LocalTimeExtKt.asTimeNumber(LocalTime.Companion, use12h ? LocalTimeExtKt.getHourAs12H($this$asString) : $this$asString.getHour()) + ':' + LocalTimeExtKt.asTimeNumber(LocalTime.Companion, $this$asString.getMinute()));
        if (addSecondsIfZero || $this$asString.getSecond() != 0) {
            $this$asString_u24lambda_u246.append(':' + LocalTimeExtKt.asTimeNumber(LocalTime.Companion, $this$asString.getSecond()));
        }
        if (use12h) {
            $this$asString_u24lambda_u246.append(' ' + (LocalTimeExtKt.isPM($this$asString) ? "PM" : "AM"));
        }
        return stringBuilder.toString();
    }

    public static /* synthetic */ String asString$default(LocalTime localTime, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return LocalTimeExtKt.asString(localTime, bl, bl2);
    }

    @NotNull
    public static final LocalTime plus(@NotNull LocalTime $this$plus, @NotNull LocalTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LocalTimeExtKt.add($this$plus, other.getHour(), other.getMinute(), other.getSecond());
    }

    @NotNull
    public static final LocalTime minus(@NotNull LocalTime $this$minus, @NotNull LocalTime other) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LocalTimeExtKt.add($this$minus, -other.getHour(), -other.getMinute(), -other.getSecond());
    }

    public static final int get(@NotNull LocalTime $this$get, int index) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        switch (index) {
            case 0: {
                n = $this$get.getHour();
                break;
            }
            case 1: {
                n = $this$get.getMinute();
                break;
            }
            case 2: {
                n = $this$get.getSecond();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Only 0, 1 and 2 are valid values");
            }
        }
        return n;
    }

    @NotNull
    public static final LocalTime getMAX(@NotNull LocalTime.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return new LocalTime(23, 59, 59, 999999999);
    }

    @NotNull
    public static final LocalTime parseAs12H(@NotNull LocalTime.Companion $this$parseAs12H, @NotNull String s) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)$this$parseAs12H, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            if (!(!StringsKt.isBlank((CharSequence)s))) {
                boolean $i$a$-require-LocalTimeExtKt$parseAs12H$522 = false;
                String $i$a$-require-LocalTimeExtKt$parseAs12H$522 = "Empty time string";
                throw new IllegalArgumentException($i$a$-require-LocalTimeExtKt$parseAs12H$522.toString());
            }
            String[] $i$a$-require-LocalTimeExtKt$parseAs12H$522 = new String[]{" "};
            List words = StringsKt.split$default((CharSequence)s, (String[])$i$a$-require-LocalTimeExtKt$parseAs12H$522, (boolean)false, (int)0, (int)6, null);
            int $i$a$-require-LocalTimeExtKt$parseAs12H$522 = words.size();
            if (!(1 <= $i$a$-require-LocalTimeExtKt$parseAs12H$522 ? $i$a$-require-LocalTimeExtKt$parseAs12H$522 < 3 : false)) {
                boolean $i$a$-require-LocalTimeExtKt$parseAs12H$622 = false;
                String $i$a$-require-LocalTimeExtKt$parseAs12H$622 = "Not a time";
                throw new IllegalArgumentException($i$a$-require-LocalTimeExtKt$parseAs12H$622.toString());
            }
            char[] $i$a$-require-LocalTimeExtKt$parseAs12H$622 = new char[]{':', '.', '-', ' ', ',', '_'};
            List parts = StringsKt.split$default((CharSequence)((CharSequence)CollectionsKt.first((List)words)), (char[])$i$a$-require-LocalTimeExtKt$parseAs12H$622, (boolean)true, (int)0, (int)4, null);
            int $i$a$-require-LocalTimeExtKt$parseAs12H$622 = parts.size();
            if (!(2 <= $i$a$-require-LocalTimeExtKt$parseAs12H$622 ? $i$a$-require-LocalTimeExtKt$parseAs12H$622 < 4 : false)) {
                boolean $i$a$-require-LocalTimeExtKt$parseAs12H$42 = false;
                String $i$a$-require-LocalTimeExtKt$parseAs12H$42 = "Invalid delimiter count";
                throw new IllegalArgumentException($i$a$-require-LocalTimeExtKt$parseAs12H$42.toString());
            }
            int hours = Integer.parseInt((String)parts.get(0)) + (words.size() == 2 && Intrinsics.areEqual(words.get(1), (Object)"PM") ? 12 : 0);
            int minutes = Integer.parseInt((String)parts.get(1));
            int seconds = parts.size() == 3 ? Integer.parseInt((String)parts.get(2)) : 0;
            return new LocalTime(hours, minutes, seconds, 0, 8, null);
        }
        catch (Exception expected) {
            throw new IllegalArgumentException("Couldn't parse time", expected);
        }
    }

    @NotNull
    public static final LocalTime getMIN(@NotNull LocalTime.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN, (String)"<this>");
        return new LocalTime(0, 0, 0, 0, 12, null);
    }

    @NotNull
    public static final Triple<Integer, Integer, Integer> normalize(@NotNull LocalTime.Companion $this$normalize, int hours, int minutes, int seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        int normalizedHours = hours + (minutes + seconds / 60) / 60;
        int normalizedMinutes = (minutes + seconds / 60) % 60;
        int normalizedSeconds = seconds % 60;
        return new Triple((Object)(normalizedHours % 24), (Object)normalizedMinutes, (Object)normalizedSeconds);
    }

    public static /* synthetic */ Triple normalize$default(LocalTime.Companion companion, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return LocalTimeExtKt.normalize(companion, n, n2, n3);
    }

    @NotNull
    public static final LocalTime now(@NotNull LocalTime.Companion $this$now, @NotNull TimeZone zone) {
        Intrinsics.checkNotNullParameter((Object)$this$now, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        return DateTimeExtKt.now(LocalDateTime.Companion, zone).getTime();
    }

    @NotNull
    public static final LocalTime truncateNanos(@NotNull LocalTime $this$truncateNanos) {
        Intrinsics.checkNotNullParameter((Object)$this$truncateNanos, (String)"<this>");
        return new LocalTime($this$truncateNanos.getHour(), $this$truncateNanos.getMinute(), $this$truncateNanos.getSecond(), 0);
    }

    @NotNull
    public static final LocalTime truncateSeconds(@NotNull LocalTime $this$truncateSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$truncateSeconds, (String)"<this>");
        return new LocalTime($this$truncateSeconds.getHour(), $this$truncateSeconds.getMinute(), 0, 0);
    }

    @NotNull
    public static final LocalTime truncateMinutes(@NotNull LocalTime $this$truncateMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$truncateMinutes, (String)"<this>");
        return new LocalTime($this$truncateMinutes.getHour(), 0, 0, 0);
    }
}

