/*
 * Decompiled with CFR 0.152.
 */
package pro.safeworld.swasdk;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import pro.safeworld.swasdk.User;
import pro.safeworld.swasdk.data.comm.AuthBody;
import pro.safeworld.swasdk.data.comm.ReqData;

public abstract class Request {
    protected User user;

    public Request(User user) {
        this.user = user;
    }

    protected String request(String method, ReqData param) {
        String url = this.getUrl(method);
        String json = this.buildParam(param);
        return this.post(url, json);
    }

    public abstract String getHost();

    private String buildParam(ReqData param) {
        int time = this.user.getTimes();
        AuthBody authBody = new AuthBody();
        authBody.setApiKey(this.user.getApiKey());
        authBody.setToken(this.user.getToken(String.valueOf(time)));
        authBody.setTimestamp(this.user.getTimes());
        this.user.unsetTime();
        param.setAuth(authBody);
        pro.safeworld.swasdk.data.comm.Request request = new pro.safeworld.swasdk.data.comm.Request();
        request.setAppid(this.user.getAppid());
        request.setData(param);
        return JSON.toJSONString((Object)request);
    }

    private String getUrl(String method) {
        return this.getHost() + method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(String url, String param) {
        OutputStreamWriter out = null;
        BufferedReader reader = null;
        String response = "";
        try {
            String lines;
            URL httpUrl = null;
            httpUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("connection", "keep-alive");
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.connect();
            out = new OutputStreamWriter(conn.getOutputStream());
            out.write(param);
            out.flush();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((lines = reader.readLine()) != null) {
                lines = new String(lines.getBytes(), "utf-8");
                response = response + lines;
            }
            reader.close();
            conn.disconnect();
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return response;
    }
}

