/*
 * Decompiled with CFR 0.152.
 */
package pro.savant.circumflex.security;

import pro.savant.circumflex.core.parse$;
import pro.savant.circumflex.security.Auth;
import pro.savant.circumflex.security.Auth$;
import pro.savant.circumflex.security.DefaultSsoManager$;
import pro.savant.circumflex.security.Principal;
import pro.savant.circumflex.security.SsoManager;
import pro.savant.circumflex.security.package$;
import pro.savant.circumflex.web.HttpCookie;
import pro.savant.circumflex.web.HttpCookie$;
import pro.savant.circumflex.web.HttpRequest;
import pro.savant.circumflex.web.HttpResponse;
import pro.savant.circumflex.web.param$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class Auth$class {
    public static Nothing$ authError(Auth $this, String message) {
        return pro.savant.circumflex.web.package$.MODULE$.sendError(401, message);
    }

    public static Option returnLocationOption(Auth $this) {
        return param$.MODULE$.get("returnTo").orElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return pro.savant.circumflex.web.package$.MODULE$.session().getString("cx.auth.returnTo");
            }
        }).orElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return pro.savant.circumflex.web.package$.MODULE$.request().headers().get("Referer");
            }
        }).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final boolean apply(String x$1) {
                return !x$1.startsWith(new StringBuilder().append((Object)this.$outer.secureOrigin()).append((Object)"/auth").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String returnLocation(Auth $this) {
        return (String)$this.returnLocationOption().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final String apply() {
                return this.$outer.defaultReturnLocation();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String secureScheme(Auth $this) {
        return "https";
    }

    public static boolean isSecure(Auth $this) {
        String string = $this.secureScheme();
        String string2 = "https";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static String secureOrigin(Auth $this) {
        return new StringBuilder().append((Object)$this.secureScheme()).append((Object)"://").append((Object)$this.secureDomain()).toString();
    }

    public static SsoManager ssoManager(Auth $this) {
        return DefaultSsoManager$.MODULE$;
    }

    public static Option principalOption(Auth $this) {
        return pro.savant.circumflex.core.package$.MODULE$.ctx().getAs($this.KEY()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final boolean apply(U x$2) {
                U u = x$2;
                U u2 = this.$outer.anonymous();
                return u != null ? !u.equals(u2) : u2 != null;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Principal principalOrAnonymous(Auth $this) {
        return (Principal)$this.principalOption().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final U apply() {
                return this.$outer.anonymous();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Principal principal(Auth $this) {
        return (Principal)$this.principalOption().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final Nothing$ apply() {
                return this.$outer.authError("Authentication is required to access this resource.");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean isEmpty(Auth $this) {
        return $this.principalOption().isEmpty();
    }

    public static void set(Auth $this, Principal principal2) {
        Principal principal3 = principal2;
        Object u = $this.anonymous();
        if (!(principal3 != null ? !principal3.equals(u) : u != null)) {
            pro.savant.circumflex.core.package$.MODULE$.ctx().$minus$eq((Object)$this.KEY());
        } else {
            pro.savant.circumflex.core.package$.MODULE$.ctx().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)$this.KEY()), (Object)principal2));
        }
    }

    public static void setSessionAuth(Auth $this, Principal principal2, String ssoId) {
        pro.savant.circumflex.web.package$.MODULE$.sessionOption().map((Function1)new Serializable($this, principal2, ssoId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;
            private final Principal principal$2;
            private final String ssoId$1;

            public final void apply(HttpRequest.Session sess) {
                sess.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.KEY()), (Object)this.principal$2.uniqueId()));
                this.$outer.ssoManager().registerSession(this.ssoId$1);
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.principal$2 = principal$2;
                this.ssoId$1 = var3_3;
            }
        });
    }

    public static void doSessionAuth(Auth $this) {
        pro.savant.circumflex.web.package$.MODULE$.sessionOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final void apply(HttpRequest.Session sess) {
                Some x2;
                Option option = sess.getString(this.$outer.KEY());
                if (option instanceof Some && (x2 = (Some)option) != null) {
                    String id = (String)x2.x();
                    this.liftedTree1$1(id);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private final void liftedTree1$1(String id$1) {
                try {
                    Principal principal2 = (Principal)this.$outer.lookup(id$1).get();
                    if (!this.$outer.ssoManager().checkCurrentSession()) {
                        throw new IllegalStateException();
                    }
                    this.$outer.set(principal2);
                    this.$outer.ssoManager().touchCurrentSession();
                }
                catch (Exception exception) {
                    this.$outer.ssoManager().invalidateCurrentSession();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void login(Auth $this, Principal principal2, boolean rememberMe) {
        $this.principalOption().filter((Function1)new Serializable($this, principal2){
            public static final long serialVersionUID = 0L;
            private final Principal principal$3;

            public final boolean apply(U x$3) {
                String string = x$3.uniqueId();
                String string2 = this.principal$3.uniqueId();
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.principal$3 = principal$3;
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final void apply(U x$4) {
                this.$outer.logout();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        $this.set(principal2);
        String ssoId = pro.savant.circumflex.core.package$.MODULE$.randomString(8);
        $this.setSessionAuth(principal2, ssoId);
        if (rememberMe) {
            $this.setRememberMeCookie();
        } else {
            $this.dropRememberMeCookie();
        }
    }

    public static void logout(Auth $this) {
        $this.ssoManager().invalidateCurrentSession();
        $this.dropRememberMeCookie();
        pro.savant.circumflex.core.package$.MODULE$.ctx().$minus$eq((Object)$this.KEY());
    }

    public static void require(Auth $this) {
        if ($this.isEmpty()) {
            String string = pro.savant.circumflex.web.package$.MODULE$.request().method();
            String string2 = "get";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String url = new StringBuilder().append((Object)pro.savant.circumflex.web.package$.MODULE$.origin()).append((Object)pro.savant.circumflex.web.package$.MODULE$.request().originalUri()).toString();
                String string3 = pro.savant.circumflex.web.package$.MODULE$.request().queryString();
                String string4 = "";
                if (string3 == null ? string4 != null : !string3.equals(string4)) {
                    url = new StringBuilder().append((Object)url).append((Object)new StringBuilder().append((Object)"?").append((Object)pro.savant.circumflex.web.package$.MODULE$.encodeURI(pro.savant.circumflex.web.package$.MODULE$.request().queryString())).toString()).toString();
                }
                throw $this.redirectUnauthenticated(url);
            }
            throw $this.authError("Authentication is required to access this resource.");
        }
    }

    public static Nothing$ redirectUnauthenticated(Auth $this, String originalUrl) {
        return pro.savant.circumflex.web.package$.MODULE$.sendRedirect(new StringBuilder().append((Object)$this.secureOrigin()).append((Object)"/auth/sso-check?returnTo=").append((Object)pro.savant.circumflex.web.package$.MODULE$.encodeURIComponent(originalUrl)).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public static String mkToken(Auth $this, Principal principal2, String nonce) {
        return new StringBuilder().append((Object)principal2.uniqueId()).append((Object)":").append((Object)nonce).append((Object)":").append((Object)pro.savant.circumflex.core.package$.MODULE$.sha256(new StringBuilder().append((Object)principal2.uniqueId()).append((Object)":").append((Object)nonce).append((Object)":").append((Object)principal2.secret()).toString())).toString();
    }

    public static Option parseToken(Auth $this, String token) {
        None$ none$;
        try {
            None$ none$2;
            Some x2;
            int i1 = token.indexOf(":");
            String id = token.substring(0, i1);
            int i2 = token.indexOf(":", i1 + 1);
            String nonce = token.substring(i1 + 1, i2);
            String secret = token.substring(i2 + 1);
            Option option = $this.lookup(id);
            if (option instanceof Some && (x2 = (Some)option) != null) {
                Some some;
                Principal u = (Principal)x2.x();
                String correctSecret = pro.savant.circumflex.core.package$.MODULE$.sha256(new StringBuilder().append((Object)u.uniqueId()).append((Object)":").append((Object)nonce).append((Object)":").append((Object)u.secret()).toString());
                String string = secret;
                String string2 = correctSecret;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    some = new Some((Object)u);
                } else {
                    package$.MODULE$.SECURITY_LOG().debug((Function0)new Serializable($this, token){
                        public static final long serialVersionUID = 0L;
                        private final String token$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Token secret mismatch: ").append((Object)this.token$1).toString();
                        }
                        {
                            this.token$1 = token$1;
                        }
                    });
                    some = None$.MODULE$;
                }
                none$2 = some;
            } else {
                package$.MODULE$.SECURITY_LOG().debug((Function0)new Serializable($this, id){
                    public static final long serialVersionUID = 0L;
                    private final String id$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Principal not found by id: ").append((Object)this.id$2).toString();
                    }
                    {
                        this.id$2 = id$2;
                    }
                });
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        catch (Exception exception) {
            package$.MODULE$.SECURITY_LOG().debug((Function0)new Serializable($this, token){
                public static final long serialVersionUID = 0L;
                private final String token$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Malformed token: ").append((Object)this.token$1).toString();
                }
                {
                    this.token$1 = token$1;
                }
            });
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void setRememberMeCookie(Auth $this) {
        pro.savant.circumflex.web.package$.MODULE$.responseOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final ListBuffer<HttpCookie> apply(HttpResponse resp) {
                String x$10 = "cx-auth";
                String x$11 = this.$outer.mkToken(this.$outer.principal(), pro.savant.circumflex.core.package$.MODULE$.randomString(4));
                String x$12 = "/";
                int x$13 = 31536000;
                boolean x$14 = this.$outer.isSecure();
                String x$15 = HttpCookie$.MODULE$.apply$default$3();
                String x$16 = HttpCookie$.MODULE$.apply$default$5();
                return resp.cookies().$plus$eq((Object)new HttpCookie(x$10, x$11, x$15, x$12, x$16, x$14, x$13));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static void dropRememberMeCookie(Auth $this) {
        String x$17 = "cx-auth";
        String x$18 = "";
        String x$19 = "/";
        int x$20 = 0;
        boolean x$21 = $this.isSecure();
        String x$22 = HttpCookie$.MODULE$.apply$default$3();
        String x$23 = HttpCookie$.MODULE$.apply$default$5();
        pro.savant.circumflex.web.package$.MODULE$.response().cookies().$plus$eq((Object)new HttpCookie(x$17, x$18, x$22, x$19, x$23, x$21, x$20));
    }

    public static void doRememberMeAuth(Auth $this) {
        pro.savant.circumflex.web.package$.MODULE$.requestOption().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<HttpCookie> apply(HttpRequest x$5) {
                return x$5.cookies().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(HttpCookie x$6) {
                        String string = x$6.name();
                        String string2 = "cx-auth";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                });
            }
        }).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final void apply(HttpCookie cookie) {
                Some x2;
                Option<U> option = this.$outer.parseToken(cookie.value());
                if (option instanceof Some && (x2 = (Some)option) != null) {
                    Principal u = (Principal)x2.x();
                    this.$outer.login(u, true);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.dropRememberMeCookie();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static String createSsoUrl(Auth $this, String url, Principal principal2, long timeout) {
        String nonce = pro.savant.circumflex.core.package$.MODULE$.randomString(8);
        long deadline = System.currentTimeMillis() + timeout;
        String ssoId = (String)$this.principalOption().filter((Function1)new Serializable($this, principal2){
            public static final long serialVersionUID = 0L;
            private final Principal principal$4;

            public final boolean apply(U x$7) {
                String string = x$7.uniqueId();
                String string2 = this.principal$4.uniqueId();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.principal$4 = principal$4;
            }
        }).flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final Option<String> apply(U u) {
                return this.$outer.ssoManager().ssoIdOption();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return pro.savant.circumflex.core.package$.MODULE$.randomString(8);
            }
        });
        String token = pro.savant.circumflex.core.package$.MODULE$.sha256(new StringBuilder().append((Object)$this.mkToken(principal2, nonce)).append((Object)":").append((Object)((Object)BoxesRunTime.boxToLong((long)deadline)).toString()).append((Object)":").append((Object)ssoId).toString());
        return pro.savant.circumflex.web.package$.MODULE$.appendParams(url, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sso"), (Object)"token"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sso_nonce"), (Object)nonce), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sso_deadline"), (Object)((Object)BoxesRunTime.boxToLong((long)deadline)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sso_id"), (Object)ssoId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sso_principal"), (Object)principal2.uniqueId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"sso_token"), (Object)token)}));
    }

    public static Principal createSsoUrl$default$2(Auth $this) {
        return $this.principal();
    }

    public static long createSsoUrl$default$3(Auth $this) {
        return 60000L;
    }

    public static void trySsoLogin(Auth $this) {
        BoxedUnit boxedUnit;
        Object object = param$.MODULE$.apply((Object)"sso");
        String string = "token";
        if (!(object != null ? !object.equals(string) : string != null)) {
            String id = (String)param$.MODULE$.apply((Object)"sso_principal");
            boxedUnit = $this.lookup(id).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Auth $outer;

                public final void apply(U principal2) {
                    String correctToken;
                    String token = (String)param$.MODULE$.apply((Object)"sso_token");
                    String nonce = (String)param$.MODULE$.apply((Object)"sso_nonce");
                    String ssoId = (String)param$.MODULE$.apply((Object)"sso_id");
                    long deadline = BoxesRunTime.unboxToLong((Object)parse$.MODULE$.longOption((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return (String)param$.MODULE$.apply((Object)"sso_deadline");
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                    String string = correctToken = pro.savant.circumflex.core.package$.MODULE$.sha256(new StringBuilder().append((Object)this.$outer.mkToken(principal2, nonce)).append((Object)":").append((Object)((Object)BoxesRunTime.boxToLong((long)deadline)).toString()).append((Object)":").append((Object)ssoId).toString());
                    String string2 = token;
                    if (!(string != null ? !string.equals(string2) : string2 != null) && System.currentTimeMillis() <= deadline) {
                        this.$outer.principalOption().filter((Function1)new Serializable(this, principal2){
                            public static final long serialVersionUID = 0L;
                            private final Principal principal$1;

                            public final boolean apply(U x$8) {
                                String string = x$8.uniqueId();
                                String string2 = this.principal$1.uniqueId();
                                return string != null ? !string.equals(string2) : string2 != null;
                            }
                            {
                                this.principal$1 = principal$1;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Auth$.anonfun.trySsoLogin.1 $outer;

                            public final void apply(U x$9) {
                                this.$outer.pro$savant$circumflex$security$Auth$$anonfun$$$outer().logout();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.setSessionAuth(principal2, ssoId);
                        this.$outer.set(principal2);
                    }
                }

                public /* synthetic */ Auth pro$savant$circumflex$security$Auth$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (param$.MODULE$.contains((Object)"sso")) {
            String qs;
            String uri = new StringBuilder().append((Object)pro.savant.circumflex.web.package$.MODULE$.origin()).append((Object)pro.savant.circumflex.web.package$.MODULE$.request().originalUri()).toString();
            String string2 = qs = pro.savant.circumflex.web.package$.MODULE$.encodeURI(pro.savant.circumflex.web.package$.MODULE$.request().queryString().replaceAll("&?sso[^=]*=[^&]*", ""));
            String string3 = "";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                uri = new StringBuilder().append((Object)uri).append((Object)new StringBuilder().append((Object)"?").append((Object)qs).toString()).toString();
            }
            throw pro.savant.circumflex.web.package$.MODULE$.sendRedirect(uri, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
    }

    public static String getSsoJsResponse(Auth $this) {
        return (String)$this.principalOption().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Auth $outer;

            public final String apply(U u) {
                String pf = new StringBuilder().append((Object)this.$outer.secureOrigin()).append((Object)"/auth/sso-return?returnTo=").toString();
                return new StringBuilder().append((Object)"window.location.replace(\"").append((Object)pro.savant.circumflex.web.package$.MODULE$.escapeJs(pf)).append((Object)"\" + encodeURIComponent(window.location.href));").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    public static void $init$(Auth $this) {
        $this.pro$savant$circumflex$security$Auth$_setter_$KEY_$eq("cx.principal");
    }
}

