/*
 * Decompiled with CFR 0.152.
 */
package pro.savant.circumflex.maven;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public abstract class AbstractCircumflexMojo
extends AbstractMojo {
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetaDataSource;
    protected List pluginArtifacts;
    protected boolean skipUnresolved;

    protected List<URL> getApplicationClasspath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Object o : this.project.getRuntimeClasspathElements()) {
            urls.add(new File(o.toString()).toURI().toURL());
        }
        for (Object o : this.project.getTestClasspathElements()) {
            urls.add(new File(o.toString()).toURI().toURL());
        }
        ArtifactResolutionResult deps = this.artifactResolver.resolveTransitively(this.project.getDependencyArtifacts(), this.project.getArtifact(), this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetaDataSource, (ArtifactFilter)new ScopeArtifactFilter("compile"));
        for (Object o : deps.getArtifacts()) {
            urls.add(((Artifact)o).getFile().toURI().toURL());
        }
        return urls;
    }

    protected String getApplicationClasspathString() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (URL url : this.getApplicationClasspath()) {
            File f = new File(url.toURI());
            sb.append(f.getAbsolutePath());
            if (f.isDirectory()) {
                sb.append("/");
            }
            sb.append(File.pathSeparator);
        }
        return sb.toString();
    }

    protected ClassLoader buildApplicationClassLoader() throws Exception {
        List<URL> urls = this.getApplicationClasspath();
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    protected void prepareClassLoader() throws MojoExecutionException {
        try {
            List<URL> urls = this.getApplicationClasspath();
            ClassRealm r = (ClassRealm)((Object)((Object)this)).getClass().getClassLoader();
            for (URL url : urls) {
                r.addURL(url);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not prepare class loader.", e);
        }
    }

    protected Properties collectProps() {
        Properties result = new Properties();
        this.copyProps(this.project.getProperties(), result);
        this.copyProps(System.getProperties(), result);
        return result;
    }

    private void copyProps(Properties src, Properties dst) {
        for (Object key : src.keySet()) {
            String value = src.get(key).toString().trim();
            if (this.skipUnresolved && value.matches(".*\\$\\{.*\\}.*")) {
                this.getLog().warn((CharSequence)("Property with key " + key + " is unresolved. To include it, set 'skipUnresolved' to false."));
                continue;
            }
            dst.put(key, value);
        }
    }
}

