/*
 * Decompiled with CFR 0.152.
 */
package pro.savant.circumflex.maven;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import pro.savant.circumflex.core.Msg;
import pro.savant.circumflex.maven.AbstractCircumflexMojo;
import pro.savant.circumflex.orm.DDLUnit;
import pro.savant.circumflex.orm.DeploymentHelper;
import pro.savant.circumflex.orm.SchemaObject;
import scala.collection.JavaConversions;

public class GenerateSchemaMojo
extends AbstractCircumflexMojo {
    private List<String> packages;
    private boolean drop;
    private List<String> deployments;
    private String deploymentsSuffix;
    private boolean closeConnectionProvider = true;
    private DDLUnit ddl = new DDLUnit();

    public void execute() throws MojoExecutionException {
        try {
            this.prepareClassLoader();
            this.processSchema();
            this.processDeployments();
        }
        catch (Exception e) {
            throw new MojoExecutionException("DDL export failed.", e);
        }
        finally {
            if (this.closeConnectionProvider) {
                this.ddl.close();
            }
        }
    }

    private void processSchema() throws Exception {
        List<URL> urls = this.getApplicationClasspath();
        if (this.packages != null) {
            for (String pkg : this.packages) {
                this.ddl.addPackage(JavaConversions.asScalaIterable(urls), pkg);
            }
        }
        if (this.ddl.schemata().size() > 0) {
            if (this.drop) {
                this.ddl._drop();
            }
            this.ddl._create();
            for (Msg msg : this.ddl.msgsArray()) {
                if (msg.key().equals("orm.ddl.info")) {
                    this.getLog().info((CharSequence)msg.param("status").get().toString());
                } else if (msg.key().equals("orm.ddl.error")) {
                    this.getLog().error((CharSequence)msg.param("status").get().toString());
                }
                this.getLog().debug((CharSequence)msg.param("sql").get().toString());
            }
        } else {
            this.getLog().info((CharSequence)"No schema objects found to export.");
        }
    }

    private boolean isSchemaObjectType(Class c) {
        return SchemaObject.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers()) && !Modifier.isInterface(c.getModifiers());
    }

    private void processDeployments() {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        this.deployments.add("default.cxd.xml");
        for (String pkg : this.packages) {
            this.findDeployments(pkg.replaceAll("\\.", "/"));
        }
        this.findDeployments("");
        for (String d : this.deployments) {
            this.processDeployment(d);
        }
    }

    private void findDeployments(String relPath) {
        try {
            String path = this.project.getBuild().getOutputDirectory() + "/" + relPath;
            File dir = new File(FilenameUtils.separatorsToSystem((String)path));
            for (File f : dir.listFiles()) {
                String d;
                if (!f.getName().endsWith(this.deploymentsSuffix)) continue;
                String string = d = relPath.equals("") ? f.getName() : relPath + "/" + f.getName();
                if (this.deployments.contains(d)) continue;
                this.deployments.add(d);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Could not process deployments for package " + relPath + "."));
        }
    }

    private void processDeployment(String deployment) {
        String path = this.project.getBuild().getOutputDirectory() + "/" + deployment;
        File f = new File(FilenameUtils.separatorsToSystem((String)path));
        if (!f.isFile()) {
            this.getLog().warn((CharSequence)("Omitting non-existent deployment " + deployment + "."));
            return;
        }
        try {
            new DeploymentHelper(f).loadData();
            this.getLog().info((CharSequence)("Deployment " + deployment + " processed successfully."));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Could not process deployment " + deployment + "."), (Throwable)e);
        }
    }
}

