/*
 * Decompiled with CFR 0.152.
 */
package pro.savant.circumflex.maven;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import pro.savant.circumflex.core.Circumflex;
import pro.savant.circumflex.maven.AbstractCircumflexMojo;
import pro.savant.circumflex.scalaconsole.DefaultScalaConsoleRouter;
import pro.savant.circumflex.web.StandaloneServer;

public class ScalaConsoleMojo
extends AbstractCircumflexMojo {
    protected Integer port;
    File tempRoot;
    StandaloneServer server;
    Thread shutdownHook = new Thread("cx.scalaconsole.shutdownHook"){

        @Override
        public void run() {
            if (ScalaConsoleMojo.this.server != null) {
                ScalaConsoleMojo.this.server.stop();
            }
            if (ScalaConsoleMojo.this.tempRoot != null) {
                FileUtils.deleteQuietly((File)ScalaConsoleMojo.this.tempRoot);
            }
        }
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Circumflex.reinitWith((ClassLoader)this.buildApplicationClassLoader());
            Circumflex.update((Object)"application.classpath", (Object)this.getApplicationClasspathString());
            Circumflex.update((Object)"cx.router", DefaultScalaConsoleRouter.class);
            Circumflex.update((Object)"cx.port", (Object)this.port);
            if (this.tempRoot.isDirectory()) {
                throw new MojoExecutionException("Temp directory exists at " + this.tempRoot.getCanonicalPath() + ". Make sure temp directory does not exist.");
            }
            FileUtils.forceMkdir((File)this.tempRoot);
            this.extractJar(this.getScalaConsoleJar(), this.tempRoot);
            File webappRoot = new File(this.tempRoot, "scalaconsole-webapp");
            if (!webappRoot.isDirectory()) {
                throw new MojoExecutionException("scalaconsole-webapp directory not found.circumflex-scalaconsole JAR must be broken.");
            }
            Circumflex.update((Object)"cx.webappRoot", (Object)webappRoot.getCanonicalPath());
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.prepareClassLoader();
            this.server = new StandaloneServer();
            this.server.start();
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI("http://127.0.0.1:" + this.port + "/"));
            }
            this.server.server().join();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Could not start Circumflex Scala Console.", (Throwable)e);
        }
    }

    protected JarFile getScalaConsoleJar() throws Exception {
        URL jarUrl = null;
        for (Object o : this.pluginArtifacts) {
            Artifact artifact = (Artifact)o;
            File f = artifact.getFile();
            String name = f.getName();
            if (!name.startsWith("circumflex-scalaconsole-") || !name.endsWith(".jar") || !f.isFile()) continue;
            jarUrl = f.toURI().toURL();
            break;
        }
        if (jarUrl == null) {
            throw new MojoExecutionException("Could not locate circumflex-scalaconsole JAR in classpath.");
        }
        return new JarFile(jarUrl.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractJar(JarFile jar, File root) throws Exception {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            File file = new File(root, entry.getName());
            if (entry.isDirectory()) {
                FileUtils.forceMkdir((File)file);
                continue;
            }
            InputStream is = jar.getInputStream(entry);
            FileOutputStream os = new FileOutputStream(file);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                is.close();
                os.close();
            }
        }
    }
}

