/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseReporterFactory;
import java.util.EnumSet;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import pro.streem.metrics.datadog.DatadogReporter;
import pro.streem.metrics.datadog.DefaultMetricNameFormatterFactory;
import pro.streem.metrics.datadog.DynamicTagsCallbackFactory;
import pro.streem.metrics.datadog.MetricNameFormatterFactory;
import pro.streem.metrics.datadog.transport.AbstractTransportFactory;

@JsonTypeName(value="datadog")
public class DatadogReporterFactory
extends BaseReporterFactory {
    @JsonProperty
    private String host = null;
    @JsonProperty
    private List<String> tags = null;
    @Valid
    @JsonProperty
    private DynamicTagsCallbackFactory dynamicTagsCallback = null;
    @JsonProperty
    private String prefix = null;
    @Valid
    @NotNull
    @JsonProperty
    private EnumSet<DatadogReporter.Expansion> expansions = EnumSet.allOf(DatadogReporter.Expansion.class);
    @Valid
    @NotNull
    @JsonProperty
    private MetricNameFormatterFactory metricNameFormatter = new DefaultMetricNameFormatterFactory();
    @Valid
    @NotNull
    @JsonProperty
    private AbstractTransportFactory transport = null;

    public ScheduledReporter build(MetricRegistry registry) {
        return DatadogReporter.forRegistry((MetricRegistry)registry).withTransport(this.transport.build()).withHost(this.host).withTags(this.tags).withPrefix(this.prefix).withExpansions(this.expansions).withMetricNameFormatter(this.metricNameFormatter.build()).withDynamicTagCallback(this.dynamicTagsCallback != null ? this.dynamicTagsCallback.build() : null).filter(this.getFilter()).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).build();
    }
}

