/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import pbandk.InvalidProtocolBufferException;
import pbandk.internal.binary.kotlin.WireReader;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lpbandk/internal/binary/InputStreamWireReader;", "Lpbandk/internal/binary/kotlin/WireReader;", "input", "Ljava/io/InputStream;", "sizeLimit", "", "bufferSize", "(Ljava/io/InputStream;II)V", "buffer", "", "bufferSizeAfterLimit", "currentLimit", "pos", "totalBytesRetired", "isAtEnd", "", "read", "length", "readRawBytesSlowPath", "size", "ensureNoLeakedReferences", "readRawBytesSlowPathOneChunk", "readRawBytesSlowPathRemainingChunks", "", "sizeLeft", "recomputeBufferSizeAfterLimit", "", "refillBuffer", "n", "skipRawBytes", "skipRawBytesSlowPath", "tryRefillBuffer", "runtime"})
public final class InputStreamWireReader
implements WireReader {
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int pos;
    private int totalBytesRetired;
    private final int currentLimit;
    private final InputStream input;
    private final int sizeLimit;

    @Override
    @NotNull
    public byte[] read(int length) {
        byte[] byArray;
        int tempPos = this.pos;
        int n = length;
        if (1 <= n && this.bufferSize - tempPos >= n) {
            this.pos = tempPos + length;
            byte[] byArray2 = this.buffer;
            int n2 = tempPos + length;
            boolean bl = false;
            byArray = ArraysKt.copyOfRange((byte[])byArray2, (int)tempPos, (int)n2);
        } else {
            byArray = this.readRawBytesSlowPath(length, false);
        }
        return byArray;
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    @Override
    public void skipRawBytes(int length) {
        int n = length;
        if (0 <= n && this.bufferSize - this.pos >= n) {
            this.pos += length;
        } else {
            this.skipRawBytesSlowPath(length);
        }
    }

    private final byte[] readRawBytesSlowPath(int size, boolean ensureNoLeakedReferences) {
        byte[] result = this.readRawBytesSlowPathOneChunk(size);
        if (result != null) {
            return ensureNoLeakedReferences ? (byte[])result.clone() : result;
        }
        int originalBufferPos = this.pos;
        int bufferedBytes = this.bufferSize - this.pos;
        this.totalBytesRetired += this.bufferSize;
        this.pos = 0;
        this.bufferSize = 0;
        int sizeLeft = size - bufferedBytes;
        List<byte[]> chunks = this.readRawBytesSlowPathRemainingChunks(sizeLeft);
        byte[] bytes = new byte[size];
        ArraysKt.copyInto((byte[])this.buffer, (byte[])bytes, (int)0, (int)originalBufferPos, (int)(originalBufferPos + bufferedBytes));
        int tempPos = bufferedBytes;
        for (byte[] chunk : chunks) {
            ArraysKt.copyInto$default((byte[])chunk, (byte[])bytes, (int)tempPos, (int)0, (int)0, (int)12, null);
            tempPos += chunk.length;
        }
        return bytes;
    }

    private final byte[] readRawBytesSlowPathOneChunk(int size) {
        if (size == 0) {
            return new byte[0];
        }
        if (size < 0) {
            throw (Throwable)InvalidProtocolBufferException.Companion.negativeSize$runtime();
        }
        int currentMessageSize = this.totalBytesRetired + this.pos + size;
        if (currentMessageSize - this.sizeLimit > 0) {
            throw (Throwable)InvalidProtocolBufferException.Companion.sizeLimitExceeded$runtime();
        }
        if (currentMessageSize > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw (Throwable)InvalidProtocolBufferException.Companion.truncatedMessage$runtime();
        }
        int bufferedBytes = this.bufferSize - this.pos;
        int sizeLeft = size - bufferedBytes;
        if (sizeLeft < 8192 || sizeLeft <= this.input.available()) {
            int n;
            byte[] bytes = new byte[size];
            ArraysKt.copyInto((byte[])this.buffer, (byte[])bytes, (int)0, (int)this.pos, (int)(this.pos + bufferedBytes));
            this.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            for (int tempPos = bufferedBytes; tempPos < bytes.length; tempPos += n) {
                n = this.input.read(bytes, tempPos, size - tempPos);
                if (n == -1) {
                    throw (Throwable)InvalidProtocolBufferException.Companion.truncatedMessage$runtime();
                }
                this.totalBytesRetired += n;
            }
            return bytes;
        }
        return null;
    }

    private final List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) {
        byte[] chunk;
        List chunks = new ArrayList();
        for (int sizeLeft2 = sizeLeft; sizeLeft2 > 0; sizeLeft2 -= chunk.length) {
            int n;
            chunk = new byte[RangesKt.coerceAtMost((int)sizeLeft2, (int)8192)];
            for (int tempPos = 0; tempPos < chunk.length; tempPos += n) {
                n = this.input.read(chunk, tempPos, chunk.length - tempPos);
                if (n == -1) {
                    throw (Throwable)InvalidProtocolBufferException.Companion.truncatedMessage$runtime();
                }
                this.totalBytesRetired += n;
            }
            chunks.add(chunk);
        }
        return chunks;
    }

    private final void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    private final boolean tryRefillBuffer(int n) {
        int bytesRead;
        boolean bl = this.pos + n > this.bufferSize;
        boolean bl2 = false;
        int n2 = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "refillBuffer() called when " + n + " bytes were already available in buffer";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
            return false;
        }
        if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
            return false;
        }
        int tempPos = this.pos;
        if (tempPos > 0) {
            if (this.bufferSize > tempPos) {
                ArraysKt.copyInto((byte[])this.buffer, (byte[])this.buffer, (int)0, (int)tempPos, (int)this.bufferSize);
            }
            this.totalBytesRetired += tempPos;
            this.bufferSize -= tempPos;
            this.pos = 0;
        }
        n2 = (bytesRead = this.input.read(this.buffer, this.bufferSize, RangesKt.coerceAtMost((int)(this.buffer.length - this.bufferSize), (int)(this.sizeLimit - this.totalBytesRetired - this.bufferSize)))) == -1 || 1 <= (n2 = bytesRead) && this.buffer.length >= n2 ? 1 : 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n2 == 0) {
            boolean bl6 = false;
            String string = this.input.getClass() + "#read(ByteArray) returned invalid result: " + bytesRead + "\nThe InputStream implementation is buggy.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (bytesRead > 0) {
            this.bufferSize += bytesRead;
            this.recomputeBufferSizeAfterLimit();
            return this.bufferSize >= n ? true : this.tryRefillBuffer(n);
        }
        return false;
    }

    private final void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                throw (Throwable)InvalidProtocolBufferException.Companion.sizeLimitExceeded$runtime();
            }
            throw (Throwable)InvalidProtocolBufferException.Companion.truncatedMessage$runtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void skipRawBytesSlowPath(int size) {
        int totalSkipped;
        if (size < 0) {
            throw (Throwable)InvalidProtocolBufferException.Companion.negativeSize$runtime();
        }
        if (this.totalBytesRetired + this.pos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw (Throwable)InvalidProtocolBufferException.Companion.truncatedMessage$runtime();
        }
        this.totalBytesRetired += this.pos;
        this.bufferSize = 0;
        this.pos = 0;
        try {
            long skipped;
            for (totalSkipped = this.bufferSize - this.pos; totalSkipped < size; totalSkipped += (int)skipped) {
                int toSkip = size - totalSkipped;
                skipped = this.input.skip(toSkip);
                long l = skipped;
                boolean bl = 0L <= l && (long)toSkip >= l;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = this.input.getClass() + "#skip returned invalid result: " + skipped + "\nThe InputStream implementation is buggy.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (skipped != 0L) continue;
                break;
            }
        }
        finally {
            this.totalBytesRetired += totalSkipped;
            this.recomputeBufferSizeAfterLimit();
        }
        if (totalSkipped < size) {
            int tempPos = this.bufferSize - this.pos;
            this.pos = this.bufferSize;
            this.refillBuffer(1);
            while (size - tempPos > this.bufferSize) {
                tempPos += this.bufferSize;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
            }
            this.pos = size - tempPos;
        }
    }

    public InputStreamWireReader(@NotNull InputStream input, int sizeLimit, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.sizeLimit = sizeLimit;
        boolean bl = this.sizeLimit >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Size limit cannot be negative: " + this.sizeLimit;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.buffer = new byte[bufferSize];
        this.currentLimit = Integer.MAX_VALUE;
    }

    public /* synthetic */ InputStreamWireReader(InputStream inputStream, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = 8192;
        }
        this(inputStream, n, n2);
    }
}

