/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.ListWithSize;
import pbandk.Message;
import pbandk.MessageMap;
import pbandk.UnknownField;
import pbandk.internal.binary.AbstractSizerKt;
import pbandk.internal.binary.BinaryMessageEncoderKt;
import pbandk.internal.binary.NumberExtensionsKt;
import pbandk.internal.binary.Sizer;
import pbandk.internal.binary.Tag;
import pbandk.internal.binary.WireType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u00020\u0004\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u0005\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011J&\u0010\u0016\u001a\u00020\u00042\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00182\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aJ\u001d\u0010\u001b\u001a\u00020\u0004\"\b\b\u0000\u0010\f*\u00020\u001c2\u0006\u0010\u0005\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u001dJ.\u0010\u001e\u001a\u00020\u0004\"\u0004\b\u0000\u0010\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\f0 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u00040\"J\u001d\u0010#\u001a\u00020\u0004\"\b\b\u0000\u0010\f*\u00020\u001c2\u0006\u0010$\u001a\u0002H\f\u00a2\u0006\u0002\u0010\u001dJ*\u0010%\u001a\u00020\u0004\"\u0004\b\u0000\u0010\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\f0 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020.H\u0016J\u000e\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004J\u000e\u00101\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u00102\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0011\u00a8\u00063"}, d2={"Lpbandk/internal/binary/AbstractSizer;", "", "()V", "boolSize", "", "value", "", "bytesSize", "Lpbandk/ByteArr;", "doubleSize", "", "enumSize", "T", "Lpbandk/Message$Enum;", "(Lpbandk/Message$Enum;)I", "fixed32Size", "fixed64Size", "", "floatSize", "", "int32Size", "int64Size", "mapSize", "map", "", "entryCompanion", "Lpbandk/MessageMap$Entry$Companion;", "messageSize", "Lpbandk/Message;", "(Lpbandk/Message;)I", "packedRepeatedSize", "list", "", "sizeFn", "Lkotlin/Function1;", "rawMessageSize", "message", "repeatedSize", "valueType", "Lpbandk/FieldDescriptor$Type;", "packed", "sFixed32Size", "sFixed64Size", "sInt32Size", "sInt64Size", "stringSize", "", "tagSize", "fieldNum", "uInt32Size", "uInt64Size", "runtime"})
public abstract class AbstractSizer {
    public int stringSize(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int len = AbstractSizerKt.access$utf8Len(value);
        return this.uInt32Size(len) + len;
    }

    public final <T extends Message.Enum> int enumSize(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.int32Size(value.getValue());
    }

    public final <T extends Message> int messageSize(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.uInt32Size(value.getProtoSize()) + value.getProtoSize();
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends Message> int rawMessageSize(@NotNull T message) {
        int n;
        Intrinsics.checkNotNullParameter(message, (String)"message");
        int protoSize2 = 0;
        for (FieldDescriptor<Message, ?> fieldDescriptor : message.getDescriptor().getFields()) {
            KProperty1<? extends Message, ?> kProperty1 = fieldDescriptor.getValue$runtime();
            if (kProperty1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KProperty1<T, *>");
            }
            Object value = kProperty1.get(message);
            if (!BinaryMessageEncoderKt.shouldOutputValue(fieldDescriptor.getType$runtime(), value) || value == null) continue;
            FieldDescriptor.Type type = fieldDescriptor.getType$runtime();
            protoSize2 += type instanceof FieldDescriptor.Type.Repeated ? this.tagSize(fieldDescriptor.getNumber$runtime()) * (((FieldDescriptor.Type.Repeated)fieldDescriptor.getType$runtime()).getPacked() ? 1 : ((List)value).size()) : (type instanceof FieldDescriptor.Type.Map ? this.tagSize(fieldDescriptor.getNumber$runtime()) * ((Map)value).size() : this.tagSize(fieldDescriptor.getNumber$runtime()));
            protoSize2 += AbstractSizerKt.protoSize(fieldDescriptor.getType$runtime(), value);
        }
        Iterable iterable = message.getUnknownFields().values();
        int n2 = protoSize2;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : iterable) {
            void it;
            UnknownField unknownField = (UnknownField)element$iv;
            n = sum$iv;
            boolean bl = false;
            int n3 = it.getSize$runtime();
            sum$iv = n + n3;
        }
        n = sum$iv;
        protoSize2 = n2 + n;
        return protoSize2;
    }

    public final <T> int repeatedSize(@NotNull List<? extends T> list, @NotNull FieldDescriptor.Type valueType, boolean packed) {
        int n;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Function1 sizeFn2 = new Function1<T, Integer>(valueType){
            final /* synthetic */ FieldDescriptor.Type $valueType;

            public final int invoke(T it) {
                return it != null ? AbstractSizerKt.protoSize(this.$valueType, it) : 0;
            }
            {
                this.$valueType = type;
                super(1);
            }
        };
        if (packed) {
            n = this.packedRepeatedSize(list, sizeFn2);
        } else {
            Iterable $this$sumBy$iv = list;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                sum$iv += ((Number)sizeFn2.invoke(element$iv)).intValue();
            }
            n = sum$iv;
        }
        return n;
    }

    public final <T> int packedRepeatedSize(@NotNull List<? extends T> list, @NotNull Function1<? super T, Integer> sizeFn2) {
        int n;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(sizeFn2, (String)"sizeFn");
        if (list instanceof ListWithSize && ((ListWithSize)list).getProtoSize() != null) {
            n = ((ListWithSize)list).getProtoSize() + this.uInt32Size(((ListWithSize)list).getProtoSize());
        } else {
            Iterable $this$sumBy$iv = list;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                sum$iv += ((Number)sizeFn2.invoke(element$iv)).intValue();
            }
            int n2 = sum$iv;
            boolean bl = false;
            boolean bl2 = false;
            int it = n2;
            boolean bl3 = false;
            n = it + this.uInt32Size(it);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int mapSize(@NotNull Map<?, ?> map, @NotNull MessageMap.Entry.Companion<?, ?> entryCompanion) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(entryCompanion, (String)"entryCompanion");
        Iterable $this$sumBy$iv = map.entrySet();
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            boolean bl;
            int n;
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            int n2 = sum$iv;
            boolean bl2 = false;
            if (entry instanceof MessageMap.Entry) {
                n = ((MessageMap.Entry)entry).getProtoSize();
            } else {
                int n3;
                int n4;
                Object k = entry.getKey();
                bl = false;
                boolean bl3 = false;
                Object it = k;
                boolean bl4 = false;
                Object object = BinaryMessageEncoderKt.shouldOutputValue(entryCompanion.getKeyType$runtime(), it) ? k : null;
                if (object != null) {
                    k = object;
                    bl = false;
                    bl3 = false;
                    it = k;
                    boolean bl5 = false;
                    n4 = Sizer.INSTANCE.tagSize(1) + AbstractSizerKt.protoSize(entryCompanion.getKeyType$runtime(), it);
                } else {
                    n4 = 0;
                }
                int keySize = n4;
                Object v = entry.getValue();
                bl3 = false;
                boolean it2 = false;
                Object it3 = v;
                boolean bl6 = false;
                Object object2 = BinaryMessageEncoderKt.shouldOutputValue(entryCompanion.getValueType$runtime(), it3) ? v : null;
                if (object2 != null) {
                    v = object2;
                    bl3 = false;
                    it2 = false;
                    it3 = v;
                    boolean bl7 = false;
                    n3 = Sizer.INSTANCE.tagSize(2) + AbstractSizerKt.protoSize(entryCompanion.getValueType$runtime(), it3);
                } else {
                    n3 = 0;
                }
                int valueSize = n3;
                n = keySize + valueSize;
            }
            int n5 = n;
            boolean bl8 = false;
            bl = false;
            int size = n5;
            boolean bl9 = false;
            int n6 = Sizer.INSTANCE.uInt32Size(size) + size;
            sum$iv = n2 + n6;
        }
        return sum$iv;
    }

    public final int tagSize(int fieldNum) {
        return this.uInt32Size(Tag.constructor-impl(fieldNum, WireType.constructor-impl(0)));
    }

    public final int doubleSize(double value) {
        return 8;
    }

    public final int floatSize(float value) {
        return 4;
    }

    public final int int32Size(int value) {
        return value >= 0 ? this.uInt32Size(value) : 10;
    }

    public final int int64Size(long value) {
        return this.uInt64Size(value);
    }

    public final int uInt32Size(int value) {
        return (value & 0xFFFFFF80) == 0 ? 1 : ((value & 0xFFFFC000) == 0 ? 2 : ((value & 0xFFE00000) == 0 ? 3 : ((value & 0xF0000000) == 0 ? 4 : 5)));
    }

    public final int uInt64Size(long value) {
        long value2 = value;
        if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value2 < 0L) {
            return 10;
        }
        int n = 2;
        if ((value2 & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value2 >>>= 28;
        }
        if ((value2 & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value2 >>>= 14;
        }
        if ((value2 & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public final int sInt32Size(int value) {
        return this.uInt32Size(NumberExtensionsKt.getZigZagEncoded(value));
    }

    public final int sInt64Size(long value) {
        return this.uInt64Size(NumberExtensionsKt.getZigZagEncoded(value));
    }

    public final int fixed32Size(int value) {
        return 4;
    }

    public final int fixed64Size(long value) {
        return 8;
    }

    public final int sFixed32Size(int value) {
        return 4;
    }

    public final int sFixed64Size(long value) {
        return 8;
    }

    public final int boolSize(boolean value) {
        return 1;
    }

    public final int bytesSize(@NotNull ByteArr value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.uInt32Size(value.getArray().length) + value.getArray().length;
    }
}

