/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import pbandk.internal.binary.kotlin.WireWriter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lpbandk/internal/binary/OutputStreamWireWriter;", "Lpbandk/internal/binary/kotlin/WireWriter;", "stream", "Ljava/io/OutputStream;", "bufferSize", "", "(Ljava/io/OutputStream;I)V", "buffer", "", "limit", "position", "<set-?>", "totalBytesWritten", "getTotalBytesWritten", "()I", "doFlush", "", "flush", "write", "bytes", "offset", "length", "pbandk-runtime"})
public final class OutputStreamWireWriter
implements WireWriter {
    private int totalBytesWritten;
    private final byte[] buffer;
    private final int limit;
    private int position;
    private final OutputStream stream;

    @Override
    public int getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    @Override
    public void write(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (this.limit - this.position >= length) {
            ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)this.position, (int)offset, (int)(offset + length));
            this.position += length;
            this.totalBytesWritten = this.getTotalBytesWritten() + length;
            return;
        }
        int offset2 = offset;
        int length2 = length;
        int bytesWritten = this.limit - this.position;
        ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)this.position, (int)offset2, (int)(offset2 + bytesWritten));
        offset2 += bytesWritten;
        this.position = this.limit;
        this.totalBytesWritten = this.getTotalBytesWritten() + bytesWritten;
        this.doFlush();
        if ((length2 -= bytesWritten) <= this.limit) {
            ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)0, (int)offset2, (int)(offset2 + length2));
            this.position = length2;
        } else {
            this.stream.write(bytes, offset2, length2);
        }
        this.totalBytesWritten = this.getTotalBytesWritten() + length2;
    }

    public final void flush() {
        if (this.position > 0) {
            this.doFlush();
        }
    }

    private final void doFlush() {
        this.stream.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public OutputStreamWireWriter(@NotNull OutputStream stream, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.buffer = new byte[RangesKt.coerceAtLeast((int)bufferSize, (int)20)];
        this.limit = this.buffer.length;
    }

    public /* synthetic */ OutputStreamWireWriter(OutputStream outputStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        this(outputStream, n);
    }
}

