/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.json;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.InvalidProtocolBufferException;
import pbandk.Message;
import pbandk.MessageMap;
import pbandk.internal.Util;
import pbandk.internal.json.JsonMessageDecoder;
import pbandk.json.JsonConfig;
import pbandk.wkt.BoolValue;
import pbandk.wkt.BytesValue;
import pbandk.wkt.DoubleValue;
import pbandk.wkt.Duration;
import pbandk.wkt.FloatValue;
import pbandk.wkt.Int32Value;
import pbandk.wkt.Int64Value;
import pbandk.wkt.ListValue;
import pbandk.wkt.StringValue;
import pbandk.wkt.Struct;
import pbandk.wkt.Timestamp;
import pbandk.wkt.UInt32Value;
import pbandk.wkt.UInt64Value;
import pbandk.wkt.Value;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J8\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H\u001d0\u001fH\u0082\b\u00a2\u0006\u0002\u0010!J,\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$0#2\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&J\u001a\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\b2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*J\u001a\u0010+\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u0018\u0010.\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u000e\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u00101\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u0018\u00102\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\"\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010%\u001a\u00020-2\b\b\u0002\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lpbandk/internal/json/JsonValueDecoder;", "", "jsonConfig", "Lpbandk/json/JsonConfig;", "(Lpbandk/json/JsonConfig;)V", "readBool", "", "value", "Lkotlinx/serialization/json/JsonElement;", "isMapKey", "readBytes", "Lpbandk/ByteArr;", "readDouble", "", "readDynamicListValue", "Lpbandk/wkt/ListValue;", "readDynamicValue", "Lpbandk/wkt/Value;", "readEnum", "Lpbandk/Message$Enum;", "enumCompanion", "Lpbandk/Message$Enum$Companion;", "readFloat", "", "readInteger32", "", "readInteger64", "", "readIntegerInternal", "T", "body", "Lkotlin/Function1;", "", "(Lkotlinx/serialization/json/JsonElement;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readMap", "Lkotlin/sequences/Sequence;", "", "type", "Lpbandk/FieldDescriptor$Type$Map;", "readMessage", "Lpbandk/Message;", "messageCompanion", "Lpbandk/Message$Companion;", "readRepeated", "valueType", "Lpbandk/FieldDescriptor$Type;", "readString", "readStruct", "Lpbandk/wkt/Struct;", "readUnsignedInteger32", "readUnsignedInteger64", "readValue", "Companion", "pbandk-runtime"})
public final class JsonValueDecoder {
    private final JsonConfig jsonConfig;
    private static final float FLOAT_MIN_POSITIVE = 1.175494E-38f;
    private static final float FLOAT_MAX_POSITIVE = Float.MAX_VALUE;
    private static final float FLOAT_MIN_NEGATIVE = -3.402823E38f;
    private static final float FLOAT_MAX_NEGATIVE = -1.175494E-38f;
    private static final double DOUBLE_MIN_POSITIVE = 2.22507E-308;
    private static final double DOUBLE_MAX_POSITIVE = 1.79769E308;
    private static final double DOUBLE_MIN_NEGATIVE = -1.79769E308;
    private static final double DOUBLE_MAX_NEGATIVE = -2.22507E-308;
    private static final Regex NUMBER_TRAILING_ZEROES;
    private static final Regex NUMBER_SCIENTIFIC_NOTATION;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Object readValue(@NotNull JsonElement value, @NotNull FieldDescriptor.Type type, boolean isMapKey) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        FieldDescriptor.Type type2 = type;
        if (type2 instanceof FieldDescriptor.Type.Primitive.Double) {
            object = this.readDouble(value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Float) {
            object = Float.valueOf(this.readFloat(value));
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int64) {
            object = this.readInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt64) {
            object = this.readUnsignedInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int32) {
            object = this.readInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed64) {
            object = this.readUnsignedInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed32) {
            object = this.readUnsignedInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bool) {
            object = this.readBool(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.String) {
            object = this.readString(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bytes) {
            object = this.readBytes(value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt32) {
            object = this.readUnsignedInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed32) {
            object = this.readInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed64) {
            object = this.readInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt32) {
            object = this.readInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt64) {
            object = this.readInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Message) {
            Message.Companion companion = ((FieldDescriptor.Type.Message)type).getMessageCompanion$pbandk_runtime();
            object = Intrinsics.areEqual(companion, (Object)DoubleValue.Companion) ? Double.valueOf(this.readDouble(value)) : (Intrinsics.areEqual(companion, (Object)FloatValue.Companion) ? Float.valueOf(this.readFloat(value)) : (Intrinsics.areEqual(companion, (Object)Int64Value.Companion) ? Long.valueOf(this.readInteger64(value, isMapKey)) : (Intrinsics.areEqual(companion, (Object)UInt64Value.Companion) ? Long.valueOf(this.readUnsignedInteger64(value, isMapKey)) : (Intrinsics.areEqual(companion, (Object)Int32Value.Companion) ? Integer.valueOf(this.readInteger32(value, isMapKey)) : (Intrinsics.areEqual(companion, (Object)UInt32Value.Companion) ? Integer.valueOf(this.readUnsignedInteger32(value, isMapKey)) : (Intrinsics.areEqual(companion, (Object)BoolValue.Companion) ? Boolean.valueOf(this.readBool(value, isMapKey)) : (Intrinsics.areEqual(companion, (Object)StringValue.Companion) ? this.readString(value, isMapKey) : (Intrinsics.areEqual(companion, (Object)BytesValue.Companion) ? this.readBytes(value) : (Intrinsics.areEqual(companion, (Object)Timestamp.Companion) ? Util.INSTANCE.stringToTimestamp(this.readString(value, false)) : (Intrinsics.areEqual(companion, (Object)Duration.Companion) ? Util.INSTANCE.stringToDuration(this.readString(value, false)) : (Intrinsics.areEqual(companion, (Object)Struct.Companion) ? this.readStruct(value) : (Intrinsics.areEqual(companion, (Object)Value.Companion) ? this.readDynamicValue(value) : (Intrinsics.areEqual(companion, (Object)ListValue.Companion) ? this.readDynamicListValue(value) : this.readMessage(value, ((FieldDescriptor.Type.Message)type).getMessageCompanion$pbandk_runtime()))))))))))))));
        } else if (type2 instanceof FieldDescriptor.Type.Enum) {
            object = this.readEnum(value, ((FieldDescriptor.Type.Enum)type).getEnumCompanion$pbandk_runtime());
        } else if (type2 instanceof FieldDescriptor.Type.Repeated) {
            object = this.readRepeated(value, ((FieldDescriptor.Type.Repeated)type).getValueType$pbandk_runtime());
        } else if (type2 instanceof FieldDescriptor.Type.Map) {
            object = this.readMap(value, (FieldDescriptor.Type.Map)type);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static /* synthetic */ Object readValue$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, FieldDescriptor.Type type, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readValue(jsonElement, type, bl);
    }

    private final <T> T readIntegerInternal(JsonElement value, boolean isMapKey, Function1<? super String, ? extends T> body) {
        Object object;
        int $i$f$readIntegerInternal = 0;
        try {
            String content = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Object object2 = StringsKt.getOrNull((CharSequence)content, (int)0);
            Character c = object2;
            if (c != null && c.charValue() == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have preceding space");
            }
            Character c2 = object2;
            if (c2 != null && c2.charValue() == '+') {
                throw (Throwable)new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c3 = object2;
            if (c3 != null && c3.charValue() == '-') {
                Character c4 = StringsKt.getOrNull((CharSequence)content, (int)1);
                if (c4 != null && c4.charValue() == '0') {
                    throw (Throwable)new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c5 = object2;
                if (c5 != null && c5.charValue() == '0' && content.length() > 1) {
                    throw (Throwable)new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content) == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have trailing space");
            }
            try {
                object2 = body.invoke((Object)content);
            }
            catch (NumberFormatException e) {
                CharSequence charSequence = content;
                Regex regex = JsonValueDecoder.NUMBER_TRAILING_ZEROES;
                String string = "";
                boolean bl = false;
                String contentExpandedInteger = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)JsonValueDecoder.NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger, (int)0, (int)2, null);
                if (matchResult != null) {
                    charSequence = matchResult;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    CharSequence it = charSequence;
                    boolean bl4 = false;
                    String mantissaFraction = StringsKt.trimStart((String)((String)it.getGroupValues().get(1)), (char[])new char[]{'.'});
                    int mantissaDigits = mantissaFraction.length();
                    CharSequence charSequence2 = mantissaFraction;
                    boolean bl5 = false;
                    boolean isMantissaFractionZero = charSequence2.length() == 0 || UStringsKt.toULong((String)mantissaFraction) == 0L;
                    String string2 = (String)it.getGroupValues().get(2);
                    boolean bl6 = false;
                    long decade = Long.parseLong(string2);
                    if (isMantissaFractionZero || decade >= (long)mantissaDigits) {
                        string2 = contentExpandedInteger;
                        bl6 = false;
                        contentExpandedInteger = String.valueOf((long)Double.parseDouble(string2));
                    }
                }
                object2 = body.invoke((Object)contentExpandedInteger);
            }
            object = object2;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("field did not contain a number in JSON", e);
        }
        return (T)object;
    }

    public final int readInteger32(@NotNull JsonElement value, boolean isMapKey) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            int n2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            if (c2 != null && c2.charValue() == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have preceding space");
            }
            Character c3 = c;
            if (c3 != null && c3.charValue() == '+') {
                throw (Throwable)new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c4 = c;
            if (c4 != null && c4.charValue() == '-') {
                Character c5 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                if (c5 != null && c5.charValue() == '0') {
                    throw (Throwable)new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c6 = c;
                if (c6 != null && c6.charValue() == '0' && content$iv.length() > 1) {
                    throw (Throwable)new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                String string = it;
                boolean bl2 = false;
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException e$iv) {
                CharSequence charSequence = content$iv;
                Regex regex = JsonValueDecoder.NUMBER_TRAILING_ZEROES;
                String string = "";
                boolean bl = false;
                String contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)JsonValueDecoder.NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    charSequence = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    CharSequence it$iv = charSequence;
                    boolean bl5 = false;
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])new char[]{'.'});
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    CharSequence charSequence2 = mantissaFraction$iv;
                    boolean bl6 = false;
                    boolean isMantissaFractionZero$iv = charSequence2.length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    String string2 = (String)it$iv.getGroupValues().get(2);
                    boolean bl7 = false;
                    long decade$iv = Long.parseLong(string2);
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        string2 = contentExpandedInteger$iv;
                        bl7 = false;
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(string2));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl8 = false;
                String string3 = it;
                boolean bl9 = false;
                n2 = Integer.parseInt(string3);
            }
            n = n2;
        }
        catch (Exception e$iv) {
            throw (Throwable)new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return n;
    }

    public static /* synthetic */ int readInteger32$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readInteger32(jsonElement, bl);
    }

    public final long readInteger64(@NotNull JsonElement value, boolean isMapKey) {
        long l;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            long l2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            if (c2 != null && c2.charValue() == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have preceding space");
            }
            Character c3 = c;
            if (c3 != null && c3.charValue() == '+') {
                throw (Throwable)new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c4 = c;
            if (c4 != null && c4.charValue() == '-') {
                Character c5 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                if (c5 != null && c5.charValue() == '0') {
                    throw (Throwable)new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c6 = c;
                if (c6 != null && c6.charValue() == '0' && content$iv.length() > 1) {
                    throw (Throwable)new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                String string = it;
                boolean bl2 = false;
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException e$iv) {
                CharSequence charSequence = content$iv;
                Regex regex = JsonValueDecoder.NUMBER_TRAILING_ZEROES;
                String string = "";
                boolean bl = false;
                String contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)JsonValueDecoder.NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    charSequence = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    CharSequence it$iv = charSequence;
                    boolean bl5 = false;
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])new char[]{'.'});
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    CharSequence charSequence2 = mantissaFraction$iv;
                    boolean bl6 = false;
                    boolean isMantissaFractionZero$iv = charSequence2.length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    String string2 = (String)it$iv.getGroupValues().get(2);
                    boolean bl7 = false;
                    long decade$iv = Long.parseLong(string2);
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        string2 = contentExpandedInteger$iv;
                        bl7 = false;
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(string2));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl8 = false;
                String string3 = it;
                boolean bl9 = false;
                l2 = Long.parseLong(string3);
            }
            l = l2;
        }
        catch (Exception e$iv) {
            throw (Throwable)new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return l;
    }

    public static /* synthetic */ long readInteger64$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readInteger64(jsonElement, bl);
    }

    public final int readUnsignedInteger32(@NotNull JsonElement value, boolean isMapKey) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            int n2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            if (c2 != null && c2.charValue() == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have preceding space");
            }
            Character c3 = c;
            if (c3 != null && c3.charValue() == '+') {
                throw (Throwable)new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c4 = c;
            if (c4 != null && c4.charValue() == '-') {
                Character c5 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                if (c5 != null && c5.charValue() == '0') {
                    throw (Throwable)new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c6 = c;
                if (c6 != null && c6.charValue() == '0' && content$iv.length() > 1) {
                    throw (Throwable)new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                int n3 = UStringsKt.toUInt((String)it);
                boolean bl2 = false;
                n2 = n3;
            }
            catch (NumberFormatException e$iv) {
                CharSequence charSequence = content$iv;
                Regex regex = JsonValueDecoder.NUMBER_TRAILING_ZEROES;
                String string = "";
                boolean bl = false;
                String contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)JsonValueDecoder.NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    charSequence = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    CharSequence it$iv = charSequence;
                    boolean bl5 = false;
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])new char[]{'.'});
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    CharSequence charSequence2 = mantissaFraction$iv;
                    boolean bl6 = false;
                    boolean isMantissaFractionZero$iv = charSequence2.length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    String string2 = (String)it$iv.getGroupValues().get(2);
                    boolean bl7 = false;
                    long decade$iv = Long.parseLong(string2);
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        string2 = contentExpandedInteger$iv;
                        bl7 = false;
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(string2));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl8 = false;
                int n4 = UStringsKt.toUInt((String)it);
                boolean bl9 = false;
                n2 = n4;
            }
            n = n2;
        }
        catch (Exception e$iv) {
            throw (Throwable)new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return n;
    }

    public static /* synthetic */ int readUnsignedInteger32$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readUnsignedInteger32(jsonElement, bl);
    }

    public final long readUnsignedInteger64(@NotNull JsonElement value, boolean isMapKey) {
        long l;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            long l2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            if (c2 != null && c2.charValue() == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have preceding space");
            }
            Character c3 = c;
            if (c3 != null && c3.charValue() == '+') {
                throw (Throwable)new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c4 = c;
            if (c4 != null && c4.charValue() == '-') {
                Character c5 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                if (c5 != null && c5.charValue() == '0') {
                    throw (Throwable)new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c6 = c;
                if (c6 != null && c6.charValue() == '0' && content$iv.length() > 1) {
                    throw (Throwable)new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw (Throwable)new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                long l3 = UStringsKt.toULong((String)it);
                boolean bl2 = false;
                l2 = l3;
            }
            catch (NumberFormatException e$iv) {
                CharSequence charSequence = content$iv;
                Regex regex = JsonValueDecoder.NUMBER_TRAILING_ZEROES;
                String string = "";
                boolean bl = false;
                String contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)JsonValueDecoder.NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    charSequence = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    CharSequence it$iv = charSequence;
                    boolean bl5 = false;
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])new char[]{'.'});
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    CharSequence charSequence2 = mantissaFraction$iv;
                    boolean bl6 = false;
                    boolean isMantissaFractionZero$iv = charSequence2.length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    String string2 = (String)it$iv.getGroupValues().get(2);
                    boolean bl7 = false;
                    long decade$iv = Long.parseLong(string2);
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        string2 = contentExpandedInteger$iv;
                        bl7 = false;
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(string2));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl8 = false;
                long l4 = UStringsKt.toULong((String)it);
                boolean bl9 = false;
                l2 = l4;
            }
            l = l2;
        }
        catch (Exception e$iv) {
            throw (Throwable)new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return l;
    }

    public static /* synthetic */ long readUnsignedInteger64$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readUnsignedInteger64(jsonElement, bl);
    }

    public final boolean readBool(@NotNull JsonElement value, boolean isMapKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!isMapKey && value instanceof JsonPrimitive && ((JsonPrimitive)value).isString()) {
            throw (Throwable)new InvalidProtocolBufferException("bool field must not be quoted in JSON");
        }
        switch (JsonElementKt.getJsonPrimitive((JsonElement)value).getContent()) {
            case "true": {
                bl = true;
                break;
            }
            case "false": {
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new InvalidProtocolBufferException("bool field did not contain a boolean value in JSON");
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean readBool$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readBool(jsonElement, bl);
    }

    @Nullable
    public final Message.Enum readEnum(@NotNull JsonElement value, @NotNull Message.Enum.Companion<?> enumCompanion) {
        Message.Enum enum_;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(enumCompanion, (String)"enumCompanion");
        try {
            JsonPrimitive p = JsonElementKt.getJsonPrimitive((JsonElement)value);
            Integer n = JsonElementKt.getIntOrNull((JsonPrimitive)p);
            if (n != null) {
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                return enumCompanion.fromValue(it);
            }
            boolean bl = p.isString();
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "Non-numeric enum values must be quoted";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            enum_ = enumCompanion.fromName(p.getContent());
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException) || !this.jsonConfig.getIgnoreUnknownFieldsInInput()) {
                throw (Throwable)new InvalidProtocolBufferException("enum field did not contain a number or valid enum value", e);
            }
            enum_ = null;
        }
        return enum_;
    }

    /*
     * Unable to fully structure code
     */
    public final float readFloat(@NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            if (value instanceof JsonPrimitive && ((JsonPrimitive)value).isString()) {
                var2_2 = ((JsonPrimitive)value).getContent();
                tmp = -1;
                switch (var2_2.hashCode()) {
                    case 506745205: {
                        if (!var2_2.equals("-Infinity")) break;
                        tmp = 1;
                        break;
                    }
                    case 237817416: {
                        if (!var2_2.equals("Infinity")) break;
                        tmp = 2;
                        break;
                    }
                    case 78043: {
                        if (!var2_2.equals("NaN")) break;
                        tmp = 3;
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        return Infinityf;
                    }
                    case 1: {
                        return -Infinityf;
                    }
                    case 3: {
                        return NaNf;
                    }
                }
            }
            floatValue = JsonElementKt.getFloat((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
            var3_5 = floatValue;
            var4_6 = false;
            var5_9 = var3_5;
            var6_10 = false;
            if (Float.isInfinite(var5_9)) ** GOTO lbl-1000
            var5_9 = var3_5;
            var6_10 = false;
            if (!Float.isNaN(var5_9)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) {
                throw (Throwable)new NumberFormatException("value out of bounds");
            }
            if ((double)floatValue > 0.0) {
                var5_9 = 1.175494E-38f;
                var6_11 = 3.4028235E38f;
                var4_7 = floatValue;
                if (!(var4_7 >= var5_9) || !(var4_7 <= var6_11)) {
                    throw (Throwable)new NumberFormatException("value out of bounds");
                }
            }
            if ((double)floatValue < 0.0) {
                var5_9 = -3.402823E38f;
                var6_12 = -1.175494E-38f;
                var4_8 = floatValue;
                if (!(var4_8 >= var5_9) || !(var4_8 <= var6_12)) {
                    throw (Throwable)new NumberFormatException("value out of bounds");
                }
            }
            return floatValue;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("float field did not contain a float value in JSON", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final double readDouble(@NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            if (value instanceof JsonPrimitive && ((JsonPrimitive)value).isString()) {
                var2_2 = ((JsonPrimitive)value).getContent();
                tmp = -1;
                switch (var2_2.hashCode()) {
                    case 506745205: {
                        if (!var2_2.equals("-Infinity")) break;
                        tmp = 1;
                        break;
                    }
                    case 237817416: {
                        if (!var2_2.equals("Infinity")) break;
                        tmp = 2;
                        break;
                    }
                    case 78043: {
                        if (!var2_2.equals("NaN")) break;
                        tmp = 3;
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        return Infinity;
                    }
                    case 1: {
                        return -Infinity;
                    }
                    case 3: {
                        return NaN;
                    }
                }
            }
            doubleValue = JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
            var4_5 = doubleValue;
            var6_6 = false;
            var7_9 = var4_5;
            var9_10 = false;
            if (Double.isInfinite(var7_9)) ** GOTO lbl-1000
            var7_9 = var4_5;
            var9_10 = false;
            if (!Double.isNaN(var7_9)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) {
                throw (Throwable)new NumberFormatException("value out of bounds");
            }
            if (doubleValue > 0.0) {
                var8_11 = 2.22507E-308;
                var10_12 = 1.79769E308;
                var6_7 = doubleValue;
                if (!(var6_7 >= var8_11) || !(var6_7 <= var10_12)) {
                    throw (Throwable)new NumberFormatException("value out of bounds");
                }
            }
            if (doubleValue < 0.0) {
                var8_11 = -1.79769E308;
                var10_12 = -2.22507E-308;
                var6_8 = doubleValue;
                if (!(var6_8 >= var8_11) || !(var6_8 <= var10_12)) {
                    throw (Throwable)new NumberFormatException("value out of bounds");
                }
            }
            return doubleValue;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("double field did not contain a double value in JSON", e);
        }
    }

    @NotNull
    public final String readString(@NotNull JsonElement value, boolean isMapKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            boolean bl = value instanceof JsonPrimitive && ((JsonPrimitive)value).isString();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "string field wasn't quoted";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            string = ((JsonPrimitive)value).getContent();
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("string field did not contain a string value in JSON", e);
        }
        return string;
    }

    public static /* synthetic */ String readString$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readString(jsonElement, bl);
    }

    @NotNull
    public final ByteArr readBytes(@NotNull JsonElement value) {
        ByteArr byteArr;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            byteArr = new ByteArr(Util.INSTANCE.base64ToBytes(JsonElementKt.getJsonPrimitive((JsonElement)value).getContent()));
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("bytes field did not contain a base64-encoded string value in JSON", e);
        }
        return byteArr;
    }

    @NotNull
    public final Message readMessage(@NotNull JsonElement value, @NotNull Message.Companion<?> messageCompanion) {
        Object obj;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(messageCompanion, (String)"messageCompanion");
        try {
            obj = messageCompanion.decodeWith(new JsonMessageDecoder(value, this.jsonConfig));
        }
        catch (InvalidProtocolBufferException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("message field did not contain a valid message", e);
        }
        return obj;
    }

    @NotNull
    public final Sequence<?> readRepeated(@NotNull JsonElement value, @NotNull FieldDescriptor.Type valueType) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        try {
            sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)JsonElementKt.getJsonArray((JsonElement)value))), (Function1)((Function1)new Function1<JsonElement, Object>(this, valueType){
                final /* synthetic */ JsonValueDecoder this$0;
                final /* synthetic */ FieldDescriptor.Type $valueType;

                @Nullable
                public final Object invoke(@NotNull JsonElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return JsonValueDecoder.readValue$default(this.this$0, it, this.$valueType, false, 4, null);
                }
                {
                    this.this$0 = jsonValueDecoder;
                    this.$valueType = type;
                    super(1);
                }
            }));
        }
        catch (InvalidProtocolBufferException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("repeated field did not contain a valid list", e);
        }
        return sequence;
    }

    @NotNull
    public final Sequence<Map.Entry<?, ?>> readMap(@NotNull JsonElement value, @NotNull FieldDescriptor.Type.Map<?, ?> type) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            sequence = SequencesKt.mapNotNull((Sequence)MapsKt.asSequence((Map)((Map)JsonElementKt.getJsonObject((JsonElement)value))), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends JsonElement>, MessageMap.Entry<Object, Object>>(this, type){
                final /* synthetic */ JsonValueDecoder this$0;
                final /* synthetic */ FieldDescriptor.Type.Map $type;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final MessageMap.Entry<Object, Object> invoke(@NotNull Map.Entry<String, ? extends JsonElement> $dstr$k$v) {
                    MessageMap.Entry<K, V> entry;
                    void k;
                    Intrinsics.checkNotNullParameter($dstr$k$v, (String)"<name for destructuring parameter 0>");
                    Map.Entry<String, ? extends JsonElement> entry2 = $dstr$k$v;
                    boolean bl = false;
                    String string = entry2.getKey();
                    entry2 = $dstr$k$v;
                    bl = false;
                    JsonElement v = entry2.getValue();
                    Object entryKey = this.this$0.readValue((JsonElement)JsonElementKt.JsonPrimitive((String)k), this.$type.getEntryCompanion$pbandk_runtime().getKeyType$pbandk_runtime(), true);
                    Object object = JsonValueDecoder.readValue$default(this.this$0, v, this.$type.getEntryCompanion$pbandk_runtime().getValueType$pbandk_runtime(), false, 4, null);
                    if (object != null) {
                        Object object2 = object;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Object entryValue = object2;
                        boolean bl4 = false;
                        MessageMap.Entry.Companion<K, V> companion = this.$type.getEntryCompanion$pbandk_runtime();
                        if (companion == null) {
                            throw new NullPointerException("null cannot be cast to non-null type pbandk.MessageMap.Entry.Companion<kotlin.Any?, kotlin.Any?>");
                        }
                        entry = new MessageMap.Entry<K, V>(entryKey, entryValue, companion, null, 8, null);
                    } else {
                        entry = null;
                    }
                    return entry;
                }
                {
                    this.this$0 = jsonValueDecoder;
                    this.$type = map;
                    super(1);
                }
            }));
        }
        catch (InvalidProtocolBufferException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("map field did not contain a valid object", e);
        }
        return sequence;
    }

    @NotNull
    public final Struct readStruct(@NotNull JsonElement value) {
        Struct struct;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            FieldDescriptor.Type type = ((FieldDescriptor)CollectionsKt.first((Iterable)Struct.Companion.getDescriptor().getFields())).getType$pbandk_runtime();
            if (type == null) {
                throw new NullPointerException("null cannot be cast to non-null type pbandk.FieldDescriptor.Type.Map<*, *>");
            }
            Sequence<Map.Entry<?, ?>> fields = this.readMap(value, (FieldDescriptor.Type.Map)type);
            Set set = SequencesKt.toSet(fields);
            if (set == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Set<pbandk.MessageMap.Entry<kotlin.String, pbandk.wkt.Value?>>");
            }
            struct = new Struct((Map)((Object)new MessageMap(set)), null, 2, null);
        }
        catch (InvalidProtocolBufferException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("struct field did not contain a valid object", e);
        }
        return struct;
    }

    @NotNull
    public final Value readDynamicValue(@NotNull JsonElement value) {
        Value value2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElement jsonElement = value;
        if (jsonElement instanceof JsonNull) {
            value2 = new Value(new Value.Kind.NullValue(null, 1, null), null, 2, null);
        } else if (jsonElement instanceof JsonPrimitive) {
            JsonValueDecoder jsonValueDecoder;
            Object it2;
            Object object;
            JsonValueDecoder jsonValueDecoder2;
            Object $this$runCatching2;
            Object object2;
            JsonValueDecoder jsonValueDecoder3 = this;
            boolean bl = false;
            try {
                object2 = Result.Companion;
                $this$runCatching2 = jsonValueDecoder3;
                boolean bl2 = false;
                $this$runCatching2 = new Value(new Value.Kind.StringValue(JsonValueDecoder.readString$default((JsonValueDecoder)$this$runCatching2, value, false, 2, null)), null, 2, null);
                bl2 = false;
                object2 = Result.constructor-impl((Object)$this$runCatching2);
            }
            catch (Throwable $this$runCatching2) {
                Result.Companion bl2 = Result.Companion;
                boolean bl3 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
            }
            jsonValueDecoder3 = object2;
            bl = false;
            object2 = Result.exceptionOrNull-impl((Object)jsonValueDecoder3);
            if (object2 == null) {
                jsonValueDecoder2 = jsonValueDecoder3;
            } else {
                Object object3;
                $this$runCatching2 = jsonValueDecoder3;
                boolean bl2 = false;
                try {
                    object3 = Result.Companion;
                    object = $this$runCatching2;
                    boolean bl4 = false;
                    it2 = object2;
                    boolean bl5 = false;
                    object = new Value(new Value.Kind.NumberValue(this.readDouble(value)), null, 2, null);
                    bl4 = false;
                    object3 = Result.constructor-impl((Object)object);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean it2 = false;
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                jsonValueDecoder2 = object3;
            }
            jsonValueDecoder3 = jsonValueDecoder2;
            bl = false;
            object2 = Result.exceptionOrNull-impl((Object)jsonValueDecoder3);
            if (object2 == null) {
                jsonValueDecoder = jsonValueDecoder3;
            } else {
                Object object4;
                $this$runCatching2 = jsonValueDecoder3;
                boolean bl2 = false;
                try {
                    object4 = Result.Companion;
                    object = $this$runCatching2;
                    boolean bl6 = false;
                    it2 = object2;
                    boolean bl7 = false;
                    object = new Value(new Value.Kind.BoolValue(JsonValueDecoder.readBool$default(this, value, false, 2, null)), null, 2, null);
                    bl6 = false;
                    object4 = Result.constructor-impl((Object)object);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl8 = false;
                    object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                jsonValueDecoder = object4;
            }
            jsonValueDecoder3 = jsonValueDecoder;
            bl = false;
            boolean bl9 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)jsonValueDecoder3);
            if (throwable != null) {
                Throwable it3 = throwable;
                boolean bl10 = false;
                throw (Throwable)new InvalidProtocolBufferException("dynamically typed value did not contain a valid primitive object");
            }
            value2 = (Value)((Object)jsonValueDecoder3);
        } else if (jsonElement instanceof JsonArray) {
            Object object = JsonValueDecoder.readValue$default(this, value, new FieldDescriptor.Type.Message(ListValue.Companion), false, 4, null);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type pbandk.wkt.ListValue");
            }
            value2 = new Value(new Value.Kind.ListValue((ListValue)object), null, 2, null);
        } else if (jsonElement instanceof JsonObject) {
            Object object = JsonValueDecoder.readValue$default(this, value, new FieldDescriptor.Type.Message(Struct.Companion), false, 4, null);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type pbandk.wkt.Struct");
            }
            value2 = new Value(new Value.Kind.StructValue((Struct)object), null, 2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return value2;
    }

    @NotNull
    public final ListValue readDynamicListValue(@NotNull JsonElement value) {
        ListValue listValue;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            Object object = JsonValueDecoder.readValue$default(this, value, ((FieldDescriptor)CollectionsKt.first((Iterable)ListValue.Companion.getDescriptor().getFields())).getType$pbandk_runtime(), false, 4, null);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<pbandk.wkt.Value>");
            }
            Sequence values2 = (Sequence)object;
            listValue = new ListValue(SequencesKt.toList((Sequence)values2), null, 2, null);
        }
        catch (InvalidProtocolBufferException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new InvalidProtocolBufferException("dynamically typed list value did not contain a valid object", e);
        }
        return listValue;
    }

    public JsonValueDecoder(@NotNull JsonConfig jsonConfig) {
        Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
        this.jsonConfig = jsonConfig;
    }

    static {
        Companion = new Companion(null);
        String string = "\\.0+$";
        boolean bl = false;
        NUMBER_TRAILING_ZEROES = new Regex(string);
        string = "-?(?:\\d+)(\\.\\d+?)?0*[eE](\\d+)$";
        bl = false;
        NUMBER_SCIENTIFIC_NOTATION = new Regex(string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpbandk/internal/json/JsonValueDecoder$Companion;", "", "()V", "DOUBLE_MAX_NEGATIVE", "", "DOUBLE_MAX_POSITIVE", "DOUBLE_MIN_NEGATIVE", "DOUBLE_MIN_POSITIVE", "FLOAT_MAX_NEGATIVE", "", "FLOAT_MAX_POSITIVE", "FLOAT_MIN_NEGATIVE", "FLOAT_MIN_POSITIVE", "NUMBER_SCIENTIFIC_NOTATION", "Lkotlin/text/Regex;", "NUMBER_TRAILING_ZEROES", "pbandk-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

