/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pbandk.internal.Base64Kt;
import pbandk.internal.TimeUtilKt;
import pbandk.wkt.Duration;
import pbandk.wkt.Timestamp;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"Lpbandk/internal/AbstractUtil;", "", "()V", "base64ToBytes", "", "str", "", "bytesToBase64", "bytes", "durationToString", "dur", "Lpbandk/wkt/Duration;", "stringToDuration", "stringToTimestamp", "Lpbandk/wkt/Timestamp;", "timestampToString", "ts", "pbandk-runtime"})
public abstract class AbstractUtil {
    @NotNull
    public byte[] base64ToBytes(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        byte[] byArray = Base64Kt.decodeBase64ToArray(str);
        if (byArray == null) {
            throw new RuntimeException(Intrinsics.stringPlus((String)"Unable to base64-decode string: ", (Object)str));
        }
        return byArray;
    }

    @NotNull
    public String bytesToBase64(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return StringsKt.decodeToString((byte[])Base64Kt.encodeBase64$default(bytes, null, 1, null));
    }

    @NotNull
    public final String timestampToString(@NotNull Timestamp ts) {
        Intrinsics.checkNotNullParameter((Object)ts, (String)"ts");
        return TimeUtilKt.formatTime(ts.getSeconds(), ts.getNanos());
    }

    @NotNull
    public final Timestamp stringToTimestamp(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return TimeUtilKt.parseTime(str);
    }

    @NotNull
    public final String durationToString(@NotNull Duration dur) {
        Intrinsics.checkNotNullParameter((Object)dur, (String)"dur");
        return TimeUtilKt.formatDuration(dur);
    }

    @NotNull
    public final Duration stringToDuration(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return TimeUtilKt.parseDuration(str);
    }
}

