/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import pbandk.InvalidProtocolBufferException;
import pbandk.internal.binary.kotlin.WireReader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lpbandk/internal/binary/InputStreamWireReader;", "Lpbandk/internal/binary/kotlin/WireReader;", "input", "Ljava/io/InputStream;", "sizeLimit", "", "bufferSize", "(Ljava/io/InputStream;II)V", "buffer", "", "bufferSizeAfterLimit", "currentLimit", "pos", "totalBytesRetired", "isAtEnd", "", "read", "length", "readRawBytesSlowPath", "size", "ensureNoLeakedReferences", "readRawBytesSlowPathOneChunk", "readRawBytesSlowPathRemainingChunks", "", "sizeLeft", "recomputeBufferSizeAfterLimit", "", "refillBuffer", "n", "skipRawBytes", "skipRawBytesSlowPath", "tryRefillBuffer", "pbandk-runtime"})
public final class InputStreamWireReader
implements WireReader {
    @NotNull
    private final InputStream input;
    private final int sizeLimit;
    @NotNull
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int pos;
    private int totalBytesRetired;
    private final int currentLimit;

    public InputStreamWireReader(@NotNull InputStream input, int sizeLimit, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.sizeLimit = sizeLimit;
        boolean bl = this.sizeLimit >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Size limit cannot be negative: ", (Object)this.sizeLimit);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.buffer = new byte[bufferSize];
        this.currentLimit = Integer.MAX_VALUE;
    }

    public /* synthetic */ InputStreamWireReader(InputStream inputStream, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n3 & 4) != 0) {
            n2 = 8192;
        }
        this(inputStream, n, n2);
    }

    @Override
    @NotNull
    public byte[] read(int length) {
        byte[] byArray;
        int tempPos = this.pos;
        boolean bl = 1 <= length ? length <= this.bufferSize - tempPos : false;
        if (bl) {
            this.pos = tempPos + length;
            byte[] byArray2 = this.buffer;
            int n = tempPos + length;
            boolean bl2 = false;
            byArray = ArraysKt.copyOfRange((byte[])byArray2, (int)tempPos, (int)n);
        } else {
            byArray = this.readRawBytesSlowPath(length, false);
        }
        return byArray;
    }

    @Override
    public boolean isAtEnd() {
        return this.pos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    @Override
    public void skipRawBytes(int length) {
        boolean bl = 0 <= length ? length <= this.bufferSize - this.pos : false;
        if (bl) {
            InputStreamWireReader inputStreamWireReader = this;
            inputStreamWireReader.pos += length;
        } else {
            this.skipRawBytesSlowPath(length);
        }
    }

    private final byte[] readRawBytesSlowPath(int size, boolean ensureNoLeakedReferences) {
        byte[] result = this.readRawBytesSlowPathOneChunk(size);
        if (result != null) {
            return ensureNoLeakedReferences ? (byte[])result.clone() : result;
        }
        int originalBufferPos = this.pos;
        int bufferedBytes = this.bufferSize - this.pos;
        InputStreamWireReader inputStreamWireReader = this;
        inputStreamWireReader.totalBytesRetired += this.bufferSize;
        this.pos = 0;
        this.bufferSize = 0;
        int sizeLeft = size - bufferedBytes;
        List<byte[]> chunks = this.readRawBytesSlowPathRemainingChunks(sizeLeft);
        byte[] bytes = new byte[size];
        ArraysKt.copyInto((byte[])this.buffer, (byte[])bytes, (int)0, (int)originalBufferPos, (int)(originalBufferPos + bufferedBytes));
        int tempPos = bufferedBytes;
        for (byte[] chunk : chunks) {
            ArraysKt.copyInto$default((byte[])chunk, (byte[])bytes, (int)tempPos, (int)0, (int)0, (int)12, null);
            tempPos += chunk.length;
        }
        return bytes;
    }

    private final byte[] readRawBytesSlowPathOneChunk(int size) {
        if (size == 0) {
            return new byte[0];
        }
        if (size < 0) {
            throw InvalidProtocolBufferException.Companion.negativeSize$pbandk_runtime();
        }
        int currentMessageSize = this.totalBytesRetired + this.pos + size;
        if (currentMessageSize - this.sizeLimit > 0) {
            throw InvalidProtocolBufferException.Companion.sizeLimitExceeded$pbandk_runtime();
        }
        if (currentMessageSize > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime();
        }
        int bufferedBytes = this.bufferSize - this.pos;
        int sizeLeft = size - bufferedBytes;
        if (sizeLeft < 8192 || sizeLeft <= this.input.available()) {
            int n;
            byte[] bytes = new byte[size];
            ArraysKt.copyInto((byte[])this.buffer, (byte[])bytes, (int)0, (int)this.pos, (int)(this.pos + bufferedBytes));
            InputStreamWireReader inputStreamWireReader = this;
            inputStreamWireReader.totalBytesRetired += this.bufferSize;
            this.pos = 0;
            this.bufferSize = 0;
            for (int tempPos = bufferedBytes; tempPos < bytes.length; tempPos += n) {
                n = this.input.read(bytes, tempPos, size - tempPos);
                if (n == -1) {
                    throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime();
                }
                InputStreamWireReader inputStreamWireReader2 = this;
                inputStreamWireReader2.totalBytesRetired += n;
            }
            return bytes;
        }
        return null;
    }

    private final List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) {
        byte[] chunk;
        List chunks = new ArrayList();
        for (int sizeLeft2 = sizeLeft; sizeLeft2 > 0; sizeLeft2 -= chunk.length) {
            int n;
            chunk = new byte[RangesKt.coerceAtMost((int)sizeLeft2, (int)8192)];
            for (int tempPos = 0; tempPos < chunk.length; tempPos += n) {
                n = this.input.read(chunk, tempPos, chunk.length - tempPos);
                if (n == -1) {
                    throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime();
                }
                InputStreamWireReader inputStreamWireReader = this;
                inputStreamWireReader.totalBytesRetired += n;
            }
            chunks.add(chunk);
        }
        return chunks;
    }

    private final void recomputeBufferSizeAfterLimit() {
        InputStreamWireReader inputStreamWireReader = this;
        inputStreamWireReader.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            InputStreamWireReader inputStreamWireReader2 = this;
            inputStreamWireReader2.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean tryRefillBuffer(int n) {
        var2_2 = this.pos + n > this.bufferSize;
        var3_3 = false;
        var4_5 = false;
        if (!var2_2) {
            $i$a$-check-InputStreamWireReader$tryRefillBuffer$1 = false;
            var4_6 = "refillBuffer() called when " + n + " bytes were already available in buffer";
            throw (Throwable)new IllegalStateException(var4_6.toString());
        }
        if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
            return false;
        }
        if (this.totalBytesRetired + this.pos + n > this.currentLimit) {
            return false;
        }
        tempPos = this.pos;
        if (tempPos > 0) {
            if (this.bufferSize > tempPos) {
                ArraysKt.copyInto((byte[])this.buffer, (byte[])this.buffer, (int)0, (int)tempPos, (int)this.bufferSize);
            }
            var3_4 = this;
            var3_4.totalBytesRetired += tempPos;
            var3_4 = this;
            var3_4.bufferSize -= tempPos;
            this.pos = 0;
        }
        if ((bytesRead = this.input.read(this.buffer, this.bufferSize, RangesKt.coerceAtMost((int)(this.buffer.length - this.bufferSize), (int)(this.sizeLimit - this.totalBytesRetired - this.bufferSize)))) == -1) ** GOTO lbl-1000
        v0 = 1 <= bytesRead ? bytesRead <= this.buffer.length : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        var4_5 = v1;
        var5_9 = false;
        var6_10 = false;
        if (!var4_5) {
            $i$a$-check-InputStreamWireReader$tryRefillBuffer$2 = false;
            var6_11 = this.input.getClass() + "#read(ByteArray) returned invalid result: " + bytesRead + "\nThe InputStream implementation is buggy.";
            throw (Throwable)new IllegalStateException(var6_11.toString());
        }
        if (bytesRead > 0) {
            var4_7 = this;
            var4_7.bufferSize += bytesRead;
            this.recomputeBufferSizeAfterLimit();
            return this.bufferSize >= n ? true : this.tryRefillBuffer(n);
        }
        return false;
    }

    private final void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            if (n > this.sizeLimit - this.totalBytesRetired - this.pos) {
                throw InvalidProtocolBufferException.Companion.sizeLimitExceeded$pbandk_runtime();
            }
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void skipRawBytesSlowPath(int size) {
        int totalSkipped;
        if (size < 0) {
            throw InvalidProtocolBufferException.Companion.negativeSize$pbandk_runtime();
        }
        if (this.totalBytesRetired + this.pos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.pos);
            throw InvalidProtocolBufferException.Companion.truncatedMessage$pbandk_runtime();
        }
        InputStreamWireReader inputStreamWireReader = this;
        inputStreamWireReader.totalBytesRetired += this.pos;
        this.bufferSize = 0;
        this.pos = 0;
        try {
            long skipped;
            for (totalSkipped = this.bufferSize - this.pos; totalSkipped < size; totalSkipped += (int)skipped) {
                int toSkip = size - totalSkipped;
                skipped = this.input.skip(toSkip);
                boolean bl = 0L <= skipped ? skipped <= (long)toSkip : false;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = this.input.getClass() + "#skip returned invalid result: " + skipped + "\nThe InputStream implementation is buggy.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (skipped == 0L) break;
            }
            InputStreamWireReader toSkip = this;
            toSkip.totalBytesRetired += totalSkipped;
            this.recomputeBufferSizeAfterLimit();
        }
        catch (Throwable toSkip) {
            InputStreamWireReader inputStreamWireReader2 = this;
            inputStreamWireReader2.totalBytesRetired += totalSkipped;
            this.recomputeBufferSizeAfterLimit();
            throw toSkip;
        }
        if (totalSkipped < size) {
            int tempPos = this.bufferSize - this.pos;
            this.pos = this.bufferSize;
            this.refillBuffer(1);
            while (size - tempPos > this.bufferSize) {
                tempPos += this.bufferSize;
                this.pos = this.bufferSize;
                this.refillBuffer(1);
            }
            this.pos = size - tempPos;
        }
    }
}

