/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pbandk.internal.DateTime;
import pbandk.internal.ParsePosition;
import pbandk.wkt.Duration;
import pbandk.wkt.Timestamp;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u001a\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0016H\u0000\u001a0\u0010\"\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002H\u0002\u001a\u0018\u0010(\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\u0016H\u0000\u001a\u0018\u0010+\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002\u001a \u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0002\u001a\u0010\u00100\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u001a\u0010\u00101\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u001a\u0018\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u001eH\u0002\u001a\u0010\u00105\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0002H\u0002\u001a\u0014\u00106\u001a\u00020\u0012*\u0002072\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\u001a\f\u00108\u001a\u00020\u0006*\u00020\u0012H\u0002\u001a\f\u00109\u001a\u00020\u001e*\u00020\u0012H\u0002\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0011\u001a\u00020\u0006*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006:"}, d2={"DAYS_IN_MONTH", "", "", "[Ljava/lang/Integer;", "DAYS_SINCE_JAN", "MAX_DURATION_SECONDS", "", "MAX_TIME", "MIN_DURATION_SECONDS", "MIN_TIME", "NANOS_PER_MICROSECOND", "NANOS_PER_MILLISECOND", "SECONDS_FROM_ERA_TO_EPOCH", "SECONDS_PER_400_YEARS", "SECONDS_PER_DAY", "SECONDS_PER_HOUR", "SECONDS_PER_MINUTE", "secondsSinceCommonEra", "Lpbandk/internal/DateTime;", "getSecondsSinceCommonEra", "(Lpbandk/internal/DateTime;)J", "formatDuration", "", "dur", "Lpbandk/wkt/Duration;", "formatNanos", "nanos", "formatTime", "seconds", "isLeapYear", "", "year", "parseDuration", "str", "parseInt", "parsePosition", "Lpbandk/internal/ParsePosition;", "width", "minValue", "maxValue", "parseNanos", "parseTime", "Lpbandk/wkt/Timestamp;", "parseTimezoneOffset", "requireChar", "", "char", "", "secondsPer100Years", "secondsPer4Years", "secondsPerMonth", "month", "leap", "secondsPerYear", "fromSeconds", "Lpbandk/internal/DateTime$Companion;", "toSeconds", "validate", "pbandk-runtime"})
public final class TimeUtilKt {
    private static final long MIN_TIME = -62135596800L;
    private static final long MAX_TIME = 253402300799L;
    private static final long MAX_DURATION_SECONDS = 315576000000L;
    private static final long MIN_DURATION_SECONDS = -315576000000L;
    private static final int NANOS_PER_MILLISECOND = 1000000;
    private static final int NANOS_PER_MICROSECOND = 1000;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_400_YEARS = 12622780800L;
    private static final long SECONDS_FROM_ERA_TO_EPOCH = 62135596800L;
    @NotNull
    private static final Integer[] DAYS_IN_MONTH;
    @NotNull
    private static final Integer[] DAYS_SINCE_JAN;

    private static final long secondsPer100Years(int year) {
        return year % 400 == 0 || year % 400 > 300 ? 3155760000L : 3155673600L;
    }

    private static final long secondsPer4Years(int year) {
        return (year % 100 == 0 || year % 100 > 96) && year % 400 != 0 && year % 400 <= 396 ? 126144000L : 126230400L;
    }

    private static final boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    private static final long secondsPerYear(int year) {
        return 86400L * (long)(TimeUtilKt.isLeapYear(year) ? 366 : 365);
    }

    private static final long secondsPerMonth(int month, boolean leap) {
        return 86400L * (long)(DAYS_IN_MONTH[month] + (month == 2 && leap ? 1 : 0));
    }

    private static final DateTime fromSeconds(DateTime.Companion $this$fromSeconds, long seconds) {
        boolean bl = -62135596800L <= seconds ? seconds <= 253402300799L : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Timestamp seconds outside of allowed range: '" + seconds + "' !in -62135596800..253402300799";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long seconds2 = seconds + 62135596800L;
        int year = 1;
        if (seconds2 >= 12622780800L) {
            int count400years = (int)(seconds2 / 12622780800L);
            year += 400 * count400years;
            seconds2 %= 12622780800L;
        }
        while (seconds2 >= TimeUtilKt.secondsPer100Years(year)) {
            seconds2 -= TimeUtilKt.secondsPer100Years(year);
            year += 100;
        }
        while (seconds2 >= TimeUtilKt.secondsPer4Years(year)) {
            seconds2 -= TimeUtilKt.secondsPer4Years(year);
            year += 4;
        }
        while (seconds2 >= TimeUtilKt.secondsPerYear(year)) {
            seconds2 -= TimeUtilKt.secondsPerYear(year);
            ++year;
        }
        boolean leap = TimeUtilKt.isLeapYear(year);
        int month = 1;
        while (seconds2 >= TimeUtilKt.secondsPerMonth(month, leap)) {
            seconds2 -= TimeUtilKt.secondsPerMonth(month, leap);
            ++month;
        }
        int day = 1 + (int)(seconds2 / 86400L);
        int hour = (int)((seconds2 %= 86400L) / 3600L);
        int minute = (int)((seconds2 %= 3600L) / 60L);
        return new DateTime(year, month, day, hour, minute, (int)(seconds2 %= 60L));
    }

    @NotNull
    public static final String formatTime(long seconds, int nanos) {
        boolean bl = 0 <= nanos ? nanos <= 999999999 : false;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "Timestamp nanos outside of allowed range: '" + nanos + "' !in 0..999999999";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        DateTime time = TimeUtilKt.fromSeconds(DateTime.Companion, seconds);
        n = 40;
        bl2 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl5 = false;
        boolean bl6 = false;
        StringBuilder $this$formatTime_u24lambda_u2d2 = stringBuilder;
        boolean bl7 = false;
        $this$formatTime_u24lambda_u2d2.append(StringsKt.padStart((String)String.valueOf(time.getYear()), (int)4, (char)'0'));
        $this$formatTime_u24lambda_u2d2.append('-');
        $this$formatTime_u24lambda_u2d2.append(StringsKt.padStart((String)String.valueOf(time.getMonth()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u2d2.append('-');
        $this$formatTime_u24lambda_u2d2.append(StringsKt.padStart((String)String.valueOf(time.getDay()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u2d2.append('T');
        $this$formatTime_u24lambda_u2d2.append(StringsKt.padStart((String)String.valueOf(time.getHour()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u2d2.append(':');
        $this$formatTime_u24lambda_u2d2.append(StringsKt.padStart((String)String.valueOf(time.getMinute()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u2d2.append(':');
        $this$formatTime_u24lambda_u2d2.append(StringsKt.padStart((String)String.valueOf(time.getSecond()), (int)2, (char)'0'));
        if (nanos != 0) {
            $this$formatTime_u24lambda_u2d2.append(Intrinsics.stringPlus((String)".", (Object)TimeUtilKt.formatNanos(nanos)));
        }
        $this$formatTime_u24lambda_u2d2.append('Z');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    private static final String formatNanos(int nanos) {
        return nanos % 1000000 == 0 ? StringsKt.padStart((String)String.valueOf(nanos / 1000000), (int)3, (char)'0') : (nanos % 1000 == 0 ? StringsKt.padStart((String)String.valueOf(nanos / 1000), (int)6, (char)'0') : StringsKt.padStart((String)String.valueOf(nanos), (int)9, (char)'0'));
    }

    private static final int parseInt(String str, ParsePosition parsePosition, int width, int minValue, int maxValue) {
        int i;
        int position = parsePosition.getPosition();
        char c = str.charAt(position);
        c = '0' <= c ? (c <= '9' ? (char)'\u0001' : '\u0000') : (char)'\u0000';
        boolean bl = false;
        char c2 = '\u0000';
        if (c == '\u0000') {
            boolean bl2 = false;
            String string = str;
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(position);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = Intrinsics.stringPlus((String)"Failed to parse integer at: ", (Object)string3);
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        int value = 0;
        for (i = 0; i < width; ++i) {
            c2 = str.charAt(position + i);
            boolean bl4 = '0' <= c2 ? c2 <= '9' : false;
            if (!bl4) break;
            value = value * 10 + (str.charAt(position + i) - 48);
        }
        c2 = minValue <= value ? (value <= maxValue ? (char)'\u0001' : '\u0000') : (char)'\u0000';
        boolean bl5 = false;
        boolean bl6 = false;
        if (c2 == '\u0000') {
            boolean bl7 = false;
            String string = "Integer out of range: " + value + " !in " + minValue + ".." + maxValue;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ParsePosition parsePosition2 = parsePosition;
        parsePosition2.setPosition(parsePosition2.getPosition() + i);
        return value;
    }

    private static final int parseNanos(String str, ParsePosition parsePosition) {
        int position = parsePosition.getPosition();
        char c = str.charAt(position);
        c = '0' <= c ? (c <= '9' ? (char)'\u0001' : '\u0000') : (char)'\u0000';
        boolean bl = false;
        char c2 = '\u0000';
        if (c == '\u0000') {
            boolean bl2 = false;
            String string = str;
            boolean bl3 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(position);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = Intrinsics.stringPlus((String)"Failed to parse nanos at: ", (Object)string3);
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        int value = 0;
        int len = 0;
        while (true) {
            boolean bl4 = '0' <= (c2 = str.charAt(position + len)) ? c2 <= '9' : false;
            if (!bl4) break;
            if (len < 9) {
                value = value * 10 + (str.charAt(position + len) - 48);
            }
            ++len;
        }
        ParsePosition parsePosition2 = parsePosition;
        parsePosition2.setPosition(parsePosition2.getPosition() + len);
        while (len < 9) {
            value *= 10;
            ++len;
        }
        return value;
    }

    private static final void requireChar(String str, ParsePosition parsePosition, char c) {
        boolean bl = str.charAt(parsePosition.getPosition()) == c;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Expected '").append(c).append("' at: ");
            String string = str;
            int n = parsePosition.getPosition();
            boolean bl5 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = stringBuilder.append(string3).toString();
            throw (Throwable)new IllegalArgumentException(string4.toString());
        }
        ParsePosition parsePosition2 = parsePosition;
        parsePosition2.setPosition(parsePosition2.getPosition() + 1);
        parsePosition2.getPosition();
    }

    private static final int parseTimezoneOffset(String str, ParsePosition parsePosition) {
        int hour = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 23);
        TimeUtilKt.requireChar(str, parsePosition, ':');
        int minute = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 59);
        return (hour * 60 + minute) * 60;
    }

    private static final long getSecondsSinceCommonEra(DateTime $this$secondsSinceCommonEra) {
        long result = 0L;
        int n = $this$secondsSinceCommonEra.getYear();
        n = 1 <= n ? (n <= 9999 ? 1 : 0) : 0;
        int n2 = 0;
        int n3 = 0;
        if (n == 0) {
            boolean bl = false;
            String string = "Year outside of range: '" + $this$secondsSinceCommonEra.getYear() + "' !in 1..9999";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int calculatedYear = 0;
        calculatedYear = 1;
        if ($this$secondsSinceCommonEra.getYear() - calculatedYear >= 400) {
            int count400years = ($this$secondsSinceCommonEra.getYear() - calculatedYear) / 400;
            result += 12622780800L * (long)count400years;
            calculatedYear += count400years * 400;
        }
        while ($this$secondsSinceCommonEra.getYear() - calculatedYear >= 100) {
            result += TimeUtilKt.secondsPer100Years(calculatedYear);
            calculatedYear += 100;
        }
        while ($this$secondsSinceCommonEra.getYear() - calculatedYear >= 4) {
            result += TimeUtilKt.secondsPer4Years(calculatedYear);
            calculatedYear += 4;
        }
        while ($this$secondsSinceCommonEra.getYear() > calculatedYear) {
            result += TimeUtilKt.secondsPerYear(calculatedYear);
            ++calculatedYear;
        }
        n2 = $this$secondsSinceCommonEra.getMonth();
        n2 = 1 <= n2 ? (n2 <= 12 ? 1 : 0) : 0;
        n3 = 0;
        boolean bl = false;
        if (n2 == 0) {
            boolean bl2 = false;
            String string = "Month outside of range: '" + $this$secondsSinceCommonEra.getMonth() + "' !in 1..12";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        result += 86400L * (long)DAYS_SINCE_JAN[$this$secondsSinceCommonEra.getMonth()].intValue();
        if ($this$secondsSinceCommonEra.getMonth() > 2 && TimeUtilKt.isLeapYear(calculatedYear)) {
            result += 86400L;
        }
        n2 = DAYS_IN_MONTH[$this$secondsSinceCommonEra.getMonth()] + ($this$secondsSinceCommonEra.getMonth() == 2 && TimeUtilKt.isLeapYear(calculatedYear) ? 1 : 0);
        n3 = $this$secondsSinceCommonEra.getDay();
        n2 = 1 <= n3 ? (n3 <= n2 ? 1 : 0) : 0;
        n3 = 0;
        bl = false;
        if (n2 == 0) {
            boolean bl3 = false;
            String string = "Day outside of range: '" + $this$secondsSinceCommonEra.getDay() + "' !in 1.." + (DAYS_IN_MONTH[$this$secondsSinceCommonEra.getMonth()] + ($this$secondsSinceCommonEra.getMonth() == 2 && TimeUtilKt.isLeapYear(calculatedYear) ? 1 : 0));
            throw (Throwable)new IllegalStateException(string.toString());
        }
        result += 86400L * (long)($this$secondsSinceCommonEra.getDay() - 1);
        return result += 3600L * (long)$this$secondsSinceCommonEra.getHour() + 60L * (long)$this$secondsSinceCommonEra.getMinute() + (long)$this$secondsSinceCommonEra.getSecond();
    }

    private static final boolean validate(DateTime $this$validate) {
        block4: {
            block3: {
                int n = $this$validate.getYear();
                boolean bl = 1 <= n ? n <= 9999 : false;
                if (!bl) break block3;
                n = $this$validate.getMonth();
                boolean bl2 = 1 <= n ? n <= 12 : false;
                if (!bl2) break block3;
                n = $this$validate.getDay();
                boolean bl3 = 1 <= n ? n <= 31 : false;
                if (!bl3) break block3;
                n = $this$validate.getHour();
                boolean bl4 = 0 <= n ? n <= 23 : false;
                if (!bl4) break block3;
                n = $this$validate.getMinute();
                boolean bl5 = 0 <= n ? n <= 59 : false;
                if (!bl5) break block3;
                n = $this$validate.getSecond();
                if (0 <= n ? n <= 59 : false) break block4;
            }
            return false;
        }
        return $this$validate.getMonth() == 2 && TimeUtilKt.isLeapYear($this$validate.getYear()) ? $this$validate.getDay() <= DAYS_IN_MONTH[$this$validate.getMonth()] + 1 : $this$validate.getDay() <= DAYS_IN_MONTH[$this$validate.getMonth()];
    }

    private static final long toSeconds(DateTime $this$toSeconds) {
        boolean bl = TimeUtilKt.validate($this$toSeconds);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid date/time values";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return TimeUtilKt.getSecondsSinceCommonEra($this$toSeconds) - 62135596800L;
    }

    @NotNull
    public static final Timestamp parseTime(@NotNull String str) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParsePosition parsePosition = new ParsePosition(0, 1, null);
        int year = TimeUtilKt.parseInt(str, parsePosition, 4, 1, 9999);
        TimeUtilKt.requireChar(str, parsePosition, '-');
        int month = TimeUtilKt.parseInt(str, parsePosition, 2, 1, 12);
        TimeUtilKt.requireChar(str, parsePosition, '-');
        int day = TimeUtilKt.parseInt(str, parsePosition, 2, 1, 31);
        TimeUtilKt.requireChar(str, parsePosition, 'T');
        int hour = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 23);
        TimeUtilKt.requireChar(str, parsePosition, ':');
        int minute = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 59);
        TimeUtilKt.requireChar(str, parsePosition, ':');
        int second = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 59);
        long seconds = TimeUtilKt.toSeconds(new DateTime(year, month, day, hour, minute, second));
        if (str.charAt(parsePosition.getPosition()) == '.') {
            ParsePosition parsePosition2 = parsePosition;
            parsePosition2.setPosition(parsePosition2.getPosition() + 1);
            parsePosition2.getPosition();
            n2 = TimeUtilKt.parseNanos(str, parsePosition);
        } else {
            n2 = 0;
        }
        int nanos = n2;
        Object object = parsePosition;
        int n3 = ((ParsePosition)object).getPosition();
        ((ParsePosition)object).setPosition(n3 + 1);
        char c = str.charAt(n3);
        if (c == 'Z') {
            n = 0;
        } else if (c == '+') {
            n = -TimeUtilKt.parseTimezoneOffset(str, parsePosition);
        } else if (c == '-') {
            n = TimeUtilKt.parseTimezoneOffset(str, parsePosition);
        } else {
            object = str;
            n3 = parsePosition.getPosition() - 1;
            boolean bl = false;
            String string = ((String)object).substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Expected 'Z' or timezone offset at: ", (Object)string));
        }
        int secondsOffset = n;
        c = parsePosition.getPosition() == str.length() ? (char)'\u0001' : '\u0000';
        boolean bl = false;
        n3 = 0;
        if (c == '\u0000') {
            boolean bl2 = false;
            String string = "Didn't parse entire string: position=" + parsePosition.getPosition() + ", length=" + str.length();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new Timestamp(seconds + (long)secondsOffset, nanos, null, 4, null);
    }

    @NotNull
    public static final String formatDuration(@NotNull Duration dur) {
        Intrinsics.checkNotNullParameter((Object)dur, (String)"dur");
        long seconds = 0L;
        seconds = dur.getSeconds();
        int nanos = 0;
        nanos = dur.getNanos();
        int n = -315576000000L <= seconds ? (seconds <= 315576000000L ? 1 : 0) : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Duration seconds outside of allowed range: '" + seconds + "' !in -315576000000..315576000000";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = -999999999 <= nanos ? (nanos <= 999999999 ? 1 : 0) : 0;
        bl = false;
        bl2 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "Duration nanos outside of allowed range: '" + nanos + "' !in -999999999..999999999";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = 24;
        bl = false;
        bl2 = false;
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl5 = false;
        boolean bl6 = false;
        StringBuilder $this$formatDuration_u24lambda_u2d14 = stringBuilder;
        boolean bl7 = false;
        if (seconds < 0L || nanos < 0) {
            $this$formatDuration_u24lambda_u2d14.append('-');
            seconds = -seconds;
            nanos = -nanos;
        }
        $this$formatDuration_u24lambda_u2d14.append(seconds);
        if (nanos != 0) {
            $this$formatDuration_u24lambda_u2d14.append(Intrinsics.stringPlus((String)".", (Object)TimeUtilKt.formatNanos(nanos)));
        }
        $this$formatDuration_u24lambda_u2d14.append('s');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    @NotNull
    public static final Duration parseDuration(@NotNull String str) {
        boolean bl;
        int n;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        boolean bl2 = false;
        boolean bl3 = charSequence.length() > 0 && StringsKt.last((CharSequence)str) == 's';
        bl2 = false;
        boolean bl4 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Expected duration to end with s";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean negative = StringsKt.first((CharSequence)str) == '-';
        int signLength = negative ? 1 : 0;
        long seconds = 0L;
        int nanos = 0;
        ParsePosition nanosPos = new ParsePosition(StringsKt.lastIndexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        if (nanosPos.getPosition() == 0) {
            String string = str;
            n = str.length() - 1;
            bl = false;
            String string2 = string.substring(signLength, n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string2;
            n = 0;
            seconds = Long.parseLong(string);
            nanos = 0;
        } else {
            String string = str;
            n = nanosPos.getPosition() - 1;
            bl = false;
            String string3 = string.substring(signLength, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string3;
            n = 0;
            seconds = Long.parseLong(string);
            nanos = TimeUtilKt.parseNanos(str, nanosPos);
            boolean bl6 = nanosPos.getPosition() == str.length() - 1;
            n = 0;
            bl = false;
            bl = false;
            boolean bl7 = false;
            if (!bl6) {
                boolean bl8 = false;
                String string4 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        boolean bl9 = -315576000000L <= seconds ? seconds <= 315576000000L : false;
        n = 0;
        bl = false;
        if (!bl9) {
            boolean bl10 = false;
            String string = "Duration seconds outside of allowed range: '" + seconds + "' !in -315576000000..315576000000";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl9 = -999999999 <= nanos ? nanos <= 999999999 : false;
        n = 0;
        bl = false;
        if (!bl9) {
            boolean bl11 = false;
            String string = "Duration nanos outside of allowed range: '" + nanos + "' !in -999999999..999999999";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new Duration(seconds, nanos, null, 4, null);
    }

    static {
        Integer[] integerArray = new Integer[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        DAYS_IN_MONTH = integerArray;
        integerArray = new Integer[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        DAYS_SINCE_JAN = integerArray;
    }
}

