/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary.kotlin;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.ListWithSize;
import pbandk.Message;
import pbandk.internal.binary.AbstractSizerKt;
import pbandk.internal.binary.BinaryWireEncoder;
import pbandk.internal.binary.NumberExtensionsKt;
import pbandk.internal.binary.Tag;
import pbandk.internal.binary.WireType;
import pbandk.internal.binary.kotlin.WireWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0002J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\bH\u0016J$\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'H\u0016J-\u0010(\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020*2\u0006\u0010\t\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b,\u0010-J\u0018\u0010.\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u00100\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u00101\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0002J\u0018\u00102\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u00103\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u00104\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u00105\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0002J\u0018\u00106\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00062\u0006\u0010\t\u001a\u000207H\u0002J%\u00109\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010)\u001a\u00020*H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b:\u0010;J\u0018\u0010<\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0015\u0010=\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b>J\u0018\u0010?\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0018H\u0002J\u0018\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020'2\u0006\u0010\t\u001a\u00020CH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006D"}, d2={"Lpbandk/internal/binary/kotlin/KotlinBinaryWireEncoder;", "Lpbandk/internal/binary/BinaryWireEncoder;", "wireWriter", "Lpbandk/internal/binary/kotlin/WireWriter;", "(Lpbandk/internal/binary/kotlin/WireWriter;)V", "writeBool", "", "fieldNum", "", "value", "", "writeBoolNoTag", "writeBytes", "Lpbandk/ByteArr;", "writeBytesNoTag", "writeDouble", "", "writeDoubleNoTag", "writeEnum", "Lpbandk/Message$Enum;", "writeEnumNoTag", "writeFixed32", "writeFixed32NoTag", "writeFixed64", "", "writeFixed64NoTag", "writeFloat", "", "writeFloatNoTag", "writeInt32", "writeInt32NoTag", "writeInt64", "writeInt64NoTag", "writeLengthDelimitedHeader", "protoSize", "writePackedRepeated", "list", "", "valueType", "Lpbandk/FieldDescriptor$Type;", "writeRawBytes", "wireType", "Lpbandk/internal/binary/WireType;", "", "writeRawBytes-9N1wL9M", "(II[B)V", "writeSFixed32", "writeSFixed32NoTag", "writeSFixed64", "writeSFixed64NoTag", "writeSInt32", "writeSInt32NoTag", "writeSInt64", "writeSInt64NoTag", "writeString", "", "writeStringNoTag", "writeTag", "writeTag-nHk__68", "(II)V", "writeUInt32", "writeUInt32NoTag", "writeUInt32NoTag$pbandk_runtime", "writeUInt64", "writeUInt64NoTag", "writeValueNoTag", "type", "", "pbandk-runtime"})
public final class KotlinBinaryWireEncoder
implements BinaryWireEncoder {
    @NotNull
    private final WireWriter wireWriter;

    public KotlinBinaryWireEncoder(@NotNull WireWriter wireWriter) {
        Intrinsics.checkNotNullParameter((Object)wireWriter, (String)"wireWriter");
        this.wireWriter = wireWriter;
    }

    private final void writeValueNoTag(FieldDescriptor.Type type, Object value) {
        FieldDescriptor.Type type2 = type;
        if (type2 instanceof FieldDescriptor.Type.Primitive.Double) {
            this.writeDoubleNoTag((Double)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Float) {
            this.writeFloatNoTag(((Float)value).floatValue());
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int64) {
            this.writeInt64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt64) {
            this.writeUInt64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int32) {
            this.writeInt32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed64) {
            this.writeFixed64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed32) {
            this.writeFixed32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bool) {
            this.writeBoolNoTag((Boolean)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.String) {
            this.writeStringNoTag((String)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bytes) {
            this.writeBytesNoTag((ByteArr)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt32) {
            this.writeUInt32NoTag$pbandk_runtime((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed32) {
            this.writeSFixed32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed64) {
            this.writeSFixed64NoTag((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt32) {
            this.writeSInt32NoTag((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt64) {
            this.writeSInt64NoTag((Long)value);
        } else {
            if (type2 instanceof FieldDescriptor.Type.Message) {
                String string = "writeValueNoTag() should only be called for primitive types";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (type2 instanceof FieldDescriptor.Type.Enum) {
                this.writeEnumNoTag((Message.Enum)value);
            } else {
                if (type2 instanceof FieldDescriptor.Type.Repeated) {
                    String string = "writeValueNoTag() should only be called for primitive types";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                if (type2 instanceof FieldDescriptor.Type.Map) {
                    String string = "writeValueNoTag() should only be called for primitive types";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
    }

    public final void writeUInt32NoTag$pbandk_runtime(int value) {
        byte[] buffer = new byte[10];
        int position = 0;
        int valueCur = value;
        while (position < 10) {
            int n;
            if ((valueCur & 0xFFFFFF80) == 0) {
                n = position;
                position = n + 1;
                buffer[n] = (byte)valueCur;
                break;
            }
            n = position;
            position = n + 1;
            buffer[n] = (byte)(valueCur & 0x7F | 0x80);
            valueCur >>>= 7;
        }
        this.wireWriter.write(buffer, 0, position);
    }

    private final void writeUInt64NoTag(long value) {
        byte[] buffer = new byte[10];
        int position = 0;
        long valueCur = value;
        while (position < 10) {
            int n;
            if ((valueCur & 0xFFFFFFFFFFFFFF80L) == 0L) {
                n = position;
                position = n + 1;
                buffer[n] = (byte)valueCur;
                break;
            }
            n = position;
            position = n + 1;
            buffer[n] = (byte)(valueCur & 0x7FL | 0x80L);
            valueCur >>>= 7;
        }
        this.wireWriter.write(buffer, 0, position);
    }

    private final void writeTag-nHk__68(int fieldNum, int wireType) {
        this.writeUInt32NoTag$pbandk_runtime(Tag.constructor-impl(fieldNum, wireType));
    }

    @Override
    public void writeRawBytes-9N1wL9M(int fieldNum, int wireType, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, wireType);
        this.wireWriter.write(value, 0, value.length);
    }

    @Override
    public void writeLengthDelimitedHeader(int fieldNum, int protoSize2) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getLENGTH_DELIMITED-K6X5YLY());
        this.writeUInt32NoTag$pbandk_runtime(protoSize2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writePackedRepeated(int fieldNum, @NotNull List<?> list, @NotNull FieldDescriptor.Type valueType) {
        int n;
        boolean bl;
        boolean bl2;
        Integer n2;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        Iterable iterable = list instanceof ListWithSize ? (ListWithSize)list : null;
        Integer n3 = n2 = iterable == null ? null : ((ListWithSize)iterable).getProtoSize();
        if (n2 == null) {
            iterable = list;
            boolean bl3 = false;
            int n4 = 0;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t;
                Object t2 = t = iterator.next();
                int n5 = n4;
                boolean bl4 = false;
                bl2 = false;
                bl = false;
                bl = false;
                boolean bl5 = false;
                if (it == null) {
                    boolean bl6 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int n6 = AbstractSizerKt.protoSize(valueType, it);
                n4 = n5 + n6;
            }
            n = n4;
        } else {
            n = n2;
        }
        int listSize = n;
        this.writeLengthDelimitedHeader(fieldNum, listSize);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            bl9 = false;
            bl2 = false;
            if (it == null) {
                bl = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.writeValueNoTag(valueType, it);
        }
    }

    private final void writeInt32NoTag(int value) {
        if (value >= 0) {
            this.writeUInt32NoTag$pbandk_runtime(value);
        } else {
            this.writeUInt64NoTag(value);
        }
    }

    @Override
    public void writeInt32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeInt32NoTag(value);
    }

    private final void writeInt64NoTag(long value) {
        this.writeUInt64NoTag(value);
    }

    @Override
    public void writeInt64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeInt64NoTag(value);
    }

    @Override
    public void writeUInt32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeUInt32NoTag$pbandk_runtime(value);
    }

    @Override
    public void writeUInt64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeUInt64NoTag(value);
    }

    private final void writeSInt32NoTag(int value) {
        this.writeUInt32NoTag$pbandk_runtime(NumberExtensionsKt.getZigZagEncoded(value));
    }

    @Override
    public void writeSInt32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeSInt32NoTag(value);
    }

    private final void writeSInt64NoTag(long value) {
        this.writeUInt64NoTag(NumberExtensionsKt.getZigZagEncoded(value));
    }

    @Override
    public void writeSInt64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeSInt64NoTag(value);
    }

    private final void writeBoolNoTag(boolean value) {
        byte[] byArray = new byte[]{value ? (byte)1 : 0};
        this.wireWriter.write(byArray, 0, 1);
    }

    @Override
    public void writeBool(int fieldNum, boolean value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeBoolNoTag(value);
    }

    private final void writeEnumNoTag(Message.Enum value) {
        this.writeInt32NoTag(value.getValue());
    }

    @Override
    public void writeEnum(int fieldNum, @NotNull Message.Enum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getVARINT-K6X5YLY());
        this.writeEnumNoTag(value);
    }

    private final void writeFixed32NoTag(int value) {
        int n = 0;
        byte[] byArray = new byte[4];
        WireWriter wireWriter = this.wireWriter;
        while (n < 4) {
            int n2 = n++;
            byArray[n2] = (byte)(value >> 8 * n2);
        }
        wireWriter.write(byArray, 0, 4);
    }

    @Override
    public void writeFixed32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED32-K6X5YLY());
        this.writeFixed32NoTag(value);
    }

    private final void writeFixed64NoTag(long value) {
        int n = 0;
        byte[] byArray = new byte[8];
        WireWriter wireWriter = this.wireWriter;
        while (n < 8) {
            int n2 = n++;
            byArray[n2] = (byte)(value >> 8 * n2);
        }
        wireWriter.write(byArray, 0, 8);
    }

    @Override
    public void writeFixed64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED64-K6X5YLY());
        this.writeFixed64NoTag(value);
    }

    private final void writeSFixed32NoTag(int value) {
        this.writeFixed32NoTag(value);
    }

    @Override
    public void writeSFixed32(int fieldNum, int value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED32-K6X5YLY());
        this.writeSFixed32NoTag(value);
    }

    private final void writeSFixed64NoTag(long value) {
        this.writeFixed64NoTag(value);
    }

    @Override
    public void writeSFixed64(int fieldNum, long value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED64-K6X5YLY());
        this.writeSFixed64NoTag(value);
    }

    private final void writeFloatNoTag(float value) {
        float f = value;
        boolean bl = false;
        this.writeFixed32NoTag(Float.floatToRawIntBits(f));
    }

    @Override
    public void writeFloat(int fieldNum, float value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED32-K6X5YLY());
        this.writeFloatNoTag(value);
    }

    private final void writeDoubleNoTag(double value) {
        double d = value;
        boolean bl = false;
        this.writeFixed64NoTag(Double.doubleToRawLongBits(d));
    }

    @Override
    public void writeDouble(int fieldNum, double value) {
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getFIXED64-K6X5YLY());
        this.writeDoubleNoTag(value);
    }

    private final void writeStringNoTag(String value) {
        this.writeBytesNoTag(new ByteArr(StringsKt.encodeToByteArray((String)value)));
    }

    @Override
    public void writeString(int fieldNum, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getLENGTH_DELIMITED-K6X5YLY());
        this.writeStringNoTag(value);
    }

    private final void writeBytesNoTag(ByteArr value) {
        this.writeUInt32NoTag$pbandk_runtime(value.getArray().length);
        this.wireWriter.write(value.getArray(), 0, value.getArray().length);
    }

    @Override
    public void writeBytes(int fieldNum, @NotNull ByteArr value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeTag-nHk__68(fieldNum, WireType.Companion.getLENGTH_DELIMITED-K6X5YLY());
        this.writeBytesNoTag(value);
    }
}

