/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pbandk.internal.DateTime;
import pbandk.internal.ParsePosition;
import pbandk.wkt.Duration;
import pbandk.wkt.Timestamp;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0006H\u0000\u001a\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002\u001a0\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0002\u001a\u0018\u0010)\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002\u001a \u0010*\u001a\u00020+2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010,\u001a\u00020-H\u0002\u001a\u0018\u0010.\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002\u001a\f\u00102\u001a\u00020\u0011*\u00020\u001bH\u0002\u001a\f\u00103\u001a\u00020\u0001*\u00020\u001bH\u0002\u001a\u0010\u00104\u001a\u0002052\u0006\u0010#\u001a\u00020\u001fH\u0000\u001a\u0010\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u000208H\u0000\u001a\u0010\u00109\u001a\u0002082\u0006\u0010#\u001a\u00020\u001fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\"\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\"\u0018\u0010/\u001a\u00020\u0001*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006:"}, d2={"MIN_TIME", "", "MAX_TIME", "MAX_DURATION_SECONDS", "MIN_DURATION_SECONDS", "NANOS_PER_MILLISECOND", "", "NANOS_PER_MICROSECOND", "SECONDS_PER_MINUTE", "SECONDS_PER_HOUR", "SECONDS_PER_DAY", "SECONDS_PER_400_YEARS", "SECONDS_FROM_ERA_TO_EPOCH", "secondsPer100Years", "year", "secondsPer4Years", "isLeapYear", "", "secondsPerYear", "DAYS_IN_MONTH", "", "[Ljava/lang/Integer;", "secondsPerMonth", "month", "leap", "DAYS_SINCE_JAN", "fromSeconds", "Lpbandk/internal/DateTime;", "Lpbandk/internal/DateTime$Companion;", "seconds", "formatTime", "", "nanos", "formatNanos", "parseInt", "str", "parsePosition", "Lpbandk/internal/ParsePosition;", "width", "minValue", "maxValue", "parseNanos", "requireChar", "", "char", "", "parseTimezoneOffset", "secondsSinceCommonEra", "getSecondsSinceCommonEra", "(Lpbandk/internal/DateTime;)J", "validate", "toSeconds", "parseTime", "Lpbandk/wkt/Timestamp;", "formatDuration", "dur", "Lpbandk/wkt/Duration;", "parseDuration", "pbandk-runtime"})
@SourceDebugExtension(value={"SMAP\nTimeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeUtil.kt\npbandk/internal/TimeUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,435:1\n1#2:436\n*E\n"})
public final class TimeUtilKt {
    private static final long MIN_TIME = -62135596800L;
    private static final long MAX_TIME = 253402300799L;
    private static final long MAX_DURATION_SECONDS = 315576000000L;
    private static final long MIN_DURATION_SECONDS = -315576000000L;
    private static final int NANOS_PER_MILLISECOND = 1000000;
    private static final int NANOS_PER_MICROSECOND = 1000;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_400_YEARS = 12622780800L;
    private static final long SECONDS_FROM_ERA_TO_EPOCH = 62135596800L;
    @NotNull
    private static final Integer[] DAYS_IN_MONTH;
    @NotNull
    private static final Integer[] DAYS_SINCE_JAN;

    private static final long secondsPer100Years(int year) {
        return year % 400 == 0 || year % 400 > 300 ? 3155760000L : 3155673600L;
    }

    private static final long secondsPer4Years(int year) {
        return (year % 100 == 0 || year % 100 > 96) && year % 400 != 0 && year % 400 <= 396 ? 126144000L : 126230400L;
    }

    private static final boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    private static final long secondsPerYear(int year) {
        return 86400L * (long)(TimeUtilKt.isLeapYear(year) ? 366 : 365);
    }

    private static final long secondsPerMonth(int month, boolean leap) {
        return 86400L * (long)(DAYS_IN_MONTH[month] + (month == 2 && leap ? 1 : 0));
    }

    private static final DateTime fromSeconds(DateTime.Companion $this$fromSeconds, long seconds) {
        if (!(-62135596800L <= seconds ? seconds < 253402300800L : false)) {
            boolean bl = false;
            String string = "Timestamp seconds outside of allowed range: '" + seconds + "' !in -62135596800..253402300799";
            throw new IllegalArgumentException(string.toString());
        }
        long seconds2 = seconds + 62135596800L;
        int year = 1;
        if (seconds2 >= 12622780800L) {
            int count400years = (int)(seconds2 / 12622780800L);
            year += 400 * count400years;
            seconds2 %= 12622780800L;
        }
        while (seconds2 >= TimeUtilKt.secondsPer100Years(year)) {
            seconds2 -= TimeUtilKt.secondsPer100Years(year);
            year += 100;
        }
        while (seconds2 >= TimeUtilKt.secondsPer4Years(year)) {
            seconds2 -= TimeUtilKt.secondsPer4Years(year);
            year += 4;
        }
        while (seconds2 >= TimeUtilKt.secondsPerYear(year)) {
            seconds2 -= TimeUtilKt.secondsPerYear(year);
            ++year;
        }
        boolean leap = TimeUtilKt.isLeapYear(year);
        int month = 1;
        while (seconds2 >= TimeUtilKt.secondsPerMonth(month, leap)) {
            seconds2 -= TimeUtilKt.secondsPerMonth(month, leap);
            ++month;
        }
        int day = 1 + (int)(seconds2 / 86400L);
        int hour = (int)((seconds2 %= 86400L) / 3600L);
        int minute = (int)((seconds2 %= 3600L) / 60L);
        return new DateTime(year, month, day, hour, minute, (int)(seconds2 %= 60L));
    }

    @NotNull
    public static final String formatTime(long seconds, int nanos) {
        StringBuilder stringBuilder;
        if (!(0 <= nanos ? nanos < 1000000000 : false)) {
            boolean bl = false;
            String string = "Timestamp nanos outside of allowed range: '" + nanos + "' !in 0..999999999";
            throw new IllegalArgumentException(string.toString());
        }
        DateTime time = TimeUtilKt.fromSeconds(DateTime.Companion, seconds);
        int n = 40;
        StringBuilder $this$formatTime_u24lambda_u242 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$formatTime_u24lambda_u242.append(StringsKt.padStart((String)String.valueOf(time.getYear()), (int)4, (char)'0'));
        $this$formatTime_u24lambda_u242.append('-');
        $this$formatTime_u24lambda_u242.append(StringsKt.padStart((String)String.valueOf(time.getMonth()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u242.append('-');
        $this$formatTime_u24lambda_u242.append(StringsKt.padStart((String)String.valueOf(time.getDay()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u242.append('T');
        $this$formatTime_u24lambda_u242.append(StringsKt.padStart((String)String.valueOf(time.getHour()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u242.append(':');
        $this$formatTime_u24lambda_u242.append(StringsKt.padStart((String)String.valueOf(time.getMinute()), (int)2, (char)'0'));
        $this$formatTime_u24lambda_u242.append(':');
        $this$formatTime_u24lambda_u242.append(StringsKt.padStart((String)String.valueOf(time.getSecond()), (int)2, (char)'0'));
        if (nanos != 0) {
            $this$formatTime_u24lambda_u242.append('.' + TimeUtilKt.formatNanos(nanos));
        }
        $this$formatTime_u24lambda_u242.append('Z');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String formatNanos(int nanos) {
        return nanos % 1000000 == 0 ? StringsKt.padStart((String)String.valueOf(nanos / 1000000), (int)3, (char)'0') : (nanos % 1000 == 0 ? StringsKt.padStart((String)String.valueOf(nanos / 1000), (int)6, (char)'0') : StringsKt.padStart((String)String.valueOf(nanos), (int)9, (char)'0'));
    }

    private static final int parseInt(String str, ParsePosition parsePosition, int width, int minValue, int maxValue) {
        int i;
        int position = parsePosition.getPosition();
        if (!(position < str.length())) {
            boolean $i$a$-require-TimeUtilKt$parseInt$52 = false;
            String $i$a$-require-TimeUtilKt$parseInt$52 = "String ended unexpectedly: " + str;
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseInt$52.toString());
        }
        char c = str.charAt(position);
        if (!('0' <= c ? c < ':' : false)) {
            boolean $i$a$-require-TimeUtilKt$parseInt$62 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Failed to parse integer at: ");
            String string = str.substring(position);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String $i$a$-require-TimeUtilKt$parseInt$62 = stringBuilder.append(string).toString();
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseInt$62.toString());
        }
        int value = 0;
        for (i = 0; i < width; ++i) {
            if (!(position + i < str.length())) {
                boolean $i$a$-require-TimeUtilKt$parseInt$72 = false;
                String $i$a$-require-TimeUtilKt$parseInt$72 = "String ended unexpectedly: " + str;
                throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseInt$72.toString());
            }
            char c2 = str.charAt(position + i);
            boolean bl = '0' <= c2 ? c2 < ':' : false;
            if (!bl) break;
            value = value * 10 + (str.charAt(position + i) - 48);
        }
        if (!(minValue <= value ? value <= maxValue : false)) {
            boolean bl = false;
            String string = "Integer out of range: " + value + " !in " + minValue + ".." + maxValue;
            throw new IllegalArgumentException(string.toString());
        }
        parsePosition.setPosition(parsePosition.getPosition() + i);
        return value;
    }

    private static final int parseNanos(String str, ParsePosition parsePosition) {
        int len;
        int value;
        block4: {
            int position = parsePosition.getPosition();
            if (!(position < str.length())) {
                boolean $i$a$-require-TimeUtilKt$parseNanos$42 = false;
                String $i$a$-require-TimeUtilKt$parseNanos$42 = "String ended unexpectedly: " + str;
                throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseNanos$42.toString());
            }
            char c = str.charAt(position);
            if (!('0' <= c ? c < ':' : false)) {
                boolean $i$a$-require-TimeUtilKt$parseNanos$52 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Failed to parse nanos at: ");
                String string = str.substring(position);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String $i$a$-require-TimeUtilKt$parseNanos$52 = stringBuilder.append(string).toString();
                throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseNanos$52.toString());
            }
            value = 0;
            len = 0;
            do {
                char c2;
                boolean bl = '0' <= (c2 = str.charAt(position + len)) ? c2 < ':' : false;
                if (!bl) break block4;
                if (len >= 9) continue;
                value = value * 10 + (str.charAt(position + len) - 48);
            } while (position + ++len < str.length());
            boolean bl = false;
            String string = "String ended unexpectedly: " + str;
            throw new IllegalArgumentException(string.toString());
        }
        parsePosition.setPosition(parsePosition.getPosition() + len);
        while (len < 9) {
            value *= 10;
            ++len;
        }
        return value;
    }

    private static final void requireChar(String str, ParsePosition parsePosition, char c) {
        if (!(parsePosition.getPosition() < str.length())) {
            boolean $i$a$-require-TimeUtilKt$requireChar$32 = false;
            String $i$a$-require-TimeUtilKt$requireChar$32 = "String ended unexpectedly: " + str;
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$requireChar$32.toString());
        }
        if (!(str.charAt(parsePosition.getPosition()) == c)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Expected '").append(c).append("' at: ");
            String string = str.substring(parsePosition.getPosition());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = stringBuilder.append(string).toString();
            throw new IllegalArgumentException(string2.toString());
        }
        parsePosition.setPosition(parsePosition.getPosition() + 1);
        parsePosition.getPosition();
    }

    private static final int parseTimezoneOffset(String str, ParsePosition parsePosition) {
        int hour = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 23);
        TimeUtilKt.requireChar(str, parsePosition, ':');
        int minute = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 59);
        return (hour * 60 + minute) * 60;
    }

    private static final long getSecondsSinceCommonEra(DateTime $this$secondsSinceCommonEra) {
        long result = 0L;
        int n = $this$secondsSinceCommonEra.getYear();
        if (!(1 <= n ? n < 10000 : false)) {
            boolean $i$a$-check-TimeUtilKt$secondsSinceCommonEra$42 = false;
            String $i$a$-check-TimeUtilKt$secondsSinceCommonEra$42 = "Year outside of range: '" + $this$secondsSinceCommonEra.getYear() + "' !in 1..9999";
            throw new IllegalStateException($i$a$-check-TimeUtilKt$secondsSinceCommonEra$42.toString());
        }
        int calculatedYear = 0;
        calculatedYear = 1;
        if ($this$secondsSinceCommonEra.getYear() - calculatedYear >= 400) {
            int count400years = ($this$secondsSinceCommonEra.getYear() - calculatedYear) / 400;
            result += 12622780800L * (long)count400years;
            calculatedYear += count400years * 400;
        }
        while ($this$secondsSinceCommonEra.getYear() - calculatedYear >= 100) {
            result += TimeUtilKt.secondsPer100Years(calculatedYear);
            calculatedYear += 100;
        }
        while ($this$secondsSinceCommonEra.getYear() - calculatedYear >= 4) {
            result += TimeUtilKt.secondsPer4Years(calculatedYear);
            calculatedYear += 4;
        }
        while ($this$secondsSinceCommonEra.getYear() > calculatedYear) {
            result += TimeUtilKt.secondsPerYear(calculatedYear);
            ++calculatedYear;
        }
        int n2 = $this$secondsSinceCommonEra.getMonth();
        if (!(1 <= n2 ? n2 < 13 : false)) {
            boolean $i$a$-check-TimeUtilKt$secondsSinceCommonEra$52 = false;
            String $i$a$-check-TimeUtilKt$secondsSinceCommonEra$52 = "Month outside of range: '" + $this$secondsSinceCommonEra.getMonth() + "' !in 1..12";
            throw new IllegalStateException($i$a$-check-TimeUtilKt$secondsSinceCommonEra$52.toString());
        }
        result += 86400L * (long)DAYS_SINCE_JAN[$this$secondsSinceCommonEra.getMonth()].intValue();
        if ($this$secondsSinceCommonEra.getMonth() > 2 && TimeUtilKt.isLeapYear(calculatedYear)) {
            result += 86400L;
        }
        n2 = DAYS_IN_MONTH[$this$secondsSinceCommonEra.getMonth()] + ($this$secondsSinceCommonEra.getMonth() == 2 && TimeUtilKt.isLeapYear(calculatedYear) ? 1 : 0);
        int $i$a$-check-TimeUtilKt$secondsSinceCommonEra$52 = $this$secondsSinceCommonEra.getDay();
        if (!(1 <= $i$a$-check-TimeUtilKt$secondsSinceCommonEra$52 ? $i$a$-check-TimeUtilKt$secondsSinceCommonEra$52 <= n2 : false)) {
            boolean bl = false;
            String string = "Day outside of range: '" + $this$secondsSinceCommonEra.getDay() + "' !in 1.." + (DAYS_IN_MONTH[$this$secondsSinceCommonEra.getMonth()] + ($this$secondsSinceCommonEra.getMonth() == 2 && TimeUtilKt.isLeapYear(calculatedYear) ? 1 : 0));
            throw new IllegalStateException(string.toString());
        }
        result += 86400L * (long)($this$secondsSinceCommonEra.getDay() - 1);
        return result += 3600L * (long)$this$secondsSinceCommonEra.getHour() + 60L * (long)$this$secondsSinceCommonEra.getMinute() + (long)$this$secondsSinceCommonEra.getSecond();
    }

    private static final boolean validate(DateTime $this$validate) {
        block4: {
            block3: {
                int n = $this$validate.getYear();
                boolean bl = 1 <= n ? n < 10000 : false;
                if (!bl) break block3;
                n = $this$validate.getMonth();
                boolean bl2 = 1 <= n ? n < 13 : false;
                if (!bl2) break block3;
                n = $this$validate.getDay();
                boolean bl3 = 1 <= n ? n < 32 : false;
                if (!bl3) break block3;
                n = $this$validate.getHour();
                boolean bl4 = 0 <= n ? n < 24 : false;
                if (!bl4) break block3;
                n = $this$validate.getMinute();
                boolean bl5 = 0 <= n ? n < 60 : false;
                if (!bl5) break block3;
                n = $this$validate.getSecond();
                if (0 <= n ? n < 60 : false) break block4;
            }
            return false;
        }
        return $this$validate.getMonth() == 2 && TimeUtilKt.isLeapYear($this$validate.getYear()) ? $this$validate.getDay() <= DAYS_IN_MONTH[$this$validate.getMonth()] + 1 : $this$validate.getDay() <= DAYS_IN_MONTH[$this$validate.getMonth()];
    }

    private static final long toSeconds(DateTime $this$toSeconds) {
        if (!TimeUtilKt.validate($this$toSeconds)) {
            boolean bl = false;
            String string = "Invalid date/time values";
            throw new IllegalArgumentException(string.toString());
        }
        return TimeUtilKt.getSecondsSinceCommonEra($this$toSeconds) - 62135596800L;
    }

    @NotNull
    public static final Timestamp parseTime(@NotNull String str) {
        int n;
        int nanos;
        int n2;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        ParsePosition parsePosition = new ParsePosition(0, 1, null);
        int year = TimeUtilKt.parseInt(str, parsePosition, 4, 1, 9999);
        TimeUtilKt.requireChar(str, parsePosition, '-');
        int month = TimeUtilKt.parseInt(str, parsePosition, 2, 1, 12);
        TimeUtilKt.requireChar(str, parsePosition, '-');
        int day = TimeUtilKt.parseInt(str, parsePosition, 2, 1, 31);
        TimeUtilKt.requireChar(str, parsePosition, 'T');
        int hour = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 23);
        TimeUtilKt.requireChar(str, parsePosition, ':');
        int minute = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 59);
        TimeUtilKt.requireChar(str, parsePosition, ':');
        int second = TimeUtilKt.parseInt(str, parsePosition, 2, 0, 59);
        long seconds = TimeUtilKt.toSeconds(new DateTime(year, month, day, hour, minute, second));
        if (!(parsePosition.getPosition() < str.length())) {
            boolean $i$a$-require-TimeUtilKt$parseTime$42 = false;
            String $i$a$-require-TimeUtilKt$parseTime$42 = "String ended unexpectedly: " + str;
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseTime$42.toString());
        }
        if (str.charAt(parsePosition.getPosition()) == '.') {
            parsePosition.setPosition(parsePosition.getPosition() + 1);
            parsePosition.getPosition();
            n2 = TimeUtilKt.parseNanos(str, parsePosition);
        } else {
            n2 = nanos = 0;
        }
        if (!(parsePosition.getPosition() < str.length())) {
            boolean bl = false;
            String string = "String ended unexpectedly: " + str;
            throw new IllegalArgumentException(string.toString());
        }
        int n3 = parsePosition.getPosition();
        parsePosition.setPosition(n3 + 1);
        switch (str.charAt(n3)) {
            case 'Z': {
                n = 0;
                break;
            }
            case '+': {
                n = -TimeUtilKt.parseTimezoneOffset(str, parsePosition);
                break;
            }
            case '-': {
                n = TimeUtilKt.parseTimezoneOffset(str, parsePosition);
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("Expected 'Z' or timezone offset at: ");
                String string = str.substring(parsePosition.getPosition() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                throw new IllegalArgumentException(stringBuilder.append(string).toString());
            }
        }
        int secondsOffset = n;
        if (!(parsePosition.getPosition() == str.length())) {
            boolean bl = false;
            String string = "Didn't parse entire string: position=" + parsePosition.getPosition() + ", length=" + str.length();
            throw new IllegalArgumentException(string.toString());
        }
        return new Timestamp(seconds + (long)secondsOffset, nanos, null, 4, null);
    }

    @NotNull
    public static final String formatDuration(@NotNull Duration dur) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)dur, (String)"dur");
        long seconds = 0L;
        seconds = dur.getSeconds();
        int nanos = 0;
        nanos = dur.getNanos();
        if (!(-315576000000L <= seconds ? seconds < 315576000001L : false)) {
            boolean $i$a$-require-TimeUtilKt$formatDuration$32 = false;
            String $i$a$-require-TimeUtilKt$formatDuration$32 = "Duration seconds outside of allowed range: '" + seconds + "' !in -315576000000..315576000000";
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$formatDuration$32.toString());
        }
        if (!(-999999999 <= nanos ? nanos < 1000000000 : false)) {
            boolean bl = false;
            String string = "Duration nanos outside of allowed range: '" + nanos + "' !in -999999999..999999999";
            throw new IllegalArgumentException(string.toString());
        }
        int n = 24;
        StringBuilder $this$formatDuration_u24lambda_u2421 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        if (seconds < 0L || nanos < 0) {
            $this$formatDuration_u24lambda_u2421.append('-');
            seconds = -seconds;
            nanos = -nanos;
        }
        $this$formatDuration_u24lambda_u2421.append(seconds);
        if (nanos != 0) {
            $this$formatDuration_u24lambda_u2421.append('.' + TimeUtilKt.formatNanos(nanos));
        }
        $this$formatDuration_u24lambda_u2421.append('s');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final Duration parseDuration(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        if (!(((CharSequence)str).length() > 0 && StringsKt.last((CharSequence)str) == 's')) {
            boolean $i$a$-require-TimeUtilKt$parseDuration$42 = false;
            String $i$a$-require-TimeUtilKt$parseDuration$42 = "Expected duration to end with s";
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseDuration$42.toString());
        }
        boolean negative = StringsKt.first((CharSequence)str) == '-';
        int signLength = negative ? 1 : 0;
        long seconds = 0L;
        int nanos = 0;
        ParsePosition nanosPos = new ParsePosition(StringsKt.lastIndexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
        if (nanosPos.getPosition() == 0) {
            String string = str.substring(signLength, str.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            seconds = Long.parseLong(string);
            nanos = 0;
        } else {
            String string = str.substring(signLength, nanosPos.getPosition() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            seconds = Long.parseLong(string);
            nanos = TimeUtilKt.parseNanos(str, nanosPos);
            if (!(nanosPos.getPosition() == str.length() - 1)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        if (!(-315576000000L <= seconds ? seconds < 315576000001L : false)) {
            boolean $i$a$-require-TimeUtilKt$parseDuration$52 = false;
            String $i$a$-require-TimeUtilKt$parseDuration$52 = "Duration seconds outside of allowed range: '" + seconds + "' !in -315576000000..315576000000";
            throw new IllegalArgumentException($i$a$-require-TimeUtilKt$parseDuration$52.toString());
        }
        if (!(-999999999 <= nanos ? nanos < 1000000000 : false)) {
            boolean bl = false;
            String string = "Duration nanos outside of allowed range: '" + nanos + "' !in -999999999..999999999";
            throw new IllegalArgumentException(string.toString());
        }
        return new Duration(seconds, nanos, null, 4, null);
    }

    static {
        Integer[] integerArray = new Integer[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        DAYS_IN_MONTH = integerArray;
        integerArray = new Integer[]{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        DAYS_SINCE_JAN = integerArray;
    }
}

