/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.binary;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import pbandk.internal.binary.kotlin.WireWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0006\u0010\u0015\u001a\u00020\u0011J\b\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpbandk/internal/binary/OutputStreamWireWriter;", "Lpbandk/internal/binary/kotlin/WireWriter;", "stream", "Ljava/io/OutputStream;", "bufferSize", "", "<init>", "(Ljava/io/OutputStream;I)V", "value", "totalBytesWritten", "getTotalBytesWritten", "()I", "buffer", "", "limit", "position", "write", "", "bytes", "offset", "length", "flush", "doFlush", "pbandk-runtime"})
public final class OutputStreamWireWriter
implements WireWriter {
    @NotNull
    private final OutputStream stream;
    private int totalBytesWritten;
    @NotNull
    private final byte[] buffer;
    private final int limit;
    private int position;

    public OutputStreamWireWriter(@NotNull OutputStream stream, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.buffer = new byte[RangesKt.coerceAtLeast((int)bufferSize, (int)20)];
        this.limit = this.buffer.length;
    }

    public /* synthetic */ OutputStreamWireWriter(OutputStream outputStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        this(outputStream, n);
    }

    @Override
    public int getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    @Override
    public void write(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (this.limit - this.position >= length) {
            ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)this.position, (int)offset, (int)(offset + length));
            this.position += length;
            this.totalBytesWritten = this.getTotalBytesWritten() + length;
            return;
        }
        int offset2 = offset;
        int length2 = length;
        int bytesWritten = this.limit - this.position;
        ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)this.position, (int)offset2, (int)(offset2 + bytesWritten));
        offset2 += bytesWritten;
        this.position = this.limit;
        this.totalBytesWritten = this.getTotalBytesWritten() + bytesWritten;
        this.doFlush();
        if ((length2 -= bytesWritten) <= this.limit) {
            ArraysKt.copyInto((byte[])bytes, (byte[])this.buffer, (int)0, (int)offset2, (int)(offset2 + length2));
            this.position = length2;
        } else {
            this.stream.write(bytes, offset2, length2);
        }
        this.totalBytesWritten = this.getTotalBytesWritten() + length2;
    }

    public final void flush() {
        if (this.position > 0) {
            this.doFlush();
        }
    }

    private final void doFlush() {
        this.stream.write(this.buffer, 0, this.position);
        this.position = 0;
    }
}

