/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.json;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.InvalidProtocolBufferException;
import pbandk.Message;
import pbandk.MessageMap;
import pbandk.internal.Util_jvmKt;
import pbandk.internal.json.JsonMessageAdapters;
import pbandk.internal.json.JsonMessageDecoder;
import pbandk.json.JsonConfig;
import pbandk.wkt.BoolValue;
import pbandk.wkt.BytesValue;
import pbandk.wkt.DoubleValue;
import pbandk.wkt.FloatValue;
import pbandk.wkt.Int32Value;
import pbandk.wkt.Int64Value;
import pbandk.wkt.StringValue;
import pbandk.wkt.UInt32Value;
import pbandk.wkt.UInt64Value;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u00020\u0001:\u00011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ8\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u00100\u0012H\u0082\b\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010$\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010%\u001a\u00020&2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010'\u001a\u00020(2\u0006\u0010\t\u001a\u00020\n2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*J\u001a\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010-\u001a\u00020\fJ,\u0010.\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030/0,2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000300R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00062"}, d2={"Lpbandk/internal/json/JsonValueDecoder;", "", "jsonConfig", "Lpbandk/json/JsonConfig;", "<init>", "(Lpbandk/json/JsonConfig;)V", "getJsonConfig", "()Lpbandk/json/JsonConfig;", "readValue", "value", "Lkotlinx/serialization/json/JsonElement;", "type", "Lpbandk/FieldDescriptor$Type;", "isMapKey", "", "readIntegerInternal", "T", "body", "Lkotlin/Function1;", "", "(Lkotlinx/serialization/json/JsonElement;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readInteger32", "", "readInteger64", "", "readUnsignedInteger32", "readUnsignedInteger64", "readBool", "readEnum", "Lpbandk/Message$Enum;", "enumCompanion", "Lpbandk/Message$Enum$Companion;", "readFloat", "", "readDouble", "", "readString", "readBytes", "Lpbandk/ByteArr;", "readMessage", "Lpbandk/Message;", "messageCompanion", "Lpbandk/Message$Companion;", "readRepeated", "Lkotlin/sequences/Sequence;", "valueType", "readMap", "", "Lpbandk/FieldDescriptor$Type$Map;", "Companion", "pbandk-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonValueDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonValueDecoder.kt\npbandk/internal/json/JsonValueDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n74#1,46:278\n74#1,46:324\n74#1,46:370\n74#1,46:416\n1#2:462\n*S KotlinDebug\n*F\n+ 1 JsonValueDecoder.kt\npbandk/internal/json/JsonValueDecoder\n*L\n122#1:278,46\n125#1:324,46\n128#1:370,46\n131#1:416,46\n*E\n"})
public final class JsonValueDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonConfig jsonConfig;
    private static final float FLOAT_MIN_POSITIVE = 1.175494E-38f;
    private static final float FLOAT_MAX_POSITIVE = Float.MAX_VALUE;
    private static final float FLOAT_MIN_NEGATIVE = -3.402823E38f;
    private static final float FLOAT_MAX_NEGATIVE = -1.175494E-38f;
    private static final double DOUBLE_MIN_POSITIVE = 2.22507E-308;
    private static final double DOUBLE_MAX_POSITIVE = 1.79769E308;
    private static final double DOUBLE_MIN_NEGATIVE = -1.79769E308;
    private static final double DOUBLE_MAX_NEGATIVE = -2.22507E-308;
    @NotNull
    private static final Regex NUMBER_TRAILING_ZEROES = new Regex("\\.0+$");
    @NotNull
    private static final Regex NUMBER_SCIENTIFIC_NOTATION = new Regex("-?\\d+(\\.\\d+?)?0*[eE](\\d+)$");

    public JsonValueDecoder(@NotNull JsonConfig jsonConfig) {
        Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
        this.jsonConfig = jsonConfig;
    }

    @NotNull
    public final JsonConfig getJsonConfig() {
        return this.jsonConfig;
    }

    @Nullable
    public final Object readValue(@NotNull JsonElement value, @NotNull FieldDescriptor.Type type, boolean isMapKey) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        FieldDescriptor.Type type2 = type;
        if (type2 instanceof FieldDescriptor.Type.Primitive.Double) {
            object = this.readDouble(value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Float) {
            object = Float.valueOf(this.readFloat(value));
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int64) {
            object = this.readInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt64) {
            object = this.readUnsignedInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int32) {
            object = this.readInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed64) {
            object = this.readUnsignedInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed32) {
            object = this.readUnsignedInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bool) {
            object = this.readBool(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.String) {
            object = this.readString(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bytes) {
            object = this.readBytes(value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt32) {
            object = this.readUnsignedInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed32) {
            object = this.readInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed64) {
            object = this.readInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt32) {
            object = this.readInteger32(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt64) {
            object = this.readInteger64(value, isMapKey);
        } else if (type2 instanceof FieldDescriptor.Type.Message) {
            Message.Companion companion = ((FieldDescriptor.Type.Message)type).getMessageCompanion$pbandk_runtime();
            if (Intrinsics.areEqual(companion, (Object)DoubleValue.Companion)) {
                object = this.readDouble(value);
            } else if (Intrinsics.areEqual(companion, (Object)FloatValue.Companion)) {
                object = Float.valueOf(this.readFloat(value));
            } else if (Intrinsics.areEqual(companion, (Object)Int64Value.Companion)) {
                object = this.readInteger64(value, isMapKey);
            } else if (Intrinsics.areEqual(companion, (Object)UInt64Value.Companion)) {
                object = this.readUnsignedInteger64(value, isMapKey);
            } else if (Intrinsics.areEqual(companion, (Object)Int32Value.Companion)) {
                object = this.readInteger32(value, isMapKey);
            } else if (Intrinsics.areEqual(companion, (Object)UInt32Value.Companion)) {
                object = this.readUnsignedInteger32(value, isMapKey);
            } else if (Intrinsics.areEqual(companion, (Object)BoolValue.Companion)) {
                object = this.readBool(value, isMapKey);
            } else if (Intrinsics.areEqual(companion, (Object)StringValue.Companion)) {
                object = this.readString(value, isMapKey);
            } else if (Intrinsics.areEqual(companion, (Object)BytesValue.Companion)) {
                object = this.readBytes(value);
            } else {
                object = JsonMessageAdapters.INSTANCE.getAdapter(((FieldDescriptor.Type.Message)type).getMessageCompanion$pbandk_runtime());
                if (object == null || (object = object.decode(value, this)) == null) {
                    object = this.readMessage(value, ((FieldDescriptor.Type.Message)type).getMessageCompanion$pbandk_runtime());
                }
            }
        } else if (type2 instanceof FieldDescriptor.Type.Enum) {
            object = this.readEnum(value, ((FieldDescriptor.Type.Enum)type).getEnumCompanion$pbandk_runtime());
        } else if (type2 instanceof FieldDescriptor.Type.Repeated) {
            object = this.readRepeated(value, ((FieldDescriptor.Type.Repeated)type).getValueType$pbandk_runtime());
        } else if (type2 instanceof FieldDescriptor.Type.Map) {
            object = this.readMap(value, (FieldDescriptor.Type.Map)type);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static /* synthetic */ Object readValue$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, FieldDescriptor.Type type, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readValue(jsonElement, type, bl);
    }

    private final <T> T readIntegerInternal(JsonElement value, boolean isMapKey, Function1<? super String, ? extends T> body) {
        Object object;
        boolean $i$f$readIntegerInternal = false;
        try {
            String content = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Object object2 = StringsKt.getOrNull((CharSequence)content, (int)0);
            Character c = object2;
            char c2 = ' ';
            if (c != null && c.charValue() == c2) {
                throw new NumberFormatException("Integers must not have preceding space");
            }
            Character c3 = object2;
            c2 = '+';
            if (c3 != null && c3.charValue() == c2) {
                throw new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c4 = object2;
            c2 = '-';
            if (c4 != null && c4.charValue() == c2) {
                Character c5 = StringsKt.getOrNull((CharSequence)content, (int)1);
                c2 = '0';
                if (c5 != null && c5.charValue() == c2) {
                    throw new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c6 = object2;
                c2 = '0';
                if (c6 != null && c6.charValue() == c2 && content.length() > 1) {
                    throw new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content) == ' ') {
                throw new NumberFormatException("Integers must not have trailing space");
            }
            try {
                object2 = body.invoke((Object)content);
            }
            catch (NumberFormatException e) {
                String contentExpandedInteger = null;
                CharSequence charSequence = content;
                Regex regex = NUMBER_TRAILING_ZEROES;
                String string = "";
                contentExpandedInteger = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult it = matchResult;
                    boolean bl = false;
                    char[] cArray = new char[]{'.'};
                    String mantissaFraction = StringsKt.trimStart((String)((String)it.getGroupValues().get(1)), (char[])cArray);
                    int mantissaDigits = mantissaFraction.length();
                    boolean isMantissaFractionZero = ((CharSequence)mantissaFraction).length() == 0 || UStringsKt.toULong((String)mantissaFraction) == 0L;
                    long decade = Long.parseLong((String)it.getGroupValues().get(2));
                    if (isMantissaFractionZero || decade >= (long)mantissaDigits) {
                        contentExpandedInteger = String.valueOf((long)Double.parseDouble(contentExpandedInteger));
                    }
                }
                object2 = body.invoke((Object)contentExpandedInteger);
            }
            object = object2;
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("field did not contain a number in JSON", e);
        }
        return (T)object;
    }

    public final int readInteger32(@NotNull JsonElement value, boolean isMapKey) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            int n2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            char c3 = ' ';
            if (c2 != null && c2.charValue() == c3) {
                throw new NumberFormatException("Integers must not have preceding space");
            }
            Character c4 = c;
            c3 = '+';
            if (c4 != null && c4.charValue() == c3) {
                throw new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c5 = c;
            c3 = '-';
            if (c5 != null && c5.charValue() == c3) {
                Character c6 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                c3 = '0';
                if (c6 != null && c6.charValue() == c3) {
                    throw new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c7 = c;
                c3 = '0';
                if (c7 != null && c7.charValue() == c3 && content$iv.length() > 1) {
                    throw new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                n2 = Integer.parseInt(it);
            }
            catch (NumberFormatException e$iv) {
                String contentExpandedInteger$iv = null;
                CharSequence charSequence = content$iv;
                Regex regex = NUMBER_TRAILING_ZEROES;
                String string = "";
                contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult it$iv = matchResult;
                    boolean bl = false;
                    char[] it = new char[]{'.'};
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])it);
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    boolean isMantissaFractionZero$iv = ((CharSequence)mantissaFraction$iv).length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    long decade$iv = Long.parseLong((String)it$iv.getGroupValues().get(2));
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(contentExpandedInteger$iv));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl = false;
                n2 = Integer.parseInt(it);
            }
            n = n2;
        }
        catch (Exception e$iv) {
            throw new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return n;
    }

    public static /* synthetic */ int readInteger32$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readInteger32(jsonElement, bl);
    }

    public final long readInteger64(@NotNull JsonElement value, boolean isMapKey) {
        long l;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            long l2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            char c3 = ' ';
            if (c2 != null && c2.charValue() == c3) {
                throw new NumberFormatException("Integers must not have preceding space");
            }
            Character c4 = c;
            c3 = '+';
            if (c4 != null && c4.charValue() == c3) {
                throw new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c5 = c;
            c3 = '-';
            if (c5 != null && c5.charValue() == c3) {
                Character c6 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                c3 = '0';
                if (c6 != null && c6.charValue() == c3) {
                    throw new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c7 = c;
                c3 = '0';
                if (c7 != null && c7.charValue() == c3 && content$iv.length() > 1) {
                    throw new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                l2 = Long.parseLong(it);
            }
            catch (NumberFormatException e$iv) {
                String contentExpandedInteger$iv = null;
                CharSequence charSequence = content$iv;
                Regex regex = NUMBER_TRAILING_ZEROES;
                String string = "";
                contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult it$iv = matchResult;
                    boolean bl = false;
                    char[] it = new char[]{'.'};
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])it);
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    boolean isMantissaFractionZero$iv = ((CharSequence)mantissaFraction$iv).length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    long decade$iv = Long.parseLong((String)it$iv.getGroupValues().get(2));
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(contentExpandedInteger$iv));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl = false;
                l2 = Long.parseLong(it);
            }
            l = l2;
        }
        catch (Exception e$iv) {
            throw new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return l;
    }

    public static /* synthetic */ long readInteger64$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readInteger64(jsonElement, bl);
    }

    public final int readUnsignedInteger32(@NotNull JsonElement value, boolean isMapKey) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            int n2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            char c3 = ' ';
            if (c2 != null && c2.charValue() == c3) {
                throw new NumberFormatException("Integers must not have preceding space");
            }
            Character c4 = c;
            c3 = '+';
            if (c4 != null && c4.charValue() == c3) {
                throw new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c5 = c;
            c3 = '-';
            if (c5 != null && c5.charValue() == c3) {
                Character c6 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                c3 = '0';
                if (c6 != null && c6.charValue() == c3) {
                    throw new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c7 = c;
                c3 = '0';
                if (c7 != null && c7.charValue() == c3 && content$iv.length() > 1) {
                    throw new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                n2 = UStringsKt.toUInt((String)it);
            }
            catch (NumberFormatException e$iv) {
                String contentExpandedInteger$iv = null;
                CharSequence charSequence = content$iv;
                Regex regex = NUMBER_TRAILING_ZEROES;
                String string = "";
                contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult it$iv = matchResult;
                    boolean bl = false;
                    char[] it = new char[]{'.'};
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])it);
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    boolean isMantissaFractionZero$iv = ((CharSequence)mantissaFraction$iv).length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    long decade$iv = Long.parseLong((String)it$iv.getGroupValues().get(2));
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(contentExpandedInteger$iv));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl = false;
                n2 = UStringsKt.toUInt((String)it);
            }
            n = n2;
        }
        catch (Exception e$iv) {
            throw new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return n;
    }

    public static /* synthetic */ int readUnsignedInteger32$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readUnsignedInteger32(jsonElement, bl);
    }

    public final long readUnsignedInteger64(@NotNull JsonElement value, boolean isMapKey) {
        long l;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonValueDecoder this_$iv = this;
        boolean $i$f$readIntegerInternal = false;
        try {
            long l2;
            Character c;
            String content$iv = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
            Character c2 = c = StringsKt.getOrNull((CharSequence)content$iv, (int)0);
            char c3 = ' ';
            if (c2 != null && c2.charValue() == c3) {
                throw new NumberFormatException("Integers must not have preceding space");
            }
            Character c4 = c;
            c3 = '+';
            if (c4 != null && c4.charValue() == c3) {
                throw new NumberFormatException("Positive integers must not include the '+' sign");
            }
            Character c5 = c;
            c3 = '-';
            if (c5 != null && c5.charValue() == c3) {
                Character c6 = StringsKt.getOrNull((CharSequence)content$iv, (int)1);
                c3 = '0';
                if (c6 != null && c6.charValue() == c3) {
                    throw new NumberFormatException("Negative integers with leading zeros are not allowed");
                }
            } else {
                Character c7 = c;
                c3 = '0';
                if (c7 != null && c7.charValue() == c3 && content$iv.length() > 1) {
                    throw new NumberFormatException("Integers with leading zeros are not allowed");
                }
            }
            if (StringsKt.last((CharSequence)content$iv) == ' ') {
                throw new NumberFormatException("Integers must not have trailing space");
            }
            try {
                String it = content$iv;
                boolean bl = false;
                l2 = UStringsKt.toULong((String)it);
            }
            catch (NumberFormatException e$iv) {
                String contentExpandedInteger$iv = null;
                CharSequence charSequence = content$iv;
                Regex regex = NUMBER_TRAILING_ZEROES;
                String string = "";
                contentExpandedInteger$iv = regex.replace(charSequence, string);
                MatchResult matchResult = Regex.find$default((Regex)NUMBER_SCIENTIFIC_NOTATION, (CharSequence)contentExpandedInteger$iv, (int)0, (int)2, null);
                if (matchResult != null) {
                    MatchResult it$iv = matchResult;
                    boolean bl = false;
                    char[] it = new char[]{'.'};
                    String mantissaFraction$iv = StringsKt.trimStart((String)((String)it$iv.getGroupValues().get(1)), (char[])it);
                    int mantissaDigits$iv = mantissaFraction$iv.length();
                    boolean isMantissaFractionZero$iv = ((CharSequence)mantissaFraction$iv).length() == 0 || UStringsKt.toULong((String)mantissaFraction$iv) == 0L;
                    long decade$iv = Long.parseLong((String)it$iv.getGroupValues().get(2));
                    if (isMantissaFractionZero$iv || decade$iv >= (long)mantissaDigits$iv) {
                        contentExpandedInteger$iv = String.valueOf((long)Double.parseDouble(contentExpandedInteger$iv));
                    }
                }
                String it = contentExpandedInteger$iv;
                boolean bl = false;
                l2 = UStringsKt.toULong((String)it);
            }
            l = l2;
        }
        catch (Exception e$iv) {
            throw new InvalidProtocolBufferException("field did not contain a number in JSON", e$iv);
        }
        return l;
    }

    public static /* synthetic */ long readUnsignedInteger64$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readUnsignedInteger64(jsonElement, bl);
    }

    public final boolean readBool(@NotNull JsonElement value, boolean isMapKey) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!isMapKey && value instanceof JsonPrimitive && ((JsonPrimitive)value).isString()) {
            throw new InvalidProtocolBufferException("bool field must not be quoted in JSON");
        }
        String string = JsonElementKt.getJsonPrimitive((JsonElement)value).getContent();
        if (Intrinsics.areEqual((Object)string, (Object)"true")) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"false")) {
            bl = false;
        } else {
            throw new InvalidProtocolBufferException("bool field did not contain a boolean value in JSON");
        }
        return bl;
    }

    public static /* synthetic */ boolean readBool$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readBool(jsonElement, bl);
    }

    @Nullable
    public final Message.Enum readEnum(@NotNull JsonElement value, @NotNull Message.Enum.Companion<?> enumCompanion) {
        Message.Enum enum_;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(enumCompanion, (String)"enumCompanion");
        try {
            JsonPrimitive p = JsonElementKt.getJsonPrimitive((JsonElement)value);
            Integer n = JsonElementKt.getIntOrNull((JsonPrimitive)p);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                return enumCompanion.fromValue(it);
            }
            if (!p.isString()) {
                boolean bl = false;
                String string = "Non-numeric enum values must be quoted";
                throw new IllegalArgumentException(string.toString());
            }
            enum_ = (Message.Enum)enumCompanion.fromName(p.getContent());
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException) || !this.jsonConfig.getIgnoreUnknownFieldsInInput()) {
                throw new InvalidProtocolBufferException("enum field did not contain a number or valid enum value", e);
            }
            enum_ = null;
        }
        return enum_;
    }

    public final float readFloat(@NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            block20: {
                if (!(value instanceof JsonPrimitive) || !((JsonPrimitive)value).isString()) break block20;
                switch (((JsonPrimitive)value).getContent()) {
                    case "Infinity": {
                        return Float.POSITIVE_INFINITY;
                    }
                    case "-Infinity": {
                        return Float.NEGATIVE_INFINITY;
                    }
                    case "NaN": {
                        return Float.NaN;
                    }
                }
            }
            float floatValue = JsonElementKt.getFloat((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
            float f = floatValue;
            if (!(!Float.isInfinite(f) && !Float.isNaN(f))) {
                throw new NumberFormatException("value out of bounds");
            }
            if ((double)floatValue > 0.0) {
                if (!(1.175494E-38f <= floatValue ? floatValue <= Float.MAX_VALUE : false)) {
                    throw new NumberFormatException("value out of bounds");
                }
            }
            if ((double)floatValue < 0.0) {
                if (!(-3.402823E38f <= floatValue ? floatValue <= -1.175494E-38f : false)) {
                    throw new NumberFormatException("value out of bounds");
                }
            }
            return floatValue;
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("float field did not contain a float value in JSON", e);
        }
    }

    public final double readDouble(@NotNull JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            block20: {
                if (!(value instanceof JsonPrimitive) || !((JsonPrimitive)value).isString()) break block20;
                switch (((JsonPrimitive)value).getContent()) {
                    case "Infinity": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-Infinity": {
                        return Double.NEGATIVE_INFINITY;
                    }
                    case "NaN": {
                        return Double.NaN;
                    }
                }
            }
            double doubleValue = JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
            double d = doubleValue;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                throw new NumberFormatException("value out of bounds");
            }
            if (doubleValue > 0.0) {
                if (!(2.22507E-308 <= doubleValue ? doubleValue <= 1.79769E308 : false)) {
                    throw new NumberFormatException("value out of bounds");
                }
            }
            if (doubleValue < 0.0) {
                if (!(-1.79769E308 <= doubleValue ? doubleValue <= -2.22507E-308 : false)) {
                    throw new NumberFormatException("value out of bounds");
                }
            }
            return doubleValue;
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("double field did not contain a double value in JSON", e);
        }
    }

    @NotNull
    public final String readString(@NotNull JsonElement value, boolean isMapKey) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            if (!(value instanceof JsonPrimitive && ((JsonPrimitive)value).isString())) {
                boolean $i$a$-require-JsonValueDecoder$readString$22 = false;
                String $i$a$-require-JsonValueDecoder$readString$22 = "string field wasn't quoted";
                throw new IllegalArgumentException($i$a$-require-JsonValueDecoder$readString$22.toString());
            }
            string = ((JsonPrimitive)value).getContent();
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("string field did not contain a string value in JSON", e);
        }
        return string;
    }

    public static /* synthetic */ String readString$default(JsonValueDecoder jsonValueDecoder, JsonElement jsonElement, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jsonValueDecoder.readString(jsonElement, bl);
    }

    @NotNull
    public final ByteArr readBytes(@NotNull JsonElement value) {
        ByteArr byteArr;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            byteArr = new ByteArr(Util_jvmKt.getPlatformUtil().base64ToBytes(JsonElementKt.getJsonPrimitive((JsonElement)value).getContent()));
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("bytes field did not contain a base64-encoded string value in JSON", e);
        }
        return byteArr;
    }

    @NotNull
    public final Message readMessage(@NotNull JsonElement value, @NotNull Message.Companion<?> messageCompanion) {
        Object obj;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(messageCompanion, (String)"messageCompanion");
        try {
            obj = messageCompanion.decodeWith(new JsonMessageDecoder(value, this.jsonConfig));
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("message field did not contain a valid message", e);
        }
        return obj;
    }

    @NotNull
    public final Sequence<?> readRepeated(@NotNull JsonElement value, @NotNull FieldDescriptor.Type valueType) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        try {
            sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)JsonElementKt.getJsonArray((JsonElement)value))), arg_0 -> JsonValueDecoder.readRepeated$lambda$8(this, valueType, arg_0));
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("repeated field did not contain a valid list", e);
        }
        return sequence;
    }

    @NotNull
    public final Sequence<Map.Entry<?, ?>> readMap(@NotNull JsonElement value, @NotNull FieldDescriptor.Type.Map<?, ?> type) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        try {
            sequence = SequencesKt.mapNotNull((Sequence)MapsKt.asSequence((Map)((Map)JsonElementKt.getJsonObject((JsonElement)value))), arg_0 -> JsonValueDecoder.readMap$lambda$10(this, type, arg_0));
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidProtocolBufferException("map field did not contain a valid object", e);
        }
        return sequence;
    }

    private static final Object readRepeated$lambda$8(JsonValueDecoder this$0, FieldDescriptor.Type $valueType, JsonElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JsonValueDecoder.readValue$default(this$0, it, $valueType, false, 4, null);
    }

    private static final MessageMap.Entry readMap$lambda$10(JsonValueDecoder this$0, FieldDescriptor.Type.Map $type, Map.Entry entry) {
        MessageMap.Entry entry2;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String k = (String)entry.getKey();
        JsonElement v = (JsonElement)entry.getValue();
        Object entryKey = this$0.readValue((JsonElement)JsonElementKt.JsonPrimitive((String)k), $type.getEntryCompanion$pbandk_runtime().getKeyType$pbandk_runtime(), true);
        Object object = JsonValueDecoder.readValue$default(this$0, v, $type.getEntryCompanion$pbandk_runtime().getValueType$pbandk_runtime(), false, 4, null);
        if (object != null) {
            Object entryValue = object;
            boolean bl = false;
            MessageMap.Entry.Companion companion = $type.getEntryCompanion$pbandk_runtime();
            Intrinsics.checkNotNull(companion, (String)"null cannot be cast to non-null type pbandk.MessageMap.Entry.Companion<kotlin.Any?, kotlin.Any?>");
            entry2 = new MessageMap.Entry(entryKey, entryValue, companion, null, 8, null);
        } else {
            entry2 = null;
        }
        return entry2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lpbandk/internal/json/JsonValueDecoder$Companion;", "", "<init>", "()V", "FLOAT_MIN_POSITIVE", "", "FLOAT_MAX_POSITIVE", "FLOAT_MIN_NEGATIVE", "FLOAT_MAX_NEGATIVE", "DOUBLE_MIN_POSITIVE", "", "DOUBLE_MAX_POSITIVE", "DOUBLE_MIN_NEGATIVE", "DOUBLE_MAX_NEGATIVE", "NUMBER_TRAILING_ZEROES", "Lkotlin/text/Regex;", "NUMBER_SCIENTIFIC_NOTATION", "pbandk-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

