/*
 * Decompiled with CFR 0.152.
 */
package pbandk.internal.json;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import pbandk.ByteArr;
import pbandk.FieldDescriptor;
import pbandk.Message;
import pbandk.internal.Util_jvmKt;
import pbandk.internal.json.JsonMessageEncoder;
import pbandk.json.JsonConfig;
import pbandk.wkt.BoolValue;
import pbandk.wkt.BytesValue;
import pbandk.wkt.DoubleValue;
import pbandk.wkt.FloatValue;
import pbandk.wkt.Int32Value;
import pbandk.wkt.Int64Value;
import pbandk.wkt.NullValue;
import pbandk.wkt.StringValue;
import pbandk.wkt.UInt32Value;
import pbandk.wkt.UInt64Value;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020 J\u001a\u0010!\u001a\u00020\t2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020\fJ&\u0010%\u001a\u00020\t2\u000e\u0010&\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010(\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lpbandk/internal/json/JsonValueEncoder;", "", "jsonConfig", "Lpbandk/json/JsonConfig;", "<init>", "(Lpbandk/json/JsonConfig;)V", "getJsonConfig", "()Lpbandk/json/JsonConfig;", "writeValue", "Lkotlinx/serialization/json/JsonElement;", "value", "type", "Lpbandk/FieldDescriptor$Type;", "writeInteger32", "", "writeInteger64", "", "writeUnsignedInteger32", "writeUnsignedInteger64", "writeBool", "", "writeEnum", "Lpbandk/Message$Enum;", "writeFloat", "", "writeDouble", "", "writeString", "", "writeBytes", "Lpbandk/ByteArr;", "writeMessage", "Lpbandk/Message;", "writeRepeated", "list", "", "valueType", "writeMap", "map", "", "keyType", "pbandk-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonValueEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonValueEncoder.kt\npbandk/internal/json/JsonValueEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,130:1\n1#2:131\n52#3,3:132\n29#3,3:135\n*S KotlinDebug\n*F\n+ 1 JsonValueEncoder.kt\npbandk/internal/json/JsonValueEncoder\n*L\n113#1:132,3\n124#1:135,3\n*E\n"})
public final class JsonValueEncoder {
    @NotNull
    private final JsonConfig jsonConfig;

    public JsonValueEncoder(@NotNull JsonConfig jsonConfig) {
        Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
        this.jsonConfig = jsonConfig;
    }

    @NotNull
    public final JsonConfig getJsonConfig() {
        return this.jsonConfig;
    }

    @NotNull
    public final JsonElement writeValue(@NotNull Object value, @NotNull FieldDescriptor.Type type) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        FieldDescriptor.Type type2 = type;
        if (type2 instanceof FieldDescriptor.Type.Primitive.Double) {
            jsonElement = this.writeDouble((Double)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Float) {
            jsonElement = this.writeFloat(((Float)value).floatValue());
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int64) {
            jsonElement = this.writeInteger64((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt64) {
            jsonElement = this.writeUnsignedInteger64((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Int32) {
            jsonElement = this.writeInteger32((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed64) {
            jsonElement = this.writeUnsignedInteger64((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Fixed32) {
            jsonElement = this.writeUnsignedInteger32((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bool) {
            jsonElement = this.writeBool((Boolean)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.String) {
            jsonElement = this.writeString((String)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.Bytes) {
            jsonElement = this.writeBytes((ByteArr)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.UInt32) {
            jsonElement = this.writeUnsignedInteger32((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed32) {
            jsonElement = this.writeInteger32((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SFixed64) {
            jsonElement = this.writeInteger64((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt32) {
            jsonElement = this.writeInteger32((Integer)value);
        } else if (type2 instanceof FieldDescriptor.Type.Primitive.SInt64) {
            jsonElement = this.writeInteger64((Long)value);
        } else if (type2 instanceof FieldDescriptor.Type.Message) {
            Message.Companion companion = ((FieldDescriptor.Type.Message)type).getMessageCompanion$pbandk_runtime();
            jsonElement = Intrinsics.areEqual(companion, (Object)DoubleValue.Companion) ? this.writeDouble((Double)value) : (Intrinsics.areEqual(companion, (Object)FloatValue.Companion) ? this.writeFloat(((Float)value).floatValue()) : (Intrinsics.areEqual(companion, (Object)Int64Value.Companion) ? this.writeInteger64((Long)value) : (Intrinsics.areEqual(companion, (Object)UInt64Value.Companion) ? this.writeUnsignedInteger64((Long)value) : (Intrinsics.areEqual(companion, (Object)Int32Value.Companion) ? this.writeInteger32((Integer)value) : (Intrinsics.areEqual(companion, (Object)UInt32Value.Companion) ? this.writeUnsignedInteger32((Integer)value) : (Intrinsics.areEqual(companion, (Object)BoolValue.Companion) ? this.writeBool((Boolean)value) : (Intrinsics.areEqual(companion, (Object)StringValue.Companion) ? this.writeString((String)value) : (Intrinsics.areEqual(companion, (Object)BytesValue.Companion) ? this.writeBytes((ByteArr)value) : this.writeMessage((Message)value)))))))));
        } else if (type2 instanceof FieldDescriptor.Type.Enum) {
            jsonElement = ((FieldDescriptor.Type.Enum)type).getEnumCompanion$pbandk_runtime() instanceof NullValue ? (JsonElement)JsonNull.INSTANCE : this.writeEnum((Message.Enum)value);
        } else if (type2 instanceof FieldDescriptor.Type.Repeated) {
            jsonElement = this.writeRepeated((List)value, ((FieldDescriptor.Type.Repeated)type).getValueType$pbandk_runtime());
        } else if (type2 instanceof FieldDescriptor.Type.Map) {
            jsonElement = this.writeMap((Map)value, ((FieldDescriptor.Type.Map)type).getEntryCompanion$pbandk_runtime().getKeyType$pbandk_runtime(), ((FieldDescriptor.Type.Map)type).getEntryCompanion$pbandk_runtime().getValueType$pbandk_runtime());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonElement;
    }

    @NotNull
    public final JsonElement writeInteger32(int value) {
        return (JsonElement)JsonElementKt.JsonPrimitive((Number)value);
    }

    @NotNull
    public final JsonElement writeInteger64(long value) {
        return (JsonElement)JsonElementKt.JsonPrimitive((String)String.valueOf(value));
    }

    @NotNull
    public final JsonElement writeUnsignedInteger32(int value) {
        return value < 0 ? (JsonElement)JsonElementKt.JsonPrimitive((String)Integer.toUnsignedString(UInt.constructor-impl((int)value))) : (JsonElement)JsonElementKt.JsonPrimitive((Number)value);
    }

    @NotNull
    public final JsonElement writeUnsignedInteger64(long value) {
        return (JsonElement)JsonElementKt.JsonPrimitive((String)Long.toUnsignedString(ULong.constructor-impl((long)value)));
    }

    @NotNull
    public final JsonElement writeBool(boolean value) {
        return (JsonElement)JsonElementKt.JsonPrimitive((Boolean)value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final JsonElement writeEnum(@NotNull Message.Enum value) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.getName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            JsonPrimitive jsonPrimitive = JsonElementKt.JsonPrimitive((String)it);
            string = jsonPrimitive;
            if (jsonPrimitive != null) {
                jsonElement = (JsonElement)string;
                return jsonElement;
            }
        }
        jsonElement = (JsonElement)JsonElementKt.JsonPrimitive((Number)value.getValue());
        return jsonElement;
    }

    @NotNull
    public final JsonElement writeFloat(float value) {
        float f = value;
        return !Float.isInfinite(f) && !Float.isNaN(f) ? (JsonElement)JsonElementKt.JsonPrimitive((Number)Float.valueOf(value)) : (JsonElement)JsonElementKt.JsonPrimitive((String)String.valueOf(value));
    }

    @NotNull
    public final JsonElement writeDouble(double value) {
        double d = value;
        return !Double.isInfinite(d) && !Double.isNaN(d) ? (JsonElement)JsonElementKt.JsonPrimitive((Number)value) : (JsonElement)JsonElementKt.JsonPrimitive((String)String.valueOf(value));
    }

    @NotNull
    public final JsonElement writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (JsonElement)JsonElementKt.JsonPrimitive((String)value);
    }

    @NotNull
    public final JsonElement writeBytes(@NotNull ByteArr value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (JsonElement)JsonElementKt.JsonPrimitive((String)Util_jvmKt.getPlatformUtil().bytesToBase64(value.getArray()));
    }

    @NotNull
    public final JsonElement writeMessage(@NotNull Message value) {
        JsonMessageEncoder jsonMessageEncoder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonMessageEncoder it = jsonMessageEncoder = new JsonMessageEncoder(this.jsonConfig);
        boolean bl = false;
        it.writeMessage(value);
        return jsonMessageEncoder.toJsonElement$pbandk_runtime();
    }

    @NotNull
    public final JsonElement writeRepeated(@NotNull List<?> list, @NotNull FieldDescriptor.Type valueType) {
        JsonArrayBuilder builder$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        boolean $i$f$buildJsonArray = false;
        JsonArrayBuilder $this$writeRepeated_u24lambda_u242 = builder$iv = new JsonArrayBuilder();
        boolean bl = false;
        for (Object v : list) {
            if (v == null) continue;
            $this$writeRepeated_u24lambda_u242.add(this.writeValue(v, valueType));
        }
        return (JsonElement)builder$iv.build();
    }

    @NotNull
    public final JsonElement writeMap(@NotNull Map<?, ?> map, @NotNull FieldDescriptor.Type keyType, @NotNull FieldDescriptor.Type valueType) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$writeMap_u24lambda_u243 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k == null || v == null) continue;
            $this$writeMap_u24lambda_u243.put(JsonElementKt.getJsonPrimitive((JsonElement)this.writeValue(k, keyType)).getContent(), this.writeValue(v, valueType));
        }
        return (JsonElement)builder$iv.build();
    }
}

