package pro.streem.ar.sceneform;

import com.google.ar.core.Pose;
import pro.streem.ar.sceneform.math.Quaternion;
import pro.streem.ar.sceneform.math.Vector3;

/** Helper class for utility functions for interacting with the ARCore API. */
class ArHelpers {
  /** Returns a Sceneform {@link Vector3} representing the position from an ARCore {@link Pose}. */
  static Vector3 extractPositionFromPose(Pose pose) {
    return new Vector3(pose.tx(), pose.ty(), pose.tz());
  }

  /**
   * Returns a Sceneform {@link Quaternion} representing the rotation from an ARCore {@link Pose}.
   */
  static Quaternion extractRotationFromPose(Pose pose) {
    return new Quaternion(pose.qx(), pose.qy(), pose.qz(), pose.qw());
  }
}
