/*
 * Decompiled with CFR 0.152.
 */
package pro.streem.sdk;

import com.nimbusds.jose.jwk.ECKey;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.text.ParseException;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\tH\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lpro/streem/sdk/Config;", "", "apiKeyId", "", "apiKeySecret", "apiEnvironment", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/nimbusds/jose/jwk/ECKey;", "apiEndpoint", "Ljava/net/URI;", "(Ljava/lang/String;Lcom/nimbusds/jose/jwk/ECKey;Ljava/net/URI;)V", "getApiEndpoint", "()Ljava/net/URI;", "getApiKeyId", "()Ljava/lang/String;", "getApiKeySecret", "()Lcom/nimbusds/jose/jwk/ECKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "streem-server-sdk"})
public final class Config {
    @NotNull
    private final String apiKeyId;
    @NotNull
    private final ECKey apiKeySecret;
    @NotNull
    private final URI apiEndpoint;

    public Config(@NotNull String apiKeyId, @NotNull ECKey apiKeySecret, @NotNull URI apiEndpoint) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)apiKeySecret, (String)"apiKeySecret");
        Intrinsics.checkNotNullParameter((Object)apiEndpoint, (String)"apiEndpoint");
        this.apiKeyId = apiKeyId;
        this.apiKeySecret = apiKeySecret;
        this.apiEndpoint = apiEndpoint;
        if (!this.apiKeySecret.isPrivate()) {
            boolean bl = false;
            String string = "apiKeySecret is missing private key information";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getApiKeyId() {
        return this.apiKeyId;
    }

    @NotNull
    public final ECKey getApiKeySecret() {
        return this.apiKeySecret;
    }

    @NotNull
    public final URI getApiEndpoint() {
        return this.apiEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    public Config(@NotNull String apiKeyId, @NotNull String apiKeySecret, @NotNull String apiEnvironment) throws IllegalArgumentException {
        Object object;
        String string;
        Config config;
        Object object2;
        String string2;
        Config config2;
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)apiKeySecret, (String)"apiKeySecret");
        Intrinsics.checkNotNullParameter((Object)apiEnvironment, (String)"apiEnvironment");
        String string3 = apiKeyId;
        Config config3 = this;
        try {
            config2 = config3;
            string2 = string3;
            object2 = Base64.getDecoder().decode(apiKeySecret);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getDecoder().decode(apiKeySecret)");
            object2 = ECKey.parse((String)StringsKt.decodeToString$default((byte[])object2, (int)0, (int)0, (boolean)true, (int)3, null));
        }
        catch (CharacterCodingException characterCodingException) {
            void e;
            Config config4 = config3;
            String string4 = string3;
            throw new IllegalArgumentException("apiKeySecret contains invalid UTF-8", (Throwable)e);
        }
        catch (ParseException e) {
            Config config5 = config3;
            String string5 = string3;
            throw new IllegalArgumentException("apiKeySecret does not contain a JWK after base64-decoding", e);
        }
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"try {\n            ECKey.\u20264-decoding\", e)\n        }");
        Object object4 = object3;
        string3 = string2;
        config3 = config2;
        try {
            config = config3;
            string = string3;
            object = object4;
            object3 = new URI("https", "api." + apiEnvironment + ".streem.cloud", "/", null);
        }
        catch (URISyntaxException uRISyntaxException) {
            void e;
            Config config6 = config3;
            String string6 = string3;
            Object object5 = object4;
            throw new IllegalArgumentException("apiEnvironment contains invalid characters", (Throwable)e);
        }
        config(string, (ECKey)object, (URI)object3);
    }

    @NotNull
    public final String component1() {
        return this.apiKeyId;
    }

    @NotNull
    public final ECKey component2() {
        return this.apiKeySecret;
    }

    @NotNull
    public final URI component3() {
        return this.apiEndpoint;
    }

    @NotNull
    public final Config copy(@NotNull String apiKeyId, @NotNull ECKey apiKeySecret, @NotNull URI apiEndpoint) {
        Intrinsics.checkNotNullParameter((Object)apiKeyId, (String)"apiKeyId");
        Intrinsics.checkNotNullParameter((Object)apiKeySecret, (String)"apiKeySecret");
        Intrinsics.checkNotNullParameter((Object)apiEndpoint, (String)"apiEndpoint");
        return new Config(apiKeyId, apiKeySecret, apiEndpoint);
    }

    public static /* synthetic */ Config copy$default(Config config, String string, ECKey eCKey, URI uRI, int n, Object object) {
        if ((n & 1) != 0) {
            string = config.apiKeyId;
        }
        if ((n & 2) != 0) {
            eCKey = config.apiKeySecret;
        }
        if ((n & 4) != 0) {
            uRI = config.apiEndpoint;
        }
        return config.copy(string, eCKey, uRI);
    }

    @NotNull
    public String toString() {
        return "Config(apiKeyId=" + this.apiKeyId + ", apiKeySecret=" + this.apiKeySecret + ", apiEndpoint=" + this.apiEndpoint + ")";
    }

    public int hashCode() {
        int result = this.apiKeyId.hashCode();
        result = result * 31 + this.apiKeySecret.hashCode();
        result = result * 31 + this.apiEndpoint.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Config)) {
            return false;
        }
        Config config = (Config)other;
        if (!Intrinsics.areEqual((Object)this.apiKeyId, (Object)config.apiKeyId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiKeySecret, (Object)config.apiKeySecret)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.apiEndpoint, (Object)config.apiEndpoint);
    }
}

