/*
 * Decompiled with CFR 0.152.
 */
package pro.streem.sdk;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pro.streem.sdk.Config;
import pro.streem.sdk.StreemToken;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"STREEM_TOKEN_ISSUER_PREFIX", "", "serialize", "Lpro/streem/sdk/StreemToken;", "config", "Lpro/streem/sdk/Config;", "streem-server-sdk"})
public final class StreemTokenKt {
    @NotNull
    private static final String STREEM_TOKEN_ISSUER_PREFIX = "streem:api:";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String serialize(@NotNull StreemToken $this$serialize, @NotNull Config config) {
        Object it;
        void $this$serialize_u24lambda_u2d3;
        JWTClaimsSet.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$serialize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JWTClaimsSet.Builder builder2 = builder = new JWTClaimsSet.Builder();
        JWSHeader jWSHeader = new JWSHeader.Builder(JWSAlgorithm.ES256).build();
        boolean bl = false;
        $this$serialize_u24lambda_u2d3.issuer(STREEM_TOKEN_ISSUER_PREFIX + config.getApiKeyId());
        $this$serialize_u24lambda_u2d3.subject($this$serialize.getUserId());
        $this$serialize_u24lambda_u2d3.audience(config.getApiEndpoint().toString());
        $this$serialize_u24lambda_u2d3.issueTime(Date.from(Instant.now()));
        $this$serialize_u24lambda_u2d3.expirationTime(Date.from(Instant.now().plus($this$serialize.getTokenExpiration())));
        $this$serialize_u24lambda_u2d3.claim("session_exp", (Object)Date.from(Instant.now().plus($this$serialize.getSessionExpiration())));
        String string = $this$serialize.getName();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$serialize_u24lambda_u2d3.claim("name", it);
        }
        String string2 = $this$serialize.getEmail();
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$serialize_u24lambda_u2d3.claim("email", it);
        }
        URI uRI = $this$serialize.getAvatarUri();
        if (uRI != null) {
            it = uRI;
            boolean bl4 = false;
            $this$serialize_u24lambda_u2d3.claim("picture", (Object)((URI)it).toString());
        }
        JWTClaimsSet jWTClaimsSet = builder.build();
        JWSHeader jWSHeader2 = jWSHeader;
        JWTClaimsSet.Builder $this$serialize_u24lambda_u2d4 = builder = new SignedJWT(jWSHeader2, jWTClaimsSet);
        boolean bl5 = false;
        try {
            ECDSASigner eCDSASigner;
            JWTClaimsSet.Builder builder3;
            JWTClaimsSet.Builder builder4 = $this$serialize_u24lambda_u2d4;
            try {
                builder3 = builder4;
                eCDSASigner = new ECDSASigner(config.getApiKeySecret());
            }
            catch (JOSEException it2) {
                void e;
                JWTClaimsSet.Builder builder5 = builder4;
                throw new IllegalStateException("apiKeySecret could not be used for signing", (Throwable)e);
            }
            builder3.sign((JWSSigner)eCDSASigner);
        }
        catch (JOSEException e) {
            throw new RuntimeException("Error signing token", e);
        }
        String string3 = builder.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SignedJWT(\n    JWSHeader\u2026\", e)\n    }\n}.serialize()");
        return string3;
    }
}

