/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.loghistory.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;

public class LogfileHistoryServiceImpl
implements TaskanaHistory {
    public static final String TASKANA_HISTORY_LOGGER_NAME = "taskana.historylogger.name";
    private static final Logger LOGGER;
    private static final String JSON_EXCEPTION = "Caught exception while serializing history event to JSON ";
    private ObjectMapper objectMapper;
    private Logger historyLogger;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        LogfileHistoryServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LogfileHistoryServiceImpl.class);
    }

    public void initialize(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());
        String historyLoggerName = taskanaEngine.getConfiguration().readPropertiesFromFile().getProperty(TASKANA_HISTORY_LOGGER_NAME);
        this.historyLogger = historyLoggerName != null ? LoggerFactory.getLogger((String)historyLoggerName) : LOGGER;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LogfileHistoryServiceProvider initialized with name: {} ", (Object)this.historyLogger.getName());
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(TaskHistoryEvent event) {
        TaskHistoryEvent taskHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (this.historyLogger.isInfoEnabled()) {
                this.historyLogger.info(this.objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (JsonProcessingException e) {
            throw new SystemException(JSON_EXCEPTION, (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(WorkbasketHistoryEvent event) {
        WorkbasketHistoryEvent workbasketHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasketHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (this.historyLogger.isInfoEnabled()) {
                this.historyLogger.info(this.objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (JsonProcessingException e) {
            throw new SystemException(JSON_EXCEPTION, (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(ClassificationHistoryEvent event) {
        ClassificationHistoryEvent classificationHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)classificationHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (this.historyLogger.isInfoEnabled()) {
                this.historyLogger.info(this.objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (JsonProcessingException e) {
            throw new SystemException(JSON_EXCEPTION, (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void deleteHistoryEventsByTaskIds(List<String> taskIds) {
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException("HistoryLogger is not supposed to delete events");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LogfileHistoryServiceImpl.java", LogfileHistoryServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 27);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent", "event", "", "void"), 50);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent", "event", "", "void"), 62);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent", "event", "", "void"), 74);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteHistoryEventsByTaskIds", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "java.util.List", "taskIds", "", "void"), 86);
    }
}

