/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.loghistory.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.internal.logging.LoggingAspect;
import pro.taskana.spi.history.api.TaskanaHistory;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent;

public class LogfileHistoryServiceImpl
implements TaskanaHistory {
    private static final Logger LOGGER;
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_HISTORYLOGGER_NAME = "taskana.historylogger.name";
    private static final String JSON_EXCEPTION = "Caught exception while serializing history event to JSON ";
    private static Logger historyLogger;
    ObjectMapper objectMapper = new ObjectMapper();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        LogfileHistoryServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(LogfileHistoryServiceImpl.class);
    }

    public void initialize(TaskanaEngine taskanaEngine) {
        TaskanaEngine taskanaEngine2 = taskanaEngine;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)taskanaEngine2);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        String historyLoggerName = this.readPropertiesFromFile(TASKANA_PROPERTIES).getProperty(TASKANA_HISTORYLOGGER_NAME);
        historyLogger = historyLoggerName != null ? LoggerFactory.getLogger((String)historyLoggerName) : LOGGER;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LogfileHistoryServiceProvider initialized with name: {} ", (Object)historyLogger.getName());
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(TaskHistoryEvent event) {
        TaskHistoryEvent taskHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)taskHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (historyLogger.isInfoEnabled()) {
                historyLogger.info(this.objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (JsonProcessingException e) {
            throw new SystemException(JSON_EXCEPTION, (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(WorkbasketHistoryEvent event) {
        WorkbasketHistoryEvent workbasketHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)workbasketHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (historyLogger.isInfoEnabled()) {
                historyLogger.info(this.objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (JsonProcessingException e) {
            throw new SystemException(JSON_EXCEPTION, (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void create(ClassificationHistoryEvent event) {
        ClassificationHistoryEvent classificationHistoryEvent = event;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)classificationHistoryEvent);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        try {
            if (historyLogger.isInfoEnabled()) {
                historyLogger.info(this.objectMapper.writeValueAsString((Object)event));
            }
        }
        catch (JsonProcessingException e) {
            throw new SystemException(JSON_EXCEPTION, (Throwable)e);
        }
        Object var5_5 = null;
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, var5_5);
    }

    public void deleteHistoryEventsByTaskIds(List<String> taskIds) {
        List<String> list = taskIds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, list);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        throw new UnsupportedOperationException("HistoryLogger is not supposed to delete events");
    }

    private Properties readPropertiesFromFile(String propertiesFile) {
        Properties properties;
        Properties properties2;
        Properties props;
        JoinPoint joinPoint;
        block16: {
            String string = propertiesFile;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
            LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
            props = new Properties();
            boolean loadFromClasspath = this.loadFromClasspath(propertiesFile);
            try {
                if (loadFromClasspath) {
                    InputStream inputStream = TaskanaEngineConfiguration.class.getResourceAsStream(propertiesFile);
                    if (inputStream == null) {
                        LOGGER.error("taskana properties file {} was not found on classpath.", (Object)propertiesFile);
                    } else {
                        props.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("properties were loaded from file {} from classpath.", (Object)propertiesFile);
                        }
                    }
                    break block16;
                }
                Throwable inputStream = null;
                Object var5_10 = null;
                try (FileInputStream stream = new FileInputStream(propertiesFile);){
                    props.load(stream);
                }
                catch (Throwable throwable) {
                    if (inputStream == null) {
                        inputStream = throwable;
                    } else if (inputStream != throwable) {
                        inputStream.addSuppressed(throwable);
                    }
                    throw inputStream;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("properties were loaded from file {}.", (Object)propertiesFile);
                }
            }
            catch (IOException e) {
                LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
                throw new SystemException("internal System error when processing properties file " + propertiesFile, e.getCause());
            }
        }
        Properties properties3 = properties2 = (properties = props);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, (Object)properties2);
        return properties;
    }

    private boolean loadFromClasspath(String propertiesFile) {
        boolean bl;
        boolean bl2;
        String string = propertiesFile;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        LoggingAspect.aspectOf().beforeMethodExecuted(joinPoint);
        boolean loadFromClasspath = true;
        File f = new File(propertiesFile);
        if (f.exists() && !f.isDirectory()) {
            loadFromClasspath = false;
        }
        boolean bl3 = bl2 = (bl = loadFromClasspath);
        LoggingAspect.aspectOf().afterMethodExecuted(joinPoint, Conversions.booleanObject((boolean)bl2));
        return bl;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("LogfileHistoryServiceImpl.java", LogfileHistoryServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.common.api.TaskanaEngine", "taskanaEngine", "", "void"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.spi.history.api.events.task.TaskHistoryEvent", "event", "", "void"), 56);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.spi.history.api.events.workbasket.WorkbasketHistoryEvent", "event", "", "void"), 68);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent", "event", "", "void"), 80);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteHistoryEventsByTaskIds", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "java.util.List", "taskIds", "", "void"), 92);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "readPropertiesFromFile", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "java.lang.String", "propertiesFile", "", "java.util.Properties"), 96);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadFromClasspath", "pro.taskana.loghistory.impl.LogfileHistoryServiceImpl", "java.lang.String", "propertiesFile", "", "boolean"), 127);
    }
}

