/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.simplehistory.impl.task.TaskHistoryQuery;
import pro.taskana.simplehistory.impl.task.TaskHistoryQueryColumnName;
import pro.taskana.spi.history.api.events.task.TaskHistoryCustomField;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;

public class TaskHistoryQueryImpl
implements TaskHistoryQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.simplehistory.impl.task.TaskHistoryQueryMapper.queryHistoryEvents";
    private static final String LINK_TO_VALUE_MAPPER = "pro.taskana.simplehistory.impl.task.TaskHistoryQueryMapper.queryHistoryColumnValues";
    private static final String LINK_TO_COUNTER = "pro.taskana.simplehistory.impl.task.TaskHistoryQueryMapper.countHistoryEvents";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHistoryQueryImpl.class);
    private static final String SQL_EXCEPTION_MESSAGE = "Method openConnection() could not open a connection to the database.";
    private final TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private final List<String> orderBy;
    private final List<String> orderColumns;
    private TaskHistoryQueryColumnName columnName;
    private String[] idIn;
    private String[] businessProcessIdIn;
    private String[] parentBusinessProcessIdIn;
    private String[] taskIdIn;
    private String[] eventTypeIn;
    private TimeInterval[] createdIn;
    private String[] userIdIn;
    private String[] domainIn;
    private String[] workbasketKeyIn;
    private String[] porCompanyIn;
    private String[] porSystemIn;
    private String[] porInstanceIn;
    private String[] porTypeIn;
    private String[] porValueIn;
    private String[] taskClassificationKeyIn;
    private String[] taskClassificationCategoryIn;
    private String[] attachmentClassificationKeyIn;
    private String[] oldValueIn;
    private String[] newValueIn;
    private String[] custom1In;
    private String[] custom2In;
    private String[] custom3In;
    private String[] custom4In;
    private String[] businessProcessIdLike;
    private String[] parentBusinessProcessIdLike;
    private String[] taskIdLike;
    private String[] eventTypeLike;
    private String[] userIdLike;
    private String[] domainLike;
    private String[] workbasketKeyLike;
    private String[] porCompanyLike;
    private String[] porSystemLike;
    private String[] porInstanceLike;
    private String[] porTypeLike;
    private String[] porValueLike;
    private String[] taskClassificationKeyLike;
    private String[] taskClassificationCategoryLike;
    private String[] attachmentClassificationKeyLike;
    private String[] oldValueLike;
    private String[] newValueLike;
    private String[] custom1Like;
    private String[] custom2Like;
    private String[] custom3Like;
    private String[] custom4Like;

    public TaskHistoryQueryImpl(TaskanaHistoryEngineImpl taskanaHistoryEngine) {
        this.taskanaHistoryEngine = taskanaHistoryEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getBusinessProcessIdIn() {
        return this.businessProcessIdIn;
    }

    public String[] getParentBusinessProcessIdIn() {
        return this.parentBusinessProcessIdIn;
    }

    public String[] getTaskIdIn() {
        return this.taskIdIn;
    }

    public String[] getEventTypeIn() {
        return this.eventTypeIn;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public String[] getUserIdIn() {
        return this.userIdIn;
    }

    public String[] getDomainIn() {
        return this.domainIn;
    }

    public String[] getWorkbasketKeyIn() {
        return this.workbasketKeyIn;
    }

    public String[] getPorCompanyIn() {
        return this.porCompanyIn;
    }

    public String[] getPorSystemIn() {
        return this.porSystemIn;
    }

    public String[] getPorInstanceIn() {
        return this.porInstanceIn;
    }

    public String[] getPorTypeIn() {
        return this.porTypeIn;
    }

    public String[] getPorValueIn() {
        return this.porValueIn;
    }

    public String[] getTaskClassificationKeyIn() {
        return this.taskClassificationKeyIn;
    }

    public String[] getTaskClassificationCategoryIn() {
        return this.taskClassificationCategoryIn;
    }

    public String[] getAttachmentClassificationKeyIn() {
        return this.attachmentClassificationKeyIn;
    }

    public String[] getOldValueIn() {
        return this.oldValueIn;
    }

    public String[] getNewValueIn() {
        return this.newValueIn;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getBusinessProcessIdLike() {
        return this.businessProcessIdLike;
    }

    public String[] getParentBusinessProcessIdLike() {
        return this.parentBusinessProcessIdLike;
    }

    public String[] getTaskIdLike() {
        return this.taskIdLike;
    }

    public String[] getEventTypeLike() {
        return this.eventTypeLike;
    }

    public String[] getUserIdLike() {
        return this.userIdLike;
    }

    public String[] getDomainLike() {
        return this.domainLike;
    }

    public String[] getWorkbasketKeyLike() {
        return this.workbasketKeyLike;
    }

    public String[] getPorCompanyLike() {
        return this.porCompanyLike;
    }

    public String[] getPorSystemLike() {
        return this.porSystemLike;
    }

    public String[] getPorInstanceLike() {
        return this.porInstanceLike;
    }

    public String[] getPorTypeLike() {
        return this.porTypeLike;
    }

    public String[] getPorValueLike() {
        return this.porValueLike;
    }

    public String[] getTaskClassificationKeyLike() {
        return this.taskClassificationKeyLike;
    }

    public String[] getTaskClassificationCategoryLike() {
        return this.taskClassificationCategoryLike;
    }

    public String[] getAttachmentClassificationKeyLike() {
        return this.attachmentClassificationKeyLike;
    }

    public String[] getOldValueLike() {
        return this.oldValueLike;
    }

    public String[] getNewValueLike() {
        return this.newValueLike;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    @Override
    public TaskHistoryQuery idIn(String ... idIn) {
        this.idIn = this.toUpperCopy(idIn);
        return this;
    }

    @Override
    public TaskHistoryQuery businessProcessIdIn(String ... businessProcessId) {
        this.businessProcessIdIn = this.toUpperCopy(businessProcessId);
        return this;
    }

    @Override
    public TaskHistoryQuery parentBusinessProcessIdIn(String ... parentBusinessProcessId) {
        this.parentBusinessProcessIdIn = this.toUpperCopy(parentBusinessProcessId);
        return this;
    }

    @Override
    public TaskHistoryQuery taskIdIn(String ... taskId) {
        this.taskIdIn = this.toUpperCopy(taskId);
        return this;
    }

    @Override
    public TaskHistoryQuery eventTypeIn(String ... eventType) {
        this.eventTypeIn = this.toUpperCopy(eventType);
        return this;
    }

    @Override
    public TaskHistoryQuery createdWithin(TimeInterval ... createdIn) {
        this.createdIn = createdIn;
        return this;
    }

    @Override
    public TaskHistoryQuery userIdIn(String ... userId) {
        this.userIdIn = this.toUpperCopy(userId);
        return this;
    }

    @Override
    public TaskHistoryQuery domainIn(String ... domain) {
        this.domainIn = this.toUpperCopy(domain);
        return this;
    }

    @Override
    public TaskHistoryQuery workbasketKeyIn(String ... workbasketKey) {
        this.workbasketKeyIn = this.toUpperCopy(workbasketKey);
        return this;
    }

    @Override
    public TaskHistoryQuery porCompanyIn(String ... porCompany) {
        this.porCompanyIn = this.toUpperCopy(porCompany);
        return this;
    }

    @Override
    public TaskHistoryQuery porSystemIn(String ... porSystem) {
        this.porSystemIn = this.toUpperCopy(porSystem);
        return this;
    }

    @Override
    public TaskHistoryQuery porInstanceIn(String ... porInstance) {
        this.porInstanceIn = this.toUpperCopy(porInstance);
        return this;
    }

    @Override
    public TaskHistoryQuery porTypeIn(String ... porType) {
        this.porTypeIn = this.toUpperCopy(porType);
        return this;
    }

    @Override
    public TaskHistoryQuery porValueIn(String ... porValue) {
        this.porValueIn = this.toUpperCopy(porValue);
        return this;
    }

    @Override
    public TaskHistoryQuery taskClassificationKeyIn(String ... taskClassificationKey) {
        this.taskClassificationKeyIn = this.toUpperCopy(taskClassificationKey);
        return this;
    }

    @Override
    public TaskHistoryQuery taskClassificationCategoryIn(String ... taskClassificationCategory) {
        this.taskClassificationCategoryIn = this.toUpperCopy(taskClassificationCategory);
        return this;
    }

    @Override
    public TaskHistoryQuery attachmentClassificationKeyIn(String ... attachmentClassificationKey) {
        this.attachmentClassificationKeyIn = this.toUpperCopy(attachmentClassificationKey);
        return this;
    }

    @Override
    public TaskHistoryQuery oldValueIn(String ... oldValueIn) {
        this.oldValueIn = this.toUpperCopy(oldValueIn);
        return this;
    }

    @Override
    public TaskHistoryQuery newValueIn(String ... newValueIn) {
        this.newValueIn = this.toUpperCopy(newValueIn);
        return this;
    }

    @Override
    public TaskHistoryQuery businessProcessIdLike(String ... businessProcessId) {
        this.businessProcessIdLike = this.toUpperCopy(businessProcessId);
        return this;
    }

    @Override
    public TaskHistoryQuery parentBusinessProcessIdLike(String ... parentBusinessProcessId) {
        this.parentBusinessProcessIdLike = this.toUpperCopy(parentBusinessProcessId);
        return this;
    }

    @Override
    public TaskHistoryQuery taskIdLike(String ... taskId) {
        this.taskIdLike = this.toUpperCopy(taskId);
        return this;
    }

    @Override
    public TaskHistoryQuery eventTypeLike(String ... eventType) {
        this.eventTypeLike = this.toUpperCopy(eventType);
        return this;
    }

    @Override
    public TaskHistoryQuery userIdLike(String ... userId) {
        this.userIdLike = this.toUpperCopy(userId);
        return this;
    }

    @Override
    public TaskHistoryQuery domainLike(String ... domain) {
        this.domainLike = this.toUpperCopy(domain);
        return this;
    }

    @Override
    public TaskHistoryQuery workbasketKeyLike(String ... workbasketKey) {
        this.workbasketKeyLike = this.toUpperCopy(workbasketKey);
        return this;
    }

    @Override
    public TaskHistoryQuery porCompanyLike(String ... porCompany) {
        this.porCompanyLike = this.toUpperCopy(porCompany);
        return this;
    }

    @Override
    public TaskHistoryQuery porSystemLike(String ... porSystem) {
        this.porSystemLike = this.toUpperCopy(porSystem);
        return this;
    }

    @Override
    public TaskHistoryQuery porInstanceLike(String ... porInstance) {
        this.porInstanceLike = this.toUpperCopy(porInstance);
        return this;
    }

    @Override
    public TaskHistoryQuery porTypeLike(String ... porType) {
        this.porTypeLike = this.toUpperCopy(porType);
        return this;
    }

    @Override
    public TaskHistoryQuery porValueLike(String ... porValue) {
        this.porValueLike = this.toUpperCopy(porValue);
        return this;
    }

    @Override
    public TaskHistoryQuery taskClassificationKeyLike(String ... taskClassificationKey) {
        this.taskClassificationKeyLike = this.toUpperCopy(taskClassificationKey);
        return this;
    }

    @Override
    public TaskHistoryQuery taskClassificationCategoryLike(String ... taskClassificationCategory) {
        this.taskClassificationCategoryLike = this.toUpperCopy(taskClassificationCategory);
        return this;
    }

    @Override
    public TaskHistoryQuery attachmentClassificationKeyLike(String ... attachmentClassificationKey) {
        this.attachmentClassificationKeyLike = this.toUpperCopy(attachmentClassificationKey);
        return this;
    }

    @Override
    public TaskHistoryQuery oldValueLike(String ... oldValue) {
        this.oldValueLike = this.toUpperCopy(oldValue);
        return this;
    }

    @Override
    public TaskHistoryQuery newValueLike(String ... newValue) {
        this.newValueLike = this.toUpperCopy(newValue);
        return this;
    }

    @Override
    public TaskHistoryQuery customAttributeIn(TaskHistoryCustomField customField, String ... searchArguments) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_2: {
                this.custom2In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_3: {
                this.custom3In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_4: {
                this.custom4In = this.toUpperCopy(searchArguments);
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + customField + "'");
            }
        }
        return this;
    }

    @Override
    public TaskHistoryQuery customAttributeLike(TaskHistoryCustomField customField, String ... searchArguments) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_2: {
                this.custom2Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_3: {
                this.custom3Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_4: {
                this.custom4Like = this.toUpperCopy(searchArguments);
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + customField + "'");
            }
        }
        return this;
    }

    @Override
    public TaskHistoryQuery orderByBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByParentBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByTaskId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("TASK_ID", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByEventType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("EVENT_TYPE", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATED", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByUserId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("USER_ID", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_KEY", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByPorCompany(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_COMPANY", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByPorSystem(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_SYSTEM", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByPorInstance(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_INSTANCE", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByPorType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_TYPE", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByPorValue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_VALUE", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByTaskClassificationKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("TASK_CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByTaskClassificationCategory(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("TASK_CLASSIFICATION_CATEGORY", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByAttachmentClassificationKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ATTACHMENT_CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByOldValue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("OLD_VALUE", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByNewValue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NEW_VALUE", sortDirection);
    }

    @Override
    public TaskHistoryQuery orderByCustomAttribute(TaskHistoryCustomField customField, BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria(customField.name(), sortDirection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskHistoryEvent> list() {
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List<TaskHistoryEvent> result = new ArrayList<TaskHistoryEvent>();
        try {
            this.taskanaHistoryEngine.openConnection();
            List<TaskHistoryEvent> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<TaskHistoryEvent> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskHistoryEvent> list(int offset, int limit) {
        LOGGER.debug("entry to list({},{}), this = {}", new Object[]{offset, limit, this});
        List<Object> result = new ArrayList<TaskHistoryEvent>();
        try {
            this.taskanaHistoryEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List<Object> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<TaskHistoryEvent> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listValues(TaskHistoryQueryColumnName dbColumnName, BaseQuery.SortDirection sortDirection) {
        LOGGER.debug("entry to listValues() of column {} with sortDirection {}, this {}", new Object[]{dbColumnName, sortDirection, this});
        List<String> result = new ArrayList<String>();
        this.columnName = dbColumnName;
        this.orderBy.clear();
        this.addOrderCriteria(this.columnName.toString(), sortDirection);
        try {
            this.taskanaHistoryEngine.openConnection();
            List<String> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_VALUE_MAPPER, (Object)this);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.orderColumns.remove(this.orderColumns.size() - 1);
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskHistoryEvent single() {
        TaskHistoryEvent taskHistoryEvent;
        TaskHistoryEvent result;
        block8: {
            TaskHistoryEvent taskHistoryEvent2;
            block7: {
                LOGGER.debug("entry to single(), this = {}", (Object)this);
                result = null;
                try {
                    this.taskanaHistoryEngine.openConnection();
                    List results = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
                    if (results.isEmpty()) {
                        taskHistoryEvent2 = result;
                        this.taskanaHistoryEngine.returnConnection();
                        break block7;
                    }
                    taskHistoryEvent = result = (TaskHistoryEvent)results.get(0);
                    this.taskanaHistoryEngine.returnConnection();
                    break block8;
                }
                catch (SQLException e) {
                    LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
                    TaskHistoryEvent taskHistoryEvent3 = result;
                    return taskHistoryEvent3;
                }
            }
            LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
            return taskHistoryEvent2;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return taskHistoryEvent;
        finally {
            this.taskanaHistoryEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaHistoryEngine.openConnection();
            rowCount = (Long)this.taskanaHistoryEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaHistoryEngine.returnConnection();
        }
        catch (SQLException e) {
            long l2;
            try {
                LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
                l2 = -1L;
                this.taskanaHistoryEngine.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                LOGGER.debug("exit from count(). Returning result {} ", rowCount);
                throw throwable;
            }
            LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
            return l2;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private TaskHistoryQueryImpl addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection);
        this.orderBy.add(columnName + orderByDirection);
        this.orderColumns.add(columnName);
        return this;
    }
}

