/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.security.CurrentUserContext;
import pro.taskana.simplehistory.TaskanaHistoryEngine;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryEventMapper;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryEventMapper;
import pro.taskana.simplehistory.impl.task.TaskHistoryQueryMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryEventMapper;
import pro.taskana.simplehistory.impl.workbasket.WorkbasketHistoryQueryMapper;
import pro.taskana.spi.history.api.TaskanaHistory;

public class TaskanaHistoryEngineImpl
implements TaskanaHistoryEngine {
    protected static final ThreadLocal<Deque<SqlSessionManager>> SESSION_STACK = new ThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaHistoryEngineImpl.class);
    private static final String DEFAULT = "default";
    protected SqlSessionManager sessionManager;
    protected TransactionFactory transactionFactory;
    protected TaskanaHistory taskanaHistoryService;
    TaskanaEngineConfiguration taskanaEngineConfiguration;

    protected TaskanaHistoryEngineImpl(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.createTransactionFactory(this.taskanaEngineConfiguration.getUseManagedTransactions());
        this.sessionManager = this.createSqlSessionManager();
    }

    public static TaskanaHistoryEngineImpl createTaskanaEngine(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        return new TaskanaHistoryEngineImpl(taskanaEngineConfiguration);
    }

    @Override
    public TaskanaHistory getTaskanaHistoryService() {
        if (this.taskanaHistoryService == null) {
            SimpleHistoryServiceImpl historyService = new SimpleHistoryServiceImpl();
            historyService.initialize(this.taskanaEngineConfiguration.buildTaskanaEngine());
            this.taskanaHistoryService = historyService;
        }
        return this.taskanaHistoryService;
    }

    @Override
    public boolean isUserInRole(TaskanaRole ... roles) {
        if (!this.getConfiguration().isSecurityEnabled()) {
            return true;
        }
        Set rolesMembers = Arrays.stream(roles).map(role -> (Set)this.getConfiguration().getRoleMap().get(role)).collect(HashSet::new, Set::addAll, Set::addAll);
        return CurrentUserContext.getAccessIds().stream().anyMatch(rolesMembers::contains);
    }

    @Override
    public void checkRoleMembership(TaskanaRole ... roles) throws NotAuthorizedException {
        if (!this.isUserInRole(roles)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Throwing NotAuthorizedException because accessIds {} are not member of roles {}", (Object)CurrentUserContext.getAccessIds(), (Object)Arrays.toString(roles));
            }
            throw new NotAuthorizedException("current user is not member of role(s) " + Arrays.toString(roles), CurrentUserContext.getUserid());
        }
    }

    public TaskanaEngineConfiguration getConfiguration() {
        return this.taskanaEngineConfiguration;
    }

    protected SqlSessionManager createSqlSessionManager() {
        Environment environment = new Environment(DEFAULT, this.transactionFactory, this.taskanaEngineConfiguration.getDatasource());
        Configuration configuration = new Configuration(environment);
        configuration.addMapper(TaskHistoryEventMapper.class);
        configuration.addMapper(TaskHistoryQueryMapper.class);
        configuration.addMapper(WorkbasketHistoryEventMapper.class);
        configuration.addMapper(WorkbasketHistoryQueryMapper.class);
        configuration.addMapper(ClassificationHistoryEventMapper.class);
        configuration.addMapper(ClassificationHistoryQueryMapper.class);
        SqlSessionFactory localSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        return SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory);
    }

    protected static void pushSessionToStack(SqlSessionManager session) {
        TaskanaHistoryEngineImpl.getSessionStack().push(session);
    }

    protected static void popSessionFromStack() {
        Deque<SqlSessionManager> stack = TaskanaHistoryEngineImpl.getSessionStack();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    protected static Deque<SqlSessionManager> getSessionStack() {
        Deque<SqlSessionManager> stack = SESSION_STACK.get();
        if (stack == null) {
            stack = new ArrayDeque<SqlSessionManager>();
            SESSION_STACK.set(stack);
        }
        return stack;
    }

    protected static SqlSessionManager getSessionFromStack() {
        Deque<SqlSessionManager> stack = TaskanaHistoryEngineImpl.getSessionStack();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    void openConnection() throws SQLException {
        this.initSqlSession();
        this.sessionManager.getConnection().setSchema(this.taskanaEngineConfiguration.getSchemaName());
    }

    void returnConnection() {
        TaskanaHistoryEngineImpl.popSessionFromStack();
        if (TaskanaHistoryEngineImpl.getSessionStack().isEmpty() && this.sessionManager != null && this.sessionManager.isManagedSessionStarted()) {
            try {
                this.sessionManager.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sessionManager.close();
        }
    }

    void initSqlSession() {
        this.sessionManager.startManagedSession();
    }

    SqlSession getSqlSession() {
        return this.sessionManager;
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
    }
}

