/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationCustomField;
import pro.taskana.common.api.BaseQuery;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQuery;
import pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryColumnName;
import pro.taskana.spi.history.api.events.classification.ClassificationHistoryEvent;

public class ClassificationHistoryQueryImpl
implements ClassificationHistoryQuery {
    private static final String CLASSIFICATION_PACKAGE_PATH = "pro.taskana.simplehistory.impl.classification.";
    private static final String LINK_TO_MAPPER = "pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryMapper.queryHistoryEvents";
    private static final String LINK_TO_VALUE_MAPPER = "pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryMapper.queryHistoryColumnValues";
    private static final String LINK_TO_COUNTER = "pro.taskana.simplehistory.impl.classification.ClassificationHistoryQueryMapper.countHistoryEvents";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationHistoryQueryImpl.class);
    private static final String SQL_EXCEPTION_MESSAGE = "Method openConnection() could not open a connection to the database.";
    private final TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private final List<String> orderBy = new ArrayList<String>();
    private final List<String> orderColumns = new ArrayList<String>();
    private ClassificationHistoryQueryColumnName columnName;
    private String[] idIn;
    private String[] eventTypeIn;
    private TimeInterval[] createdIn;
    private String[] userIdIn;
    private String[] classificationIdIn;
    private String[] applicationEntryPointIn;
    private String[] categoryIn;
    private String[] domainIn;
    private String[] keyIn;
    private String[] nameIn;
    private String[] parentIdIn;
    private String[] parentKeyIn;
    private int[] priorityIn;
    private String[] serviceLevelIn;
    private String[] typeIn;
    private String[] custom1In;
    private String[] custom2In;
    private String[] custom3In;
    private String[] custom4In;
    private String[] custom5In;
    private String[] custom6In;
    private String[] custom7In;
    private String[] custom8In;
    private String[] eventTypeLike;
    private String[] userIdLike;
    private String[] classificationIdLike;
    private String[] applicationEntryPointLike;
    private String[] categoryLike;
    private String[] domainLike;
    private String[] keyLike;
    private String[] nameLike;
    private String[] parentIdLike;
    private String[] parentKeyLike;
    private String[] serviceLevelLike;
    private String[] typeLike;
    private String[] custom1Like;
    private String[] custom2Like;
    private String[] custom3Like;
    private String[] custom4Like;
    private String[] custom5Like;
    private String[] custom6Like;
    private String[] custom7Like;
    private String[] custom8Like;

    public ClassificationHistoryQueryImpl(TaskanaHistoryEngineImpl internalTaskanaHistoryEngine) {
        this.taskanaHistoryEngine = internalTaskanaHistoryEngine;
    }

    @Override
    public ClassificationHistoryQuery idIn(String ... idIn) {
        this.idIn = this.toUpperCopy(idIn);
        return this;
    }

    @Override
    public ClassificationHistoryQuery eventTypeIn(String ... eventType) {
        this.eventTypeIn = this.toUpperCopy(eventType);
        return this;
    }

    @Override
    public ClassificationHistoryQuery createdWithin(TimeInterval ... createdWithin) {
        this.createdIn = createdWithin;
        return this;
    }

    @Override
    public ClassificationHistoryQuery userIdIn(String ... userId) {
        this.userIdIn = this.toUpperCopy(userId);
        return this;
    }

    @Override
    public ClassificationHistoryQuery classificationIdIn(String ... classificationId) {
        this.classificationIdIn = this.toUpperCopy(classificationId);
        return this;
    }

    @Override
    public ClassificationHistoryQuery applicationEntryPointIn(String ... applicationEntryPoint) {
        this.applicationEntryPointIn = this.toUpperCopy(applicationEntryPoint);
        return this;
    }

    @Override
    public ClassificationHistoryQuery categoryIn(String ... category) {
        this.categoryIn = this.toUpperCopy(category);
        return this;
    }

    @Override
    public ClassificationHistoryQuery domainIn(String ... domain) {
        this.domainIn = this.toUpperCopy(domain);
        return this;
    }

    @Override
    public ClassificationHistoryQuery keyIn(String ... key) {
        this.keyIn = this.toUpperCopy(key);
        return this;
    }

    @Override
    public ClassificationHistoryQuery nameIn(String ... name) {
        this.nameIn = this.toUpperCopy(name);
        return this;
    }

    @Override
    public ClassificationHistoryQuery parentIdIn(String ... parentId) {
        this.parentIdIn = this.toUpperCopy(parentId);
        return this;
    }

    @Override
    public ClassificationHistoryQuery parentKeyIn(String ... parentKey) {
        this.parentKeyIn = this.toUpperCopy(parentKey);
        return this;
    }

    @Override
    public ClassificationHistoryQuery priorityIn(int ... priorities) {
        this.priorityIn = priorities;
        return this;
    }

    @Override
    public ClassificationHistoryQuery serviceLevelIn(String ... serviceLevelIn) {
        this.serviceLevelIn = serviceLevelIn;
        return this;
    }

    @Override
    public ClassificationHistoryQuery typeIn(String ... type) {
        this.typeIn = type;
        return this;
    }

    @Override
    public ClassificationHistoryQuery customAttributeIn(ClassificationCustomField customField, String ... searchArguments) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_2: {
                this.custom2In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_3: {
                this.custom3In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_4: {
                this.custom4In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_5: {
                this.custom5In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_6: {
                this.custom6In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_7: {
                this.custom7In = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_8: {
                this.custom8In = this.toUpperCopy(searchArguments);
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + customField + "'");
            }
        }
        return this;
    }

    @Override
    public ClassificationHistoryQuery eventTypeLike(String ... eventType) {
        this.eventTypeLike = this.toUpperCopy(eventType);
        return this;
    }

    @Override
    public ClassificationHistoryQuery userIdLike(String ... userId) {
        this.userIdLike = this.toUpperCopy(userId);
        return this;
    }

    @Override
    public ClassificationHistoryQuery classificationIdLike(String ... classificationId) {
        this.classificationIdLike = this.toUpperCopy(classificationId);
        return this;
    }

    @Override
    public ClassificationHistoryQuery applicationEntryPointLike(String ... applicationEntryPointLike) {
        this.applicationEntryPointLike = this.toUpperCopy(applicationEntryPointLike);
        return this;
    }

    @Override
    public ClassificationHistoryQuery categoryLike(String ... category) {
        this.categoryLike = this.toUpperCopy(category);
        return this;
    }

    @Override
    public ClassificationHistoryQuery domainLike(String ... domain) {
        this.domainLike = this.toUpperCopy(domain);
        return this;
    }

    @Override
    public ClassificationHistoryQuery keyLike(String ... key) {
        this.keyLike = this.toUpperCopy(key);
        return this;
    }

    @Override
    public ClassificationHistoryQuery nameLike(String ... name) {
        this.nameLike = this.toUpperCopy(name);
        return this;
    }

    @Override
    public ClassificationHistoryQuery parentIdLike(String ... parentId) {
        this.parentIdLike = this.toUpperCopy(parentId);
        return this;
    }

    @Override
    public ClassificationHistoryQuery parentKeyLike(String ... parentKey) {
        this.parentKeyLike = this.toUpperCopy(parentKey);
        return this;
    }

    @Override
    public ClassificationHistoryQuery serviceLevelLike(String ... serviceLevel) {
        this.serviceLevelLike = this.toUpperCopy(serviceLevel);
        return this;
    }

    @Override
    public ClassificationHistoryQuery typeLike(String ... type) {
        this.typeLike = this.toUpperCopy(type);
        return this;
    }

    @Override
    public ClassificationHistoryQuery customAttributeLike(ClassificationCustomField customField, String ... searchArguments) {
        switch (customField) {
            case CUSTOM_1: {
                this.custom1Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_2: {
                this.custom2Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_3: {
                this.custom3Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_4: {
                this.custom4Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_5: {
                this.custom5Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_6: {
                this.custom6Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_7: {
                this.custom7Like = this.toUpperCopy(searchArguments);
                break;
            }
            case CUSTOM_8: {
                this.custom8Like = this.toUpperCopy(searchArguments);
                break;
            }
            default: {
                throw new SystemException("Unknown customField '" + customField + "'");
            }
        }
        return this;
    }

    @Override
    public ClassificationHistoryQuery orderByEventType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("EVENT_TYPE", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATED", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByUserId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("USER_ID", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByClassificationId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CLASSIFICATION_ID", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByApplicationEntryPoint(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("APPLICATION_ENTRY_POINT", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByCategory(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CATEGORY", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("KEY", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByName(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NAME", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByParentId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_ID", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByParentKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_KEY", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByPriority(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PRIORITY", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByServiceLevel(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("SERVICE_LEVEL", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("TYPE", sortDirection);
    }

    @Override
    public ClassificationHistoryQuery orderByCustomAttribute(int num, BaseQuery.SortDirection sortDirection) throws InvalidArgumentException {
        switch (num) {
            case 1: {
                return this.addOrderCriteria("CUSTOM_1", sortDirection);
            }
            case 2: {
                return this.addOrderCriteria("CUSTOM_2", sortDirection);
            }
            case 3: {
                return this.addOrderCriteria("CUSTOM_3", sortDirection);
            }
            case 4: {
                return this.addOrderCriteria("CUSTOM_4", sortDirection);
            }
            case 5: {
                return this.addOrderCriteria("CUSTOM_5", sortDirection);
            }
            case 6: {
                return this.addOrderCriteria("CUSTOM_6", sortDirection);
            }
            case 7: {
                return this.addOrderCriteria("CUSTOM_7", sortDirection);
            }
            case 8: {
                return this.addOrderCriteria("CUSTOM_8", sortDirection);
            }
        }
        throw new InvalidArgumentException("Custom number has to be between 1 and 8, but this is: " + num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClassificationHistoryEvent> list() {
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List<ClassificationHistoryEvent> result = new ArrayList<ClassificationHistoryEvent>();
        try {
            this.taskanaHistoryEngine.openConnection();
            List<ClassificationHistoryEvent> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<ClassificationHistoryEvent> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClassificationHistoryEvent> list(int offset, int limit) {
        LOGGER.debug("entry to list({},{}), this = {}", new Object[]{offset, limit, this});
        List<Object> result = new ArrayList<ClassificationHistoryEvent>();
        try {
            this.taskanaHistoryEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List<Object> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<ClassificationHistoryEvent> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listValues(ClassificationHistoryQueryColumnName dbColumnName, BaseQuery.SortDirection sortDirection) {
        LOGGER.debug("entry to listValues() of column {} with sortDirection {}, this {}", new Object[]{dbColumnName, sortDirection, this});
        List<String> result = new ArrayList<String>();
        this.columnName = dbColumnName;
        ArrayList<String> cacheOrderBy = new ArrayList<String>(this.orderBy);
        this.orderBy.clear();
        this.addOrderCriteria(this.columnName.toString(), sortDirection);
        try {
            this.taskanaHistoryEngine.openConnection();
            List<String> list = result = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_VALUE_MAPPER, (Object)this);
            return list;
        }
        catch (SQLException e) {
            LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        finally {
            this.orderBy.addAll(cacheOrderBy);
            this.columnName = null;
            this.orderColumns.remove(this.orderColumns.size() - 1);
            this.taskanaHistoryEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)result.size(), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassificationHistoryEvent single() {
        ClassificationHistoryEvent classificationHistoryEvent;
        ClassificationHistoryEvent result;
        block8: {
            ClassificationHistoryEvent classificationHistoryEvent2;
            block7: {
                LOGGER.debug("entry to single(), this = {}", (Object)this);
                result = null;
                try {
                    this.taskanaHistoryEngine.openConnection();
                    List results = this.taskanaHistoryEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
                    if (results.isEmpty()) {
                        classificationHistoryEvent2 = result;
                        this.taskanaHistoryEngine.returnConnection();
                        break block7;
                    }
                    classificationHistoryEvent = result = (ClassificationHistoryEvent)results.get(0);
                    this.taskanaHistoryEngine.returnConnection();
                    break block8;
                }
                catch (SQLException e) {
                    LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
                    ClassificationHistoryEvent classificationHistoryEvent3 = result;
                    return classificationHistoryEvent3;
                }
            }
            LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
            return classificationHistoryEvent2;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return classificationHistoryEvent;
        finally {
            this.taskanaHistoryEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaHistoryEngine.openConnection();
            rowCount = (Long)this.taskanaHistoryEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaHistoryEngine.returnConnection();
        }
        catch (SQLException e) {
            long l2;
            try {
                LOGGER.error(SQL_EXCEPTION_MESSAGE, e.getCause());
                l2 = -1L;
                this.taskanaHistoryEngine.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaHistoryEngine.returnConnection();
                LOGGER.debug("exit from count(). Returning result {} ", rowCount);
                throw throwable;
            }
            LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
            return l2;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getEventTypeIn() {
        return this.eventTypeIn;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public String[] getUserIdIn() {
        return this.userIdIn;
    }

    public String[] getClassificationIdIn() {
        return this.classificationIdIn;
    }

    public String[] getApplicationEntryPointIn() {
        return this.applicationEntryPointIn;
    }

    public String[] getCategoryIn() {
        return this.categoryIn;
    }

    public String[] getDomainIn() {
        return this.domainIn;
    }

    public String[] getKeyIn() {
        return this.keyIn;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getParentIdIn() {
        return this.parentIdIn;
    }

    public String[] getParentKeyIn() {
        return this.parentKeyIn;
    }

    public int[] getPriorityIn() {
        return this.priorityIn;
    }

    public String[] getServiceLevelIn() {
        return this.serviceLevelIn;
    }

    public String[] getTypeIn() {
        return this.typeIn;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getCustom5In() {
        return this.custom5In;
    }

    public String[] getCustom6In() {
        return this.custom6In;
    }

    public String[] getCustom7In() {
        return this.custom7In;
    }

    public String[] getCustom8In() {
        return this.custom8In;
    }

    public String[] getEventTypeLike() {
        return this.eventTypeLike;
    }

    public String[] getUserIdLike() {
        return this.userIdLike;
    }

    public String[] getClassificationIdLike() {
        return this.classificationIdLike;
    }

    public String[] getApplicationEntryPointLike() {
        return this.applicationEntryPointLike;
    }

    public String[] getCategoryLike() {
        return this.categoryLike;
    }

    public String[] getDomainLike() {
        return this.domainLike;
    }

    public String[] getKeyLike() {
        return this.keyLike;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String[] getParentIdLike() {
        return this.parentIdLike;
    }

    public String[] getParentKeyLike() {
        return this.parentKeyLike;
    }

    public String[] getServiceLevelLike() {
        return this.serviceLevelLike;
    }

    public String[] getTypeLike() {
        return this.typeLike;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getCustom5Like() {
        return this.custom5Like;
    }

    public String[] getCustom6Like() {
        return this.custom6Like;
    }

    public String[] getCustom7Like() {
        return this.custom7Like;
    }

    public String[] getCustom8Like() {
        return this.custom8Like;
    }

    public ClassificationHistoryQueryColumnName getColumnName() {
        return this.columnName;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    private ClassificationHistoryQueryImpl addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection);
        this.orderBy.add(columnName + orderByDirection);
        this.orderColumns.add(columnName);
        return this;
    }
}

