/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.simplehistory.impl.jobs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngineConfiguration;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaEngine;
import pro.taskana.common.api.TimeInterval;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.api.exceptions.SystemException;
import pro.taskana.common.api.exceptions.TaskanaException;
import pro.taskana.common.internal.JobServiceImpl;
import pro.taskana.common.internal.jobs.AbstractTaskanaJob;
import pro.taskana.common.internal.transaction.TaskanaTransactionProvider;
import pro.taskana.simplehistory.impl.SimpleHistoryServiceImpl;
import pro.taskana.simplehistory.impl.TaskanaHistoryEngineImpl;
import pro.taskana.spi.history.api.events.task.TaskHistoryEvent;
import pro.taskana.spi.history.api.events.task.TaskHistoryEventType;

public class HistoryCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryCleanupJob.class);
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_JOB_HISTORY_BATCH_SIZE = "taskana.jobs.history.batchSize";
    private static final String TASKANA_JOB_HISTORY_CLEANUP_RUN_EVERY = "taskana.jobs.history.cleanup.runEvery";
    private static final String TASKANA_JOB_HISTORY_CLEANUP_FIRST_RUN = "taskana.jobs.history.cleanup.firstRunAt";
    private static final String TASKANA_JOB_HISTORY_CLEANUP_MINIMUM_AGE = "taskana.jobs.history.cleanup.minimumAge";
    private final boolean allCompletedSameParentBusiness;
    TaskanaHistoryEngineImpl taskanaHistoryEngine;
    private Instant firstRun;
    private Duration runEvery;
    private Duration minimumAge;
    private int batchSize;

    public HistoryCleanupJob(TaskanaEngine taskanaEngine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob scheduledJob) {
        super(taskanaEngine, txProvider, scheduledJob);
        this.taskanaHistoryEngine = TaskanaHistoryEngineImpl.createTaskanaEngine((TaskanaEngine)this.taskanaEngineImpl);
        this.firstRun = Instant.parse("2018-01-01T00:00:00Z");
        this.runEvery = Duration.parse("P1D");
        this.minimumAge = Duration.parse("P14D");
        this.batchSize = 100;
        this.allCompletedSameParentBusiness = taskanaEngine.getConfiguration().isTaskCleanupJobAllCompletedSameParentBusiness();
        Properties props = this.readPropertiesFromFile(TASKANA_PROPERTIES);
        this.initJobParameters(props);
    }

    public void run() throws TaskanaException {
        Instant createdBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all history events created before ({})", (Object)createdBefore);
        try {
            List<Object> taskIdsToDeleteHistoryEventsFor;
            SimpleHistoryServiceImpl simpleHistoryService = (SimpleHistoryServiceImpl)this.taskanaHistoryEngine.getTaskanaHistoryService();
            List historyEventCandidatesToClean = simpleHistoryService.createTaskHistoryQuery().createdWithin(new TimeInterval(null, createdBefore)).eventTypeIn(TaskHistoryEventType.COMPLETED.getName(), TaskHistoryEventType.CANCELLED.getName(), TaskHistoryEventType.TERMINATED.getName()).list();
            if (this.allCompletedSameParentBusiness) {
                String[] parentBusinessProcessIds = (String[])historyEventCandidatesToClean.stream().map(TaskHistoryEvent::getParentBusinessProcessId).distinct().toArray(String[]::new);
                historyEventCandidatesToClean.addAll(simpleHistoryService.createTaskHistoryQuery().parentBusinessProcessIdIn(parentBusinessProcessIds).eventTypeIn(TaskHistoryEventType.CREATED.getName()).list());
                taskIdsToDeleteHistoryEventsFor = this.filterSameParentBusinessHistoryEventsQualifiedToClean(historyEventCandidatesToClean);
            } else {
                taskIdsToDeleteHistoryEventsFor = historyEventCandidatesToClean.stream().map(TaskHistoryEvent::getTaskId).collect(Collectors.toList());
            }
            int totalNumberOfHistoryEventsDeleted = 0;
            while (!taskIdsToDeleteHistoryEventsFor.isEmpty()) {
                int upperLimit = this.batchSize;
                if (upperLimit > taskIdsToDeleteHistoryEventsFor.size()) {
                    upperLimit = taskIdsToDeleteHistoryEventsFor.size();
                }
                totalNumberOfHistoryEventsDeleted += this.deleteHistoryEventsTransactionally(taskIdsToDeleteHistoryEventsFor.subList(0, upperLimit));
                taskIdsToDeleteHistoryEventsFor.subList(0, upperLimit).clear();
            }
            LOGGER.info("Job ended successfully. {} history events deleted.", (Object)totalNumberOfHistoryEventsDeleted);
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing HistoryCleanupJob.", (Throwable)e);
        }
        finally {
            this.scheduleNextCleanupJob();
        }
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        JobServiceImpl jobService = (JobServiceImpl)taskanaEngine.getJobService();
        jobService.deleteJobs(ScheduledJob.Type.HISTORYCLEANUPJOB);
        HistoryCleanupJob job = new HistoryCleanupJob(taskanaEngine, null, null);
        job.scheduleNextCleanupJob();
    }

    private List<String> filterSameParentBusinessHistoryEventsQualifiedToClean(List<TaskHistoryEvent> historyEventCandidatesToClean) {
        Map historyEventsGroupedByParentBusinessProcessIdAndType = historyEventCandidatesToClean.stream().collect(Collectors.groupingBy(TaskHistoryEvent::getParentBusinessProcessId, Collectors.groupingBy(TaskHistoryEvent::getEventType, Collectors.mapping(TaskHistoryEvent::getTaskId, Collectors.toList()))));
        ArrayList<String> taskIdsToDeleteHistoryEventsFor = new ArrayList<String>();
        historyEventsGroupedByParentBusinessProcessIdAndType.entrySet().forEach(idsOfTasksInSameParentBusinessProcessGroupedByType -> {
            if (((List)((Map)idsOfTasksInSameParentBusinessProcessGroupedByType.getValue()).get(TaskHistoryEventType.CREATED.getName())).size() == ((Map)idsOfTasksInSameParentBusinessProcessGroupedByType.getValue()).entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(TaskHistoryEventType.CREATED.getName())).mapToInt(stringListEntry -> ((List)stringListEntry.getValue()).size()).sum()) {
                taskIdsToDeleteHistoryEventsFor.addAll((Collection)((Map)idsOfTasksInSameParentBusinessProcessGroupedByType.getValue()).get(TaskHistoryEventType.CREATED.getName()));
            }
        });
        return taskIdsToDeleteHistoryEventsFor;
    }

    private int deleteHistoryEventsTransactionally(List<String> taskIdsToDeleteHistoryEventsFor) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteHistoryEventsTransactionally(taskIdsToDeleteHistoryEventsFor = {})", taskIdsToDeleteHistoryEventsFor);
        }
        int deletedEventsCount = 0;
        if (this.txProvider != null) {
            int count = (Integer)this.txProvider.executeInTransaction(() -> {
                try {
                    return this.deleteEvents(taskIdsToDeleteHistoryEventsFor);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not delete history events.", (Throwable)e);
                    return 0;
                }
            });
            LOGGER.debug("exit from deleteHistoryEventsTransactionally(), returning {}", (Object)count);
            return count;
        }
        try {
            deletedEventsCount = this.deleteEvents(taskIdsToDeleteHistoryEventsFor);
        }
        catch (Exception e) {
            LOGGER.warn("Could not delete history events.", (Throwable)e);
        }
        LOGGER.debug("exit from deleteHistoryEventsTransactionally()(), returning {}", (Object)deletedEventsCount);
        return deletedEventsCount;
    }

    private int deleteEvents(List<String> taskIdsToDeleteHistoryEventsFor) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to deleteEvents(taskIdsToDeleteHistoryEventsFor = {})", taskIdsToDeleteHistoryEventsFor);
        }
        SimpleHistoryServiceImpl simpleHistoryService = (SimpleHistoryServiceImpl)this.taskanaHistoryEngine.getTaskanaHistoryService();
        String[] taskIdsArray = new String[taskIdsToDeleteHistoryEventsFor.size()];
        int deletedTasksCount = (int)simpleHistoryService.createTaskHistoryQuery().taskIdIn(taskIdsToDeleteHistoryEventsFor.toArray(taskIdsArray)).count();
        simpleHistoryService.deleteHistoryEventsByTaskIds(taskIdsToDeleteHistoryEventsFor);
        LOGGER.debug("{} events deleted.", (Object)deletedTasksCount);
        LOGGER.debug("exit from deleteEvents(), returning {}", (Object)taskIdsToDeleteHistoryEventsFor.size());
        return deletedTasksCount;
    }

    private void scheduleNextCleanupJob() {
        LOGGER.debug("Entry to scheduleNextCleanupJob.");
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.HISTORYCLEANUPJOB);
        job.setDue(this.getNextDueForHistoryCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        LOGGER.debug("Exit from scheduleNextCleanupJob.");
    }

    private Instant getNextDueForHistoryCleanupJob() {
        Instant nextRunAt = this.firstRun;
        while (nextRunAt.isBefore(Instant.now())) {
            nextRunAt = nextRunAt.plus(this.runEvery);
        }
        LOGGER.info("Scheduling next run of the HistoryCleanupJob for {}", (Object)nextRunAt);
        return nextRunAt;
    }

    private void initJobParameters(Properties props) {
        String historyEventCleanupJobMinimumAgeProperty;
        String historyCleanupJobRunEveryProperty;
        String historyCleanupJobFirstRunProperty;
        String jobBatchSizeProperty = props.getProperty(TASKANA_JOB_HISTORY_BATCH_SIZE);
        if (jobBatchSizeProperty != null && !jobBatchSizeProperty.isEmpty()) {
            try {
                this.batchSize = Integer.parseInt(jobBatchSizeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse jobBatchSizeProperty ({}). Using default. Exception: {} ", (Object)jobBatchSizeProperty, (Object)e.getMessage());
            }
        }
        if ((historyCleanupJobFirstRunProperty = props.getProperty(TASKANA_JOB_HISTORY_CLEANUP_FIRST_RUN)) != null && !historyCleanupJobFirstRunProperty.isEmpty()) {
            try {
                this.firstRun = Instant.parse(historyCleanupJobFirstRunProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse historyCleanupJobFirstRunProperty ({}). Using default. Exception: {} ", (Object)historyCleanupJobFirstRunProperty, (Object)e.getMessage());
            }
        }
        if ((historyCleanupJobRunEveryProperty = props.getProperty(TASKANA_JOB_HISTORY_CLEANUP_RUN_EVERY)) != null && !historyCleanupJobRunEveryProperty.isEmpty()) {
            try {
                this.runEvery = Duration.parse(historyCleanupJobRunEveryProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse historyCleanupJobRunEveryProperty ({}). Using default. Exception: {} ", (Object)historyCleanupJobRunEveryProperty, (Object)e.getMessage());
            }
        }
        if ((historyEventCleanupJobMinimumAgeProperty = props.getProperty(TASKANA_JOB_HISTORY_CLEANUP_MINIMUM_AGE)) != null && !historyEventCleanupJobMinimumAgeProperty.isEmpty()) {
            try {
                this.minimumAge = Duration.parse(historyEventCleanupJobMinimumAgeProperty);
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse historyEventCleanupJobMinimumAgeProperty ({}). Using default. Exception: {} ", (Object)historyEventCleanupJobMinimumAgeProperty, (Object)e.getMessage());
            }
        }
        LOGGER.debug("Configured number of history events per transaction: {}", (Object)this.batchSize);
        LOGGER.debug("HistoryCleanupJob configuration: first run at {}", (Object)this.firstRun);
        LOGGER.debug("HistoryCleanupJob configuration: runs every {}", (Object)this.runEvery);
        LOGGER.debug("HistoryCleanupJob configuration: minimum age of history events to be cleanup up is {}", (Object)this.minimumAge);
    }

    private Properties readPropertiesFromFile(String propertiesFile) {
        Properties props;
        block10: {
            props = new Properties();
            boolean loadFromClasspath = this.loadFromClasspath(propertiesFile);
            try {
                if (loadFromClasspath) {
                    InputStream inputStream = TaskanaEngineConfiguration.class.getResourceAsStream(propertiesFile);
                    if (inputStream == null) {
                        LOGGER.error("taskana properties file {} was not found on classpath.", (Object)propertiesFile);
                    } else {
                        props.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                        LOGGER.debug("taskana properties were loaded from file {} from classpath.", (Object)propertiesFile);
                    }
                    break block10;
                }
                try (FileInputStream fileInputStream = new FileInputStream(propertiesFile);){
                    props.load(fileInputStream);
                    LOGGER.debug("taskana properties were loaded from file {}.", (Object)propertiesFile);
                }
            }
            catch (IOException e) {
                LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
                throw new SystemException("internal System error when processing properties file " + propertiesFile, e.getCause());
            }
        }
        return props;
    }

    private boolean loadFromClasspath(String propertiesFile) {
        boolean loadFromClasspath = true;
        File f = new File(propertiesFile);
        if (f.exists() && !f.isDirectory()) {
            loadFromClasspath = false;
        }
        return loadFromClasspath;
    }
}

